// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BSplSLib_HeaderFile
#define _BSplSLib_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _BSplSLib_EvaluatorFunction_HeaderFile
#include <BSplSLib_EvaluatorFunction.hxx>
#endif
class TColgp_Array2OfPnt;
class TColStd_Array2OfReal;
class TColStd_Array1OfReal;
class TColStd_Array1OfInteger;
class gp_Pnt;
class gp_Vec;
class TColgp_Array1OfPnt;


//!  BSplSLib   B-spline surface Library <br>
//!  This  package provides   an  implementation  of  geometric <br>
//!  functions for rational and non rational, periodic  and non <br>
//!  periodic B-spline surface computation. <br>
//! <br>
//!  this package uses   the  multi-dimensions splines  methods <br>
//!  provided in the package BSplCLib. <br>
//! <br>
//!  In this package the B-spline surface is defined with : <br>
//!  . its control points :  Array2OfPnt     Poles <br>
//!  . its weights        :  Array2OfReal    Weights <br>
//!  . its knots and their multiplicity in the two parametric <br>
//!    direction U and V  :  Array1OfReal    UKnots, VKnots and <br>
//!                          Array1OfInteger UMults, VMults. <br>
//!  . the degree of the normalized Spline functions : <br>
//!                          UDegree, VDegree <br>
//! <br>
//!  . the Booleans URational, VRational to know if the weights <br>
//!  are constant in the U or V direction. <br>
//! <br>
//!  . the Booleans UPeriodic,   VRational  to know if the  the <br>
//!  surface is periodic in the U or V direction. <br>
//! <br>
//!   Warnings : The  bounds of UKnots  and UMults should be the <br>
//!  same, the bounds of VKnots and VMults should be  the same, <br>
//!  the bounds of Poles and Weights shoud be the same. <br>
class BSplSLib  {
public:

  DEFINE_STANDARD_ALLOC

  //! Computes  the     derivatives   of  a    ratio  of <br>
//!          two-variables functions  x(u,v) / w(u,v) at orders <br>
//!          <N,M>,    x(u,v)    is   a  vector in    dimension <br>
//!          <3>. <br>
//! <br>
//!          <Ders> is  an array  containing the values  of the <br>
//!          input derivatives from 0  to Min(<N>,<UDeg>), 0 to <br>
//!          Min(<M>,<VDeg>).    For orders    higher      than <br>
//!          <UDeg,VDeg>  the  input derivatives are assumed to <br>
//!          be 0. <br>
//! <br>
//!          The <Ders> is a 2d array and the  dimension of the <br>
//!          lines is always (<VDeg>+1) * (<3>+1), even <br>
//!          if   <N> is smaller  than  <Udeg> (the derivatives <br>
//!          higher than <N> are not used). <br>
//! <br>
//!          Content of <Ders> : <br>
//! <br>
//!          x(i,j)[k] means :  the composant  k of x derivated <br>
//!          (i) times in u and (j) times in v. <br>
//! <br>
//!          ... First line ... <br>
//! <br>
//!          x[1],x[2],...,x[3],w <br>
//!          x(0,1)[1],...,x(0,1)[3],w(1,0) <br>
//!          ... <br>
//!          x(0,VDeg)[1],...,x(0,VDeg)[3],w(0,VDeg) <br>
//! <br>
//!          ... Then second line ... <br>
//! <br>
//!          x(1,0)[1],...,x(1,0)[3],w(1,0) <br>
//!          x(1,1)[1],...,x(1,1)[3],w(1,1) <br>
//!          ... <br>
//!          x(1,VDeg)[1],...,x(1,VDeg)[3],w(1,VDeg) <br>
//! <br>
//!          ... <br>
//! <br>
//!          ... Last line ... <br>
//! <br>
//!          x(UDeg,0)[1],...,x(UDeg,0)[3],w(UDeg,0) <br>
//!          x(UDeg,1)[1],...,x(UDeg,1)[3],w(UDeg,1) <br>
//!          ... <br>
//!          x(Udeg,VDeg)[1],...,x(UDeg,VDeg)[3],w(Udeg,VDeg) <br>
//! <br>
//! <br>
//! <br>
//!          If <All>  is false, only  the derivative  at order <br>
//!          <N,M> is computed.  <RDers> is an  array of length <br>
//!          3 which will contain the result : <br>
//! <br>
//!          x(1)/w , x(2)/w ,  ... derivated <N> <M> times <br>
//! <br>
//!          If   <All>    is  true  multiples  derivatives are <br>
//!          computed. All the  derivatives (i,j) with 0 <= i+j <br>
//!          <= Max(N,M) are  computed.  <RDers> is an array of <br>
//!          length 3 *  (<N>+1)  * (<M>+1) which  will <br>
//!          contains : <br>
//! <br>
//!          x(1)/w , x(2)/w ,  ... <br>
//!          x(1)/w , x(2)/w ,  ... derivated <0,1> times <br>
//!          x(1)/w , x(2)/w ,  ... derivated <0,2> times <br>
//!          ... <br>
//!          x(1)/w , x(2)/w ,  ... derivated <0,N> times <br>
  Standard_EXPORT   static  void RationalDerivative(const Standard_Integer UDeg,const Standard_Integer VDeg,const Standard_Integer N,const Standard_Integer M,Standard_Real& Ders,Standard_Real& RDers,const Standard_Boolean All = Standard_True) ;
  
  Standard_EXPORT   static  void D0(const Standard_Real U,const Standard_Real V,const Standard_Integer UIndex,const Standard_Integer VIndex,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,const TColStd_Array1OfReal& UKnots,const TColStd_Array1OfReal& VKnots,const TColStd_Array1OfInteger& UMults,const TColStd_Array1OfInteger& VMults,const Standard_Integer UDegree,const Standard_Integer VDegree,const Standard_Boolean URat,const Standard_Boolean VRat,const Standard_Boolean UPer,const Standard_Boolean VPer,gp_Pnt& P) ;
  
  Standard_EXPORT   static  void D1(const Standard_Real U,const Standard_Real V,const Standard_Integer UIndex,const Standard_Integer VIndex,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,const TColStd_Array1OfReal& UKnots,const TColStd_Array1OfReal& VKnots,const TColStd_Array1OfInteger& UMults,const TColStd_Array1OfInteger& VMults,const Standard_Integer Degree,const Standard_Integer VDegree,const Standard_Boolean URat,const Standard_Boolean VRat,const Standard_Boolean UPer,const Standard_Boolean VPer,gp_Pnt& P,gp_Vec& Vu,gp_Vec& Vv) ;
  
  Standard_EXPORT   static  void D2(const Standard_Real U,const Standard_Real V,const Standard_Integer UIndex,const Standard_Integer VIndex,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,const TColStd_Array1OfReal& UKnots,const TColStd_Array1OfReal& VKnots,const TColStd_Array1OfInteger& UMults,const TColStd_Array1OfInteger& VMults,const Standard_Integer UDegree,const Standard_Integer VDegree,const Standard_Boolean URat,const Standard_Boolean VRat,const Standard_Boolean UPer,const Standard_Boolean VPer,gp_Pnt& P,gp_Vec& Vu,gp_Vec& Vv,gp_Vec& Vuu,gp_Vec& Vvv,gp_Vec& Vuv) ;
  
  Standard_EXPORT   static  void D3(const Standard_Real U,const Standard_Real V,const Standard_Integer UIndex,const Standard_Integer VIndex,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,const TColStd_Array1OfReal& UKnots,const TColStd_Array1OfReal& VKnots,const TColStd_Array1OfInteger& UMults,const TColStd_Array1OfInteger& VMults,const Standard_Integer UDegree,const Standard_Integer VDegree,const Standard_Boolean URat,const Standard_Boolean VRat,const Standard_Boolean UPer,const Standard_Boolean VPer,gp_Pnt& P,gp_Vec& Vu,gp_Vec& Vv,gp_Vec& Vuu,gp_Vec& Vvv,gp_Vec& Vuv,gp_Vec& Vuuu,gp_Vec& Vvvv,gp_Vec& Vuuv,gp_Vec& Vuvv) ;
  
  Standard_EXPORT   static  void DN(const Standard_Real U,const Standard_Real V,const Standard_Integer Nu,const Standard_Integer Nv,const Standard_Integer UIndex,const Standard_Integer VIndex,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,const TColStd_Array1OfReal& UKnots,const TColStd_Array1OfReal& VKnots,const TColStd_Array1OfInteger& UMults,const TColStd_Array1OfInteger& VMults,const Standard_Integer UDegree,const Standard_Integer VDegree,const Standard_Boolean URat,const Standard_Boolean VRat,const Standard_Boolean UPer,const Standard_Boolean VPer,gp_Vec& Vn) ;
  //! Computes the  poles and weights of an isoparametric <br>
//!          curve at parameter  <Param> (UIso if <IsU> is True, <br>
//!          VIso  else). <br>
  Standard_EXPORT   static  void Iso(const Standard_Real Param,const Standard_Boolean IsU,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,const TColStd_Array1OfReal& Knots,const TColStd_Array1OfInteger& Mults,const Standard_Integer Degree,const Standard_Boolean Periodic,TColgp_Array1OfPnt& CPoles,TColStd_Array1OfReal& CWeights) ;
  //! Reverses the array of poles. Last is the Index of <br>
//!          the new first Row( Col) of Poles. <br>
//!          On  a  non periodic surface Last is <br>
//!               Poles.Upper(). <br>
//!          On a periodic curve last is <br>
//!               (number of flat knots - degree - 1) <br>
//!          or <br>
//!               (sum of multiplicities(but  for the last) + degree <br>
//!                - 1) <br>
  Standard_EXPORT   static  void Reverse(TColgp_Array2OfPnt& Poles,const Standard_Integer Last,const Standard_Boolean UDirection) ;
  //!  Makes an homogeneous  evaluation of Poles and Weights <br>
//!           any and returns in P the Numerator value and <br>
//!           in W the Denominator value if Weights are present <br>
//!           otherwise returns 1.0e0 <br>
//! <br>
  Standard_EXPORT   static  void HomogeneousD0(const Standard_Real U,const Standard_Real V,const Standard_Integer UIndex,const Standard_Integer VIndex,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,const TColStd_Array1OfReal& UKnots,const TColStd_Array1OfReal& VKnots,const TColStd_Array1OfInteger& UMults,const TColStd_Array1OfInteger& VMults,const Standard_Integer UDegree,const Standard_Integer VDegree,const Standard_Boolean URat,const Standard_Boolean VRat,const Standard_Boolean UPer,const Standard_Boolean VPer,Standard_Real& W,gp_Pnt& P) ;
  //!  Makes an homogeneous  evaluation of Poles and Weights <br>
//!           any and returns in P the Numerator value and <br>
//!           in W the Denominator value if Weights are present <br>
//!           otherwise returns 1.0e0 <br>
//! <br>
  Standard_EXPORT   static  void HomogeneousD1(const Standard_Real U,const Standard_Real V,const Standard_Integer UIndex,const Standard_Integer VIndex,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,const TColStd_Array1OfReal& UKnots,const TColStd_Array1OfReal& VKnots,const TColStd_Array1OfInteger& UMults,const TColStd_Array1OfInteger& VMults,const Standard_Integer UDegree,const Standard_Integer VDegree,const Standard_Boolean URat,const Standard_Boolean VRat,const Standard_Boolean UPer,const Standard_Boolean VPer,gp_Pnt& N,gp_Vec& Nu,gp_Vec& Nv,Standard_Real& D,Standard_Real& Du,Standard_Real& Dv) ;
  //! Reverses the array of weights. <br>
  Standard_EXPORT   static  void Reverse(TColStd_Array2OfReal& Weights,const Standard_Integer Last,const Standard_Boolean UDirection) ;
  
//!   Returns False if all the weights  of the  array <Weights> <br>
//!   in the area [I1,I2] * [J1,J2] are  identic. <br>
//!   Epsilon  is used for comparing  weights. <br>
//!   If Epsilon  is 0. the  Epsilon of the first weight is used. <br>
  Standard_EXPORT   static  Standard_Boolean IsRational(const TColStd_Array2OfReal& Weights,const Standard_Integer I1,const Standard_Integer I2,const Standard_Integer J1,const Standard_Integer J2,const Standard_Real Epsilon = 0.0) ;
  //! Copy in FP the coordinates of the poles. <br>
  Standard_EXPORT   static  void SetPoles(const TColgp_Array2OfPnt& Poles,TColStd_Array1OfReal& FP,const Standard_Boolean UDirection) ;
  //! Copy in FP the coordinates of the poles. <br>
  Standard_EXPORT   static  void SetPoles(const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,TColStd_Array1OfReal& FP,const Standard_Boolean UDirection) ;
  //! Get from FP the coordinates of the poles. <br>
  Standard_EXPORT   static  void GetPoles(const TColStd_Array1OfReal& FP,TColgp_Array2OfPnt& Poles,const Standard_Boolean UDirection) ;
  //! Get from FP the coordinates of the poles. <br>
  Standard_EXPORT   static  void GetPoles(const TColStd_Array1OfReal& FP,TColgp_Array2OfPnt& Poles,TColStd_Array2OfReal& Weights,const Standard_Boolean UDirection) ;
  //! Find the new poles which allows an old point (with a <br>
//!          given u,v  as parameters)  to  reach a  new position <br>
//!          UIndex1,UIndex2 indicate the  range of poles we can <br>
//!          move for U <br>
//!          (1, UNbPoles-1) or (2, UNbPoles) -> no constraint <br>
//!          for one side in U <br>
//!          (2, UNbPoles-1)   -> the ends are enforced for U <br>
//!          don't enter (1,NbPoles) and (1,VNbPoles) <br>
//!                -> error: rigid move <br>
//!          if problem in BSplineBasis calculation, no change <br>
//!          for the curve  and <br>
//!              UFirstIndex, VLastIndex = 0 <br>
//!              VFirstIndex, VLastIndex = 0 <br>
  Standard_EXPORT   static  void MovePoint(const Standard_Real U,const Standard_Real V,const gp_Vec& Displ,const Standard_Integer UIndex1,const Standard_Integer UIndex2,const Standard_Integer VIndex1,const Standard_Integer VIndex2,const Standard_Integer UDegree,const Standard_Integer VDegree,const Standard_Boolean Rational,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,const TColStd_Array1OfReal& UFlatKnots,const TColStd_Array1OfReal& VFlatKnots,Standard_Integer& UFirstIndex,Standard_Integer& ULastIndex,Standard_Integer& VFirstIndex,Standard_Integer& VLastIndex,TColgp_Array2OfPnt& NewPoles) ;
  
  Standard_EXPORT   static  void InsertKnots(const Standard_Boolean UDirection,const Standard_Integer Degree,const Standard_Boolean Periodic,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,const TColStd_Array1OfReal& Knots,const TColStd_Array1OfInteger& Mults,const TColStd_Array1OfReal& AddKnots,const TColStd_Array1OfInteger& AddMults,TColgp_Array2OfPnt& NewPoles,TColStd_Array2OfReal& NewWeights,TColStd_Array1OfReal& NewKnots,TColStd_Array1OfInteger& NewMults,const Standard_Real Epsilon,const Standard_Boolean Add = Standard_True) ;
  
  Standard_EXPORT   static  Standard_Boolean RemoveKnot(const Standard_Boolean UDirection,const Standard_Integer Index,const Standard_Integer Mult,const Standard_Integer Degree,const Standard_Boolean Periodic,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,const TColStd_Array1OfReal& Knots,const TColStd_Array1OfInteger& Mults,TColgp_Array2OfPnt& NewPoles,TColStd_Array2OfReal& NewWeights,TColStd_Array1OfReal& NewKnots,TColStd_Array1OfInteger& NewMults,const Standard_Real Tolerance) ;
  
  Standard_EXPORT   static  void IncreaseDegree(const Standard_Boolean UDirection,const Standard_Integer Degree,const Standard_Integer NewDegree,const Standard_Boolean Periodic,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,const TColStd_Array1OfReal& Knots,const TColStd_Array1OfInteger& Mults,TColgp_Array2OfPnt& NewPoles,TColStd_Array2OfReal& NewWeights,TColStd_Array1OfReal& NewKnots,TColStd_Array1OfInteger& NewMults) ;
  
  Standard_EXPORT   static  void Unperiodize(const Standard_Boolean UDirection,const Standard_Integer Degree,const TColStd_Array1OfInteger& Mults,const TColStd_Array1OfReal& Knots,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,TColStd_Array1OfInteger& NewMults,TColStd_Array1OfReal& NewKnots,TColgp_Array2OfPnt& NewPoles,TColStd_Array2OfReal& NewWeights) ;
  //! Used as argument for a non rational curve. <br>
//! <br>
      static  TColStd_Array2OfReal& NoWeights() ;
  //! Perform the evaluation of the Taylor expansion <br>
//!          of the Bspline normalized between 0 and 1. <br>
//!          If rational computes the homogeneous Taylor expension <br>
//!          for the numerator and stores it in CachePoles <br>
//! <br>
//! <br>
  Standard_EXPORT   static  void BuildCache(const Standard_Real U,const Standard_Real V,const Standard_Real USpanDomain,const Standard_Real VSpanDomain,const Standard_Boolean UPeriodicFlag,const Standard_Boolean VPeriodicFlag,const Standard_Integer UDegree,const Standard_Integer VDegree,const Standard_Integer UIndex,const Standard_Integer VIndex,const TColStd_Array1OfReal& UFlatKnots,const TColStd_Array1OfReal& VFlatKnots,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,TColgp_Array2OfPnt& CachePoles,TColStd_Array2OfReal& CacheWeights) ;
  //! Perform the evaluation of the of the cache <br>
//!          the parameter must be normalized between <br>
//!          the 0 and 1 for the span. <br>
//!          The Cache must be valid when calling this <br>
//!          routine. Geom Package will insure that. <br>
//!          and then multiplies by the weights <br>
//!          this just evaluates the current point <br>
//!          the CacheParameter is where the Cache was <br>
//!          constructed the SpanLength is to normalize <br>
//!          the polynomial in the cache to avoid bad conditioning <br>
//!          effects <br>
//! <br>
  Standard_EXPORT   static  void CacheD0(const Standard_Real U,const Standard_Real V,const Standard_Integer UDegree,const Standard_Integer VDegree,const Standard_Real UCacheParameter,const Standard_Real VCacheParameter,const Standard_Real USpanLenght,const Standard_Real VSpanLength,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,gp_Pnt& Point) ;
  //! Calls CacheD0 for Bezier Surfaces Arrays computed with <br>
//!          the method PolesCoefficients. <br>
//!  Warning: To be used for BezierSurfaces ONLY!!! <br>
      static  void CoefsD0(const Standard_Real U,const Standard_Real V,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,gp_Pnt& Point) ;
  //! Perform the evaluation of the of the cache <br>
//!          the parameter must be normalized between <br>
//!          the 0 and 1 for the span. <br>
//!          The Cache must be valid when calling this <br>
//!          routine. Geom Package will insure that. <br>
//!          and then multiplies by the weights <br>
//!          this just evaluates the current point <br>
//!          the CacheParameter is where the Cache was <br>
//!          constructed the SpanLength is to normalize <br>
//!          the polynomial in the cache to avoid bad conditioning <br>
//!          effects <br>
//! <br>
  Standard_EXPORT   static  void CacheD1(const Standard_Real U,const Standard_Real V,const Standard_Integer UDegree,const Standard_Integer VDegree,const Standard_Real UCacheParameter,const Standard_Real VCacheParameter,const Standard_Real USpanLenght,const Standard_Real VSpanLength,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,gp_Pnt& Point,gp_Vec& VecU,gp_Vec& VecV) ;
  //! Calls CacheD0 for Bezier Surfaces Arrays computed with <br>
//!          the method PolesCoefficients. <br>
//!  Warning: To be used for BezierSurfaces ONLY!!! <br>
      static  void CoefsD1(const Standard_Real U,const Standard_Real V,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,gp_Pnt& Point,gp_Vec& VecU,gp_Vec& VecV) ;
  //! Perform the evaluation of the of the cache <br>
//!          the parameter must be normalized between <br>
//!          the 0 and 1 for the span. <br>
//!          The Cache must be valid when calling this <br>
//!          routine. Geom Package will insure that. <br>
//!          and then multiplies by the weights <br>
//!          this just evaluates the current point <br>
//!          the CacheParameter is where the Cache was <br>
//!          constructed the SpanLength is to normalize <br>
//!          the polynomial in the cache to avoid bad conditioning <br>
//!          effects <br>
//! <br>
  Standard_EXPORT   static  void CacheD2(const Standard_Real U,const Standard_Real V,const Standard_Integer UDegree,const Standard_Integer VDegree,const Standard_Real UCacheParameter,const Standard_Real VCacheParameter,const Standard_Real USpanLenght,const Standard_Real VSpanLength,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,gp_Pnt& Point,gp_Vec& VecU,gp_Vec& VecV,gp_Vec& VecUU,gp_Vec& VecUV,gp_Vec& VecVV) ;
  //! Calls CacheD0 for Bezier Surfaces Arrays computed with <br>
//!          the method PolesCoefficients. <br>
//!  Warning: To be used for BezierSurfaces ONLY!!! <br>
      static  void CoefsD2(const Standard_Real U,const Standard_Real V,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,gp_Pnt& Point,gp_Vec& VecU,gp_Vec& VecV,gp_Vec& VecUU,gp_Vec& VecUV,gp_Vec& VecVV) ;
  //!  Warning! To be used for BezierSurfaces ONLY!!! <br>
      static  void PolesCoefficients(const TColgp_Array2OfPnt& Poles,TColgp_Array2OfPnt& CachePoles) ;
  //! Encapsulation   of  BuildCache    to   perform   the <br>
//!          evaluation  of the Taylor expansion for beziersurfaces <br>
//!          at parameters 0.,0.; <br>
//!  Warning: To be used for BezierSurfaces ONLY!!! <br>
//! <br>
  Standard_EXPORT   static  void PolesCoefficients(const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,TColgp_Array2OfPnt& CachePoles,TColStd_Array2OfReal& CacheWeights) ;
  //! Given a tolerance in 3D space returns two <br>
//!          tolerances, one in U one in V such that for <br>
//!          all (u1,v1) and (u0,v0) in the domain of <br>
//!          the surface f(u,v)  we have : <br>
//!          | u1 - u0 | < UTolerance and <br>
//!          | v1 - v0 | < VTolerance <br>
//!          we have |f (u1,v1) - f (u0,v0)| < Tolerance3D <br>
  Standard_EXPORT   static  void Resolution(const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,const TColStd_Array1OfReal& UKnots,const TColStd_Array1OfReal& VKnots,const TColStd_Array1OfInteger& UMults,const TColStd_Array1OfInteger& VMults,const Standard_Integer UDegree,const Standard_Integer VDegree,const Standard_Boolean URat,const Standard_Boolean VRat,const Standard_Boolean UPer,const Standard_Boolean VPer,const Standard_Real Tolerance3D,Standard_Real& UTolerance,Standard_Real& VTolerance) ;
  //! Performs the interpolation of the data points given in <br>
//!                 the   Poles       array      in   the      form <br>
//!            [1,...,RL][1,...,RC][1...PolesDimension]    .    The <br>
//!          ColLength CL and the Length of UParameters must be the <br>
//!          same. The length of VFlatKnots is VDegree + CL + 1. <br>
//! <br>
//!          The  RowLength RL and the Length of VParameters must be <br>
//!          the  same. The length of VFlatKnots is Degree + RL + 1. <br>
//! <br>
//!  Warning: the method used  to do that  interpolation <br>
//!          is gauss  elimination  WITHOUT pivoting.  Thus if  the <br>
//!          diagonal is not  dominant  there is no guarantee  that <br>
//!          the   algorithm will    work.  Nevertheless  for Cubic <br>
//!          interpolation  at knots or interpolation at Scheonberg <br>
//!          points  the method   will work.  The  InversionProblem <br>
//!          will  report 0 if there   was no problem  else it will <br>
//!          give the index of the faulty pivot <br>
  Standard_EXPORT   static  void Interpolate(const Standard_Integer UDegree,const Standard_Integer VDegree,const TColStd_Array1OfReal& UFlatKnots,const TColStd_Array1OfReal& VFlatKnots,const TColStd_Array1OfReal& UParameters,const TColStd_Array1OfReal& VParameters,TColgp_Array2OfPnt& Poles,TColStd_Array2OfReal& Weights,Standard_Integer& InversionProblem) ;
  //! Performs the interpolation of the data points given in <br>
//!          the  Poles array. <br>
//!          The  ColLength CL and the Length of UParameters must be <br>
//!          the  same. The length of VFlatKnots is VDegree + CL + 1. <br>
//! <br>
//!          The  RowLength RL and the Length of VParameters must be <br>
//!          the  same. The length of VFlatKnots is Degree + RL + 1. <br>
//! <br>
//! Warning: the method used  to do that  interpolation <br>
//!          is gauss  elimination  WITHOUT pivoting.  Thus if  the <br>
//!          diagonal is not  dominant  there is no guarantee  that <br>
//!          the   algorithm will    work.  Nevertheless  for Cubic <br>
//!          interpolation  at knots or interpolation at Scheonberg <br>
//!          points  the method   will work.  The  InversionProblem <br>
//!          will  report 0 if there   was no problem  else it will <br>
//!          give the index of the faulty pivot <br>
  Standard_EXPORT   static  void Interpolate(const Standard_Integer UDegree,const Standard_Integer VDegree,const TColStd_Array1OfReal& UFlatKnots,const TColStd_Array1OfReal& VFlatKnots,const TColStd_Array1OfReal& UParameters,const TColStd_Array1OfReal& VParameters,TColgp_Array2OfPnt& Poles,Standard_Integer& InversionProblem) ;
  //! this will multiply  a given BSpline numerator  N(u,v) <br>
//!             and    denominator    D(u,v)  defined     by   its <br>
//!             U/VBSplineDegree   and    U/VBSplineKnots,     and <br>
//!          U/VMults. Its Poles  and Weights are arrays which are <br>
//!                coded   as      array2      of      the    form <br>
//!            [1..UNumPoles][1..VNumPoles]  by  a function a(u,v) <br>
//!           which  is assumed  to satisfy    the following :  1. <br>
//!          a(u,v)  * N(u,v) and a(u,v) *  D(u,v)  is a polynomial <br>
//!          BSpline that can be expressed exactly as a BSpline of <br>
//!          degree U/VNewDegree  on  the knots U/VFlatKnots 2. the range <br>
//!           of a(u,v) is   the   same as  the range   of  N(u,v) <br>
//!           or D(u,v) <br>
//!          ---Warning:  it is   the caller's  responsability  to <br>
//!          insure that conditions 1. and  2. above are satisfied <br>
//!          : no  check  whatsoever is made   in  this method  -- <br>
//!          Status will  return 0 if  OK else it will return  the <br>
//!            pivot index -- of the   matrix that was inverted to <br>
//!           compute the multiplied -- BSpline  : the method used <br>
//!           is  interpolation   at Schoenenberg   --  points  of <br>
//!          a(u,v)* N(u,v) and a(u,v) * D(u,v) <br>
//! Status will return 0 if OK else it will return the pivot index <br>
//!        of the matrix that was inverted to compute the multiplied <br>
//!        BSpline : the method used is interpolation at Schoenenberg <br>
//!        points of a(u,v)*F(u,v) <br>
//!             -- <br>
//! <br>
  Standard_EXPORT   static  void FunctionMultiply(const BSplSLib_EvaluatorFunction& Function,const Standard_Integer UBSplineDegree,const Standard_Integer VBSplineDegree,const TColStd_Array1OfReal& UBSplineKnots,const TColStd_Array1OfReal& VBSplineKnots,const TColStd_Array1OfInteger& UMults,const TColStd_Array1OfInteger& VMults,const TColgp_Array2OfPnt& Poles,const TColStd_Array2OfReal& Weights,const TColStd_Array1OfReal& UFlatKnots,const TColStd_Array1OfReal& VFlatKnots,const Standard_Integer UNewDegree,const Standard_Integer VNewDegree,TColgp_Array2OfPnt& NewNumerator,TColStd_Array2OfReal& NewDenominator,Standard_Integer& Status) ;





protected:





private:





};


#include <BSplSLib.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
