// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BOP_SDFWESFiller_HeaderFile
#define _BOP_SDFWESFiller_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _BOPTools_PDSFiller_HeaderFile
#include <BOPTools_PDSFiller.hxx>
#endif
#ifndef _BOP_Operation_HeaderFile
#include <BOP_Operation.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BOP_PWireEdgeSet_HeaderFile
#include <BOP_PWireEdgeSet.hxx>
#endif
#ifndef _BOPTools_IndexedDataMapOfIntegerState_HeaderFile
#include <BOPTools_IndexedDataMapOfIntegerState.hxx>
#endif
#ifndef _TopTools_ListOfShape_HeaderFile
#include <TopTools_ListOfShape.hxx>
#endif
class BOPTools_DSFiller;
class BOPTools_IndexedDataMapOfIntegerState;
class BOP_WireEdgeSet;
class TopoDS_Face;
class TopTools_ListOfShape;



//!  The  algorithm that fills a wire edges set (WES) <br>
//!  for a couple of faces that are same domain <br>
//! <br>
class BOP_SDFWESFiller  {
public:

  DEFINE_STANDARD_ALLOC

  
//! Empty constructor <br>
  Standard_EXPORT   BOP_SDFWESFiller();
  
//! Constructor <br>
//! nF1, nF2 - indices of faces in the DataStructue (DS) <br>
  Standard_EXPORT   BOP_SDFWESFiller(const Standard_Integer nF1,const Standard_Integer nF2,const BOPTools_DSFiller& aDSF);
  
//! Modifier <br>
  Standard_EXPORT     void SetStatesMap(const BOPTools_IndexedDataMapOfIntegerState& aStatesMap) ;
  
//! Modifier <br>
  Standard_EXPORT     void SetFaces(const Standard_Integer nF1,const Standard_Integer nF2) ;
  
//! Modifier <br>
  Standard_EXPORT     void SetDSFiller(const BOPTools_DSFiller& aDSF) ;
  
//! Modifier <br>
  Standard_EXPORT     void SetOperation(const BOP_Operation anOp) ;
  
//! Modifier <br>
//! Assigns sensitivity flag for the faces in accordance <br>
//! with scalar product between theirs normalls <br>
//! 1  for same sense;  -1 for different sense <br>
  Standard_EXPORT     void SetSenseFlag(const Standard_Integer aFlag) ;
  
//! Prepares data for the algorithm <br>
  Standard_EXPORT     void Prepare() ;
  
//! Performs the algorithm <br>
  Standard_EXPORT     void Do(const BOP_WireEdgeSet& aWES) ;
  
//! Selector <br>
  Standard_EXPORT    const BOPTools_DSFiller& DSFiller() const;
  
//! Selector <br>
  Standard_EXPORT    const BOPTools_IndexedDataMapOfIntegerState& StatesMap() const;
  
//! Selector <br>
  Standard_EXPORT     void Faces(Standard_Integer& nF1,Standard_Integer& nF2) const;
  
//! Selector <br>
  Standard_EXPORT     Standard_Integer SenseFlag() const;
  
//! Selector <br>
  Standard_EXPORT     BOP_Operation Operation() const;
  
//! Update 3D-State for edges <br>
  Standard_EXPORT     void UpdateDEStates3D() ;
  
//!  Returns all split edges of nF1 that are CB with <br>
//!  splis of nF1 but not included in myWES, <br>
  Standard_EXPORT    const TopTools_ListOfShape& RejectedOnParts() const;





protected:





private:

  
//! Assigns the 2D-State for split parts of <br>
//! the edges having 3D-Curves of given faces <br>
//! Internal  Purpose <br>
  Standard_EXPORT     void AssignStates(const Standard_Integer nF1,const Standard_Integer nF2) ;
  
//! Prepares ON 2D parts to filled the WES <br>
//! Internal Purpose <br>
  Standard_EXPORT     void PrepareOnParts() ;
  
//! Fills the WES by split parts of the edges for <br>
//! the Common Zone <br>
//! Internal Purpose <br>
  Standard_EXPORT     void PrepareWESForZone(const Standard_Integer nF1,const Standard_Integer nF2) ;
  
//! Fills the WES by split parts of the edges for <br>
//! the Cut operation <br>
//! Internal Purpose <br>
//! <br>
  Standard_EXPORT     void PrepareWESForCut(const Standard_Integer nF1,const Standard_Integer nF2) ;
  
//! Fills the WES by split parts (ON 2D) of the edges <br>
//! Internal Purpose <br>
  Standard_EXPORT     void PrepareOnParts(const Standard_Integer nF1,const Standard_Integer nF2,const BOP_Operation Op) ;
  
//! Make orientation of the faces consistent <br>
//! Internal Purpose <br>
  Standard_EXPORT     void PrepareFaces(const Standard_Integer nF1,const Standard_Integer nF2,TopoDS_Face& aF1,TopoDS_Face& aF2) const;
  
//! Assigns the 2D-State for split parts of <br>
//! the edges that do not have 3D-Curves of given faces <br>
//! Internal Purpose <br>
  Standard_EXPORT     void AssignDEStates(const Standard_Integer nF1,const Standard_Integer nF2) ;
  
//! Assigns the 2D-State for split parts of <br>
//! the edge  nE1 that do not have 3D-Curves from face nF1 <br>
  Standard_EXPORT     void AssignDEStates(const Standard_Integer nF1,const Standard_Integer nE1,const Standard_Integer nF2) ;


BOPTools_PDSFiller myDSFiller;
BOP_Operation myOperation;
Standard_Integer myNF1;
Standard_Integer myNF2;
BOP_PWireEdgeSet myWES;
BOPTools_IndexedDataMapOfIntegerState myStatesMap;
Standard_Integer mySenseFlag;
TopTools_ListOfShape myRejectedOnParts;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
