// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BOPTools_Checker_HeaderFile
#define _BOPTools_Checker_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _BOPTools_ListOfCheckResults_HeaderFile
#include <BOPTools_ListOfCheckResults.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BOPTools_PaveFiller_HeaderFile
#include <BOPTools_PaveFiller.hxx>
#endif
#ifndef _TopAbs_ShapeEnum_HeaderFile
#include <TopAbs_ShapeEnum.hxx>
#endif
class TopoDS_Shape;
class BOPTools_InterferencePool;
class BOPTools_ListOfCheckResults;



//!  class that provides the algorithm <br>
//!  to  check a shape on self-interference. <br>
class BOPTools_Checker  : public BOPTools_PaveFiller {
public:

  DEFINE_STANDARD_ALLOC

  
//! Empty Contructor <br>
  Standard_EXPORT   BOPTools_Checker();
  
//! Contructs the object using the shape <aS> to check <br>
  Standard_EXPORT   BOPTools_Checker(const TopoDS_Shape& aS);
  
//! Contructs the object using the <InterferencePool> <br>
  Standard_EXPORT   BOPTools_Checker(const BOPTools_InterferencePool& aIP);
  
//! Destructor <br>
  Standard_EXPORT   virtual  void Destroy() ;
Standard_EXPORT virtual ~BOPTools_Checker(){Destroy();}
  //! if <StopOnFirstFaulty == Standard_True> the process stops <br>
//!          and the exception throws; otherwise all faulties are searched <br>
  Standard_EXPORT     void SetPerformType(const Standard_Boolean StopOnFirstFaulty) ;
  
//! Launches  the  algorithm <br>
  Standard_EXPORT   virtual  void Perform() ;
  
//! Selector <br>
  Standard_EXPORT     void SetShape(const TopoDS_Shape& aS) ;
  
//! Selector <br>
  Standard_EXPORT    const TopoDS_Shape& Shape() const;
  //! returnes a result of check <br>
  Standard_EXPORT    const BOPTools_ListOfCheckResults& GetCheckResult() const;
  
//! Selector. <br>
//! Retrns TRUE if there is interferred sub-shapes . <br>
  Standard_EXPORT     Standard_Boolean HasFaulty() const;





protected:

  
//! See in base classe, please <br>
  Standard_EXPORT   virtual  void PerformVV() ;
  
//! See in base classe, please <br>
  Standard_EXPORT   virtual  void PerformVE() ;
  
//! See in base classe, please <br>
  Standard_EXPORT   virtual  void PerformVF() ;
  
//! See in base classe, please <br>
  Standard_EXPORT   virtual  void PerformEE() ;
  
//! See in base classe, please <br>
  Standard_EXPORT   virtual  void PerformEF() ;
  
//! See in base classe, please <br>
  Standard_EXPORT   virtual  void PerformFF() ;
  
//! Prepare end paves for each edge <br>
  Standard_EXPORT   virtual  void PrepareEdges() ;
  
//! Internal usage <br>
  Standard_EXPORT   virtual  void PreparePaveBlocks(const TopAbs_ShapeEnum aType1,const TopAbs_ShapeEnum aType2) ;
  
//! Prepare end paves for the edge <anE> <br>
  Standard_EXPORT   virtual  void PreparePaveBlocks(const Standard_Integer anE) ;




private:



TopoDS_Shape myShape;
BOPTools_ListOfCheckResults myCheckResults;
Standard_Boolean myStopOnFirst;
Standard_Integer myEntryType;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
