// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _AIS2D_InteractiveContext_HeaderFile
#define _AIS2D_InteractiveContext_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_AIS2D_InteractiveContext_HeaderFile
#include <Handle_AIS2D_InteractiveContext.hxx>
#endif

#ifndef _Handle_V2d_Viewer_HeaderFile
#include <Handle_V2d_Viewer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _AIS2D_DataMapOfIOStatus_HeaderFile
#include <AIS2D_DataMapOfIOStatus.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_AIS2D_InteractiveObject_HeaderFile
#include <Handle_AIS2D_InteractiveObject.hxx>
#endif
#ifndef _Handle_AIS2D_HSequenceOfIO_HeaderFile
#include <Handle_AIS2D_HSequenceOfIO.hxx>
#endif
#ifndef _AIS2D_TypeOfDetection_HeaderFile
#include <AIS2D_TypeOfDetection.hxx>
#endif
#ifndef _Graphic2d_PickMode_HeaderFile
#include <Graphic2d_PickMode.hxx>
#endif
#ifndef _Quantity_NameOfColor_HeaderFile
#include <Quantity_NameOfColor.hxx>
#endif
#ifndef _AIS2D_DataMapOfLC_HeaderFile
#include <AIS2D_DataMapOfLC.hxx>
#endif
#ifndef _Handle_V2d_View_HeaderFile
#include <Handle_V2d_View.hxx>
#endif
#ifndef _Handle_Aspect_GenericColorMap_HeaderFile
#include <Handle_Aspect_GenericColorMap.hxx>
#endif
#ifndef _Handle_Aspect_TypeMap_HeaderFile
#include <Handle_Aspect_TypeMap.hxx>
#endif
#ifndef _Handle_Aspect_WidthMap_HeaderFile
#include <Handle_Aspect_WidthMap.hxx>
#endif
#ifndef _Handle_Aspect_MarkMap_HeaderFile
#include <Handle_Aspect_MarkMap.hxx>
#endif
#ifndef _Handle_Aspect_FontMap_HeaderFile
#include <Handle_Aspect_FontMap.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _AIS2D_StatusOfDetection_HeaderFile
#include <AIS2D_StatusOfDetection.hxx>
#endif
#ifndef _Handle_Graphic2d_DisplayList_HeaderFile
#include <Handle_Graphic2d_DisplayList.hxx>
#endif
#ifndef _AIS2D_StatusOfPick_HeaderFile
#include <AIS2D_StatusOfPick.hxx>
#endif
#ifndef _Handle_MMgt_TShared_HeaderFile
#include <Handle_MMgt_TShared.hxx>
#endif
#ifndef _AIS2D_DisplayStatus_HeaderFile
#include <AIS2D_DisplayStatus.hxx>
#endif
#ifndef _AIS2D_PToListOfInt_HeaderFile
#include <AIS2D_PToListOfInt.hxx>
#endif
#ifndef _Aspect_TypeOfLine_HeaderFile
#include <Aspect_TypeOfLine.hxx>
#endif
#ifndef _Aspect_WidthOfLine_HeaderFile
#include <Aspect_WidthOfLine.hxx>
#endif
#ifndef _Aspect_TypeOfMarker_HeaderFile
#include <Aspect_TypeOfMarker.hxx>
#endif
#ifndef _Handle_Graphic2d_TransientManager_HeaderFile
#include <Handle_Graphic2d_TransientManager.hxx>
#endif
#ifndef _Handle_Graphic2d_Primitive_HeaderFile
#include <Handle_Graphic2d_Primitive.hxx>
#endif
class V2d_Viewer;
class AIS2D_InteractiveObject;
class AIS2D_HSequenceOfIO;
class V2d_View;
class Aspect_GenericColorMap;
class Aspect_TypeMap;
class Aspect_WidthMap;
class Aspect_MarkMap;
class Aspect_FontMap;
class AIS2D_LocalContext;
class Graphic2d_DisplayList;
class MMgt_TShared;
class TCollection_ExtendedString;
class AIS2D_ListOfIO;
class Quantity_Color;
class Aspect_FontStyle;
class Graphic2d_TransientManager;
class Graphic2d_Primitive;


//! The InteractiveContext class allows you to manage <br>
//!          graphic behavior and selection of Interactive Objects <br>
//!          in one or more viewers. <br>
class AIS2D_InteractiveContext : public MMgt_TShared {

public:

  //! Initiates <MainViewer> <br>
  Standard_EXPORT   AIS2D_InteractiveContext(const Handle(V2d_Viewer)& MainViewer);
  //! Initiates the principal viewer and Collector(trash) viewer together <br>
  Standard_EXPORT   AIS2D_InteractiveContext(const Handle(V2d_Viewer)& MainViewer,const Handle(V2d_Viewer)& aCollector);
  //! Display when no local context is opened. <br>
//!          if <anIObj> has no proper display mode, the defaut <br>
//!          display mode of the session is used <br>
//!          Same for the selection Mode (by default =0) <br>
  Standard_EXPORT     void Display(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Boolean UpdateVwr = Standard_True) ;
  //! Use only if a local context is opened. Displays the <br>
//!          <aDispMode> the presentation of interactive object, <br>
//!          activates the selection mode <aSelectMode> if <br>
//!          <UpdateVwr> =  Standard_False,  the  object is <br>
//!          displayed but no viewer will be updated; CONVENTION : <br>
//!          <aSelectMode> = -1 means no activation for <anIObj> <br>
//!          : it will be displayed but not  selectable.  (Option <br>
//!          only available for local context...) <br>
//!          <AllowDecomp>  = true  means  that <anIObj>  is <br>
//!          able to have subshapes detected by selection mechanisms. <br>
//!          2 conditions: <anIObj> must be able to give a shape <br>
//!          selection modes fit the AIS2D_Shape <br>
//!          selection modes ( 1->vertex, 2->edges, 3->wires...) <br>
  Standard_EXPORT     void Display(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Integer aDispMode,const Standard_Integer aSelectMode,const Standard_Boolean UpdateVwr = Standard_True,const Standard_Boolean AllowDecomp = Standard_True) ;
  //! Available when opened local contexts only; <br>
//!          option to load in the selector objects which will <br>
//!          be selectable but not displayed. Nevertheless, they <br>
//!          will be hilighted when detected by the selector. <br>
//!          ex : be able to select center of a line without <br>
//!               displaying all centers before selection process <br>
  Standard_EXPORT     void Load(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Integer SelMode = -1,const Standard_Boolean AllowDecomp = Standard_False) ;
  //! Erases presentations in current local context, <br>
//!          or failing that, in other local contexts which allow erasing. <br>
//!          If <PutInCollector> is false, the object is erased but <br>
//!          not put in the Collector. <br>
  Standard_EXPORT     void Erase(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Boolean UpdateVwr = Standard_True,const Standard_Boolean PutInCollector = Standard_True) ;
  //! Every erased object goes into the Collector viewer <br>
  Standard_EXPORT     void EraseAll(const Standard_Boolean PutInCollector = Standard_True,const Standard_Boolean updateVwr = Standard_True) ;
  //! Displays all erased objects, in other words, <br>
//!          all objects in the Collector viewer. <br>
  Standard_EXPORT     void DisplayAll(const Standard_Boolean OnlyFromCollector = Standard_True,const Standard_Boolean updateVwr = Standard_True) ;
  //! Erases selected objects if a local context is open. <br>
//!          Erases current objects if there is no active local context. <br>
//!          If a local context is open and if <updateVwr> equals <br>
//!          Standard_False, the presentation of the Interactive Object <br>
//!          activates the selection mode; the object is displayed but <br>
//!          no viewer will be updated. <br>
  Standard_EXPORT     void EraseSelected(const Standard_Boolean PutInCollector = Standard_True,const Standard_Boolean updateVwr = Standard_True) ;
  //! Displays or erases selected objects if a local <br>
//!  context is open. If no active local context is found, <br>
//!  only current objects can be displayed or erased. <br>
  Standard_EXPORT     void DisplaySelected(const Standard_Boolean updateVwr = Standard_True) ;
  //! Changes the status of a temporary object it will be -- <br>
//!          kept at the  neutral point, i.e.   put in the list  of <br>
//!           displayed  objects,  with  its  temporary  attributes <br>
//!          (displaymode,selection  mode) returns true  if done -- <br>
//!          inWhichLocal means that gives   the local context   in <br>
//!          which <anIObj> is displayed.  By default, -1 means the <br>
//!          last opened one <br>
  Standard_EXPORT     Standard_Boolean KeepTemporary(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Integer InWhichLocal = -1) ;
  //! Forces Recompute of the seen presentations of the object; <br>
//!          if <allModes>= True -> recomputes all the <br>
//!          presentations . <br>
  Standard_EXPORT     void Redisplay(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Boolean updateVwr = Standard_True,const Standard_Boolean allModes = Standard_False) ;
  //! Finds the current selected entity <anIObj> in Neutral Point. <br>
  Standard_EXPORT     Standard_Boolean IsCurrent(const Handle(AIS2D_InteractiveObject)& anIObj) const;
  //! Confirms selection. Returns true if <anIObj> is selected in the interactive context <br>
  Standard_EXPORT     Standard_Boolean IsSelected(const Handle(AIS2D_InteractiveObject)& anIObj) const;
  //! Updates the display in the viewer to take dynamic detection <br>
//!          into account. <br>
//!          If a local context is open and if <updateVwr> equals Standard_False, <br>
//!          the presentation of the Interactive Object activates the selection <br>
//!          mode; the object is displayed but no viewer will be updated. <br>
  Standard_EXPORT     void Highlight(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Boolean updateVwr = Standard_True) ;
  //! Changes the color of the object in view <anIObj>. <br>
//!          It paints this object the color passed as the argument <aCol> <br>
//!          If a local context is open and if <updateVwr> equals Standard_False, <br>
//!          the presentation of the Interactive Object activates the selection <br>
//!          mode; the object is displayed but no viewer will be updated. <br>
  Standard_EXPORT     void HighlightWithColor(const Handle(AIS2D_InteractiveObject)& anIObj,const Quantity_NameOfColor aCol,const Standard_Boolean updateVwr = Standard_True) ;
  //! Removes hilighting from the entity <anIObj>. Updates the viewer. <br>
//!          If a local context is open and if <updateVwr> equals Standard_False, <br>
//!          the presentation of the Interactive Object activates the selection <br>
//!          mode; the object is displayed but no viewer will be updated. <br>
  Standard_EXPORT     void Unhighlight(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Boolean updateVwr = Standard_True) ;
  //! Sets the precision of detection <br>
        void SetPrecision(const Standard_Integer aPrec) ;
  //! Returns the precision of detection <br>
        Standard_Integer DetectPrecision() const;
  //! Places object <anIO> to the pixel position (XPix, YPix) <br>
//!          in the view <aView> is using TransientManager. <br>
//!          It's possible to use without preliminary application of  Display method. <br>
  Standard_EXPORT     void Place(const Standard_Integer XPix,const Standard_Integer YPix,const Handle(V2d_View)& aView,const Handle(AIS2D_InteractiveObject)& anIO,const Standard_Boolean isTemporary = Standard_False) ;
  //! Places selected objects  to the pixel position (XPix, YPix) <br>
//!          in the view <aView>. If <isTemporary> is True,  is used TransientManager. <br>
  Standard_EXPORT     void Drag(const Standard_Integer XPix,const Standard_Integer YPix,const Handle(V2d_View)& aView,const Standard_Boolean isTemporary = Standard_True) ;
  //! Relays mouse position in pixels XPix and YPix to the <br>
//!          interactive context selectors. This is done by the view <aView> <br>
//!          passing this position to the main viewer and updating it. <br>
//!          Functions in both Neutral Point and local contexts. <br>
  Standard_EXPORT     AIS2D_StatusOfDetection MoveTo(const Standard_Integer XPix,const Standard_Integer YPix,const Handle(V2d_View)& aView) ;
  //! Relays mouse position in circle <XPix, YPix> and <Radius> to the <br>
//!          interactive context selectors. This is done by the view <aView> <br>
//!          passing this position to the main viewer and updating it. <br>
//!          Functions in both Neutral Point and local contexts. <br>
  Standard_EXPORT     AIS2D_StatusOfDetection MoveCircleTo(const Standard_Integer XPix,const Standard_Integer YPix,const Standard_Integer Radius,const Handle(V2d_View)& aView) ;
  //! Relays mouse position in rectangle Xmin, Ymin, Xmax, Ymax to the <br>
//!          interactive context selectors. This is done by the view <aView> <br>
//!          passing this position to the main viewer and updating it. <br>
//!          Functions in both Neutral Point and local contexts. <br>
  Standard_EXPORT     AIS2D_StatusOfDetection MoveTo(const Standard_Integer Xmin,const Standard_Integer Ymin,const Standard_Integer Xmax,const Standard_Integer Ymax,const Handle(V2d_View)& aView) ;
  //! Stores  and hilights the previous detected; Unhilights <br>
//!          the previous picked. <br>
  Standard_EXPORT     AIS2D_StatusOfPick Select(const Standard_Boolean UpdateVwr = Standard_True) ;
  //! adds the last detected to the list of previous picked. <br>
//!          if the last detected was already declared as picked, <br>
//!          removes it from the Picked List. <br>
  Standard_EXPORT     AIS2D_StatusOfPick ShiftSelect(const Standard_Boolean UpdateVwr = Standard_True) ;
  //! rectangle  of selection  ; adds new detected entities into the <br>
//!          picked list, removes the detected entities that were already stored... <br>
  Standard_EXPORT     AIS2D_StatusOfPick ShiftSelect(const Standard_Integer XPMin,const Standard_Integer YPMin,const Standard_Integer XPMax,const Standard_Integer YPMax,const Handle(V2d_View)& aView,const Standard_Boolean UpdateVwr = Standard_True) ;
  //! Allows to set the color used to show highlighted entities, <br>
//!          that is, entities picked out by the mouse. <br>
  Standard_EXPORT     void SetHighlightColor(const Quantity_NameOfColor aCol) ;
  //! Sets the color used to show selected entities <br>
  Standard_EXPORT     void SetSelectionColor(const Quantity_NameOfColor aCol) ;
  //! Allows you to set the color used to show that an object <br>
//!          is not currently selected <br>
  Standard_EXPORT     void SetSubIntensityColor(const Quantity_NameOfColor aCol) ;
  //! Returns the display mode setting <br>
        Standard_Integer DisplayMode() const;
  //! Returns the name of the color used to show highlighted entities, <br>
//!          that is, entities picked out by the mouse <br>
        Quantity_NameOfColor HighlightColor() const;
  //! Returns the name of the color used to show selected entities. <br>
        Quantity_NameOfColor SelectionColor() const;
  //! Returns the name of the color used to show <br>
//!          that an object is not currently selected. <br>
        Quantity_NameOfColor SubIntensityColor() const;
  //! Highlights, and removes highlights from, the displayed object <br>
//!          <anIObj> which is displayed at Neutral Point with subintensity <br>
//!          color; available only for active local context. <br>
//!          There is no effect if there is no local context. <br>
  Standard_EXPORT     void SubIntensityOn(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Boolean UpdateVwr = Standard_True) ;
  //! Removes the subintensity option for the entity <anIObj>. <br>
  Standard_EXPORT     void SubIntensityOff(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Boolean UpdateVwr = Standard_True) ;
  
        Standard_Boolean IsCollectorClosed() const;
  //! Allows to close Collector <br>
        void CloseCollector() ;
  //! Allows to open Collector <br>
  Standard_EXPORT     void OpenCollector() ;
  //! Opens a local context of display and selection <br>
//!          returns the index of new opened local context. <br>
//!          Must be stored and used to close the local context. <br>
  Standard_EXPORT     Standard_Integer OpenLocalContext(const Standard_Boolean UseDispObj = Standard_True,const Standard_Boolean AllowDecomposit = Standard_True,const Standard_Boolean AcceptEraseOfObj = Standard_False) ;
  //! close the current opened local context. <br>
//!          Use <ind> to be sure to close the local context you Opened ! <br>
//!          if <ind> == -1 the current local context is closed <br>
//!          WITHOUT VERIFICATION. <br>
//!          if <ind> is greater than the current opened local context, <br>
//!          nothing is done. <br>
  Standard_EXPORT     void CloseLocalContext(const Standard_Integer ind = -1,const Standard_Boolean updateVwr = Standard_True) ;
  //! returns -1 if no opened local context. <br>
  Standard_EXPORT     Standard_Integer IndexOfCurrentLocal() const;
  //! Allows to close all local contexts at one go and return to <br>
//!          Neutral Point. <br>
  Standard_EXPORT     void CloseAllContext(const Standard_Boolean updateVwr = Standard_True) ;
  //! Updates the view of the current object in open context. <br>
//!          Objects selected when there is no open local context <br>
//!          are called current objects; those selected in open local context, <br>
//!          selected objects. <br>
  Standard_EXPORT     void SetCurrentObject(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Boolean UpdateVwr = Standard_True) ;
  //! Allows to add a current object to the list of current objects <br>
//!          or remove it from that list. <br>
//!          Objects selected when there is no open local context are called <br>
//!          current objects; those selected in open local context, <br>
//!          selected objects. <br>
  Standard_EXPORT     void AddOrRemoveCurObject(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Boolean UpdateVwr = Standard_True) ;
  //! updates the list of current objects <br>
//!          i.e. hilights new current objects, <br>
//!          unhighlights old current objects <br>
//! <br>
  Standard_EXPORT     void UpdateCurrent() ;
  //! Returns the first current object in the list of current objects. <br>
  Standard_EXPORT     void SetOkCurrent() ;
  //! Highlights current objects. <br>
  Standard_EXPORT     void HighlightCurrent(const Standard_Boolean UpdateVwr = Standard_True) ;
  //! Unhighlights current objects. <br>
  Standard_EXPORT     void UnhighlightCurrent(const Standard_Boolean UpdateVwr = Standard_True) ;
  //! Empties previous current objects in order to get the current <br>
//!          objects detected by the selector using UpdateCurrent. <br>
  Standard_EXPORT     void ClearCurrent(const Standard_Boolean UpdateVwr = Standard_True) ;
  //! Puts the selected <anIObj> in the current objects list. <br>
  Standard_EXPORT     void SetSelected(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Boolean UpdateVwr = Standard_True) ;
  //! Puts the selected list in the current objects list. <br>
  Standard_EXPORT     void SetSelectedCurrent() ;
  //! Updates the list of selected objects, i.e. hilights <br>
//!          new selected objects, removes hilighting from former <br>
//!          selected objects. <br>
  Standard_EXPORT     void UpdateSelected(const Standard_Boolean UpdateVwr = Standard_True) ;
  //! Allows you to add a selected object <anIObj> to the list of selected <br>
//!          objects or remove it from that list. <br>
  Standard_EXPORT     void AddOrRemoveSelected(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Boolean UpdateVwr = Standard_True) ;
  //! Highlights selected objects. <br>
  Standard_EXPORT     void HighlightSelected(const Standard_Boolean UpdateVwr = Standard_True) ;
  //! UnHighlights selected objects. <br>
  Standard_EXPORT     void UnhighlightSelected(const Standard_Boolean UpdateVwr = Standard_True) ;
  //! Empties previous selected objects in order to get <br>
//!          the selected objects detected by the selector using UpdateSelected. <br>
  Standard_EXPORT     void ClearSelected(const Standard_Boolean UpdateVwr = Standard_True) ;
  //!  Returns  number of objects selected  in <br>
//!          local context ( if opened ) or in neutral context <br>
  Standard_EXPORT     Standard_Integer NbSelected() const;
  //!  Iteration <br>
  Standard_EXPORT     void InitSelected() ;
  //!  Iteration <br>
  Standard_EXPORT     Standard_Boolean MoreSelected() const;
  //!  Iteration <br>
  Standard_EXPORT     void NextSelected() ;
  //!  Returns  current  selected  object  (  see  InitSelected()  ..  ) <br>
//!           The  object type depends  on  highlight  mode <br>
//!           (  OBJECT,  PRIMITIVE  etc  ) <br>
  Standard_EXPORT     Handle_MMgt_TShared SelectedObject() const;
  //! Returns the display status of the entity <anIObj>. <br>
  Standard_EXPORT     AIS2D_DisplayStatus DisplayStatus(const Handle(AIS2D_InteractiveObject)& anIObj) const;
  //! Returns the list of active display modes for the entity <anIObj> <br>
  Standard_EXPORT     AIS2D_PToListOfInt DisplayedModes(const Handle(AIS2D_InteractiveObject)& anIObj) const;
  //! Returns true if <anIObj> is displayed in the interactive context <br>
  Standard_EXPORT     Standard_Boolean IsDisplayed(const Handle(AIS2D_InteractiveObject)& anIObj) const;
  //! Returns true if <anIObj> is displayed in the interactive context with <aMode> display mode <br>
  Standard_EXPORT     Standard_Boolean IsDisplayed(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Integer aMode) const;
  //! Returns true if the Interactive Object <anIObj> <br>
//!          is highlighted in the interactive context. <br>
  Standard_EXPORT     Standard_Boolean IsHighlighted(const Handle(AIS2D_InteractiveObject)& anIObj) const;
  //! if <anIObj> is highlighted with a specific color <br>
//!          <WithColor> will be returned TRUE <br>
//!          <theHiCol> gives the name of the hilightcolor <br>
  Standard_EXPORT     Standard_Boolean IsHighlighted(const Handle(AIS2D_InteractiveObject)& anIObj,Standard_Boolean& WithColor,Quantity_NameOfColor& theHiCol) const;
  //! Returns true if the entity <anIObj> is in the Collector viewer. <br>
  Standard_EXPORT     Standard_Boolean IsInCollector(const Handle(AIS2D_InteractiveObject)& anIObj) const;
  //! Modified the status of the entity <anIObj> <br>
  Standard_EXPORT     void Status(const Handle(AIS2D_InteractiveObject)& anIObj,TCollection_ExtendedString& aStatus) const;
  //! Updates the current viewer, the viewer in Neutral Point. <br>
  Standard_EXPORT     void UpdateCurrentViewer() ;
  //! Updates the Collector viewer <br>
  Standard_EXPORT     void UpdateCollector() ;
  //! Returns the current viewer. <br>
        Handle_V2d_Viewer CurrentViewer() const;
  //! Returns true if there is an open context. <br>
        Standard_Boolean HasOpenedContext() const;
  //! gives the list of displayed objects in the main viewer. <br>
  Standard_EXPORT     void DisplayedObjects(AIS2D_ListOfIO& aListOfIO,const Standard_Boolean OnlyFromNeutral = Standard_False) const;
  //! Allows to provide settings for pick mode. <br>
        void SetPickMode(const Graphic2d_PickMode aMode) ;
  //! Returns the pick mode <br>
        Graphic2d_PickMode GetPickMode() const;
  
  Standard_EXPORT     Standard_Integer HighestIndex() const;
  //! Initialize <aColor> in the color map <br>
  Standard_EXPORT     Standard_Integer InitializeColor(const Quantity_Color& aColor) ;
  //! Initialize <aType> in the type map <br>
  Standard_EXPORT     Standard_Integer InitializeStyle(const Aspect_TypeOfLine aType) ;
  //! Initialize <aWidth> in the width map <br>
  Standard_EXPORT     Standard_Integer InitializeWidth(const Aspect_WidthOfLine aWidth) ;
  //! Initialize <aMark> in the mark map <br>
  Standard_EXPORT     Standard_Integer InitializeMarker(const Aspect_TypeOfMarker aMark) ;
  //! Initialize <aFont> in the font map <br>
  Standard_EXPORT     Standard_Integer InitializeFont(const Aspect_FontStyle& aFont) ;
  //! to be used only with no  opened <br>
//!        local context..  displays and activates objects in their <br>
//!        original state before local contexts were opened... <br>
  Standard_EXPORT     void ResetOriginalState(const Standard_Boolean updateVwr = Standard_True) ;
  //!  switches on immediate mode <br>
  Standard_EXPORT     void BeginImmediateDraw(const Handle(V2d_View)& aView) ;
  //! draws object <anIObj> into immediate mode <br>
  Standard_EXPORT     void ImmediateDraw(const Handle(AIS2D_InteractiveObject)& anIObj,const Handle(V2d_View)& aView) ;
  //! switches of immediate mode <br>
  Standard_EXPORT     void EndImmediateDraw(const Handle(V2d_View)& aView) ;
  //! returns true if immediate mode is on <br>
  Standard_EXPORT     Standard_Boolean IsImmediateModeOn(const Handle(V2d_View)& aView) const;
  
  Standard_EXPORT     void SetDetectionMode(const AIS2D_TypeOfDetection mode) ;


friend class AIS2D_LocalContext;


  DEFINE_STANDARD_RTTI(AIS2D_InteractiveContext)

protected:


Handle_Aspect_GenericColorMap myColorMap;
Handle_Aspect_TypeMap myTypeMap;
Handle_Aspect_WidthMap myWidthMap;
Handle_Aspect_MarkMap myMarkMap;
Handle_Aspect_FontMap myFontMap;


private: 

  
  Standard_EXPORT     AIS2D_StatusOfDetection Detect(const Handle(Graphic2d_DisplayList)& dList,const Handle(V2d_View)& aView) ;
  //! Returns display, highlight and selection modes of the <anIObj> <br>
  Standard_EXPORT     void GetDefModes(const Handle(AIS2D_InteractiveObject)& anIObj,Standard_Integer& Dmode,AIS2D_TypeOfDetection& HiMod,Standard_Integer& SelMode) const;
  
  Standard_EXPORT     void EraseGlobal(const Handle(AIS2D_InteractiveObject)& anIObj,const Standard_Boolean UpdateVwr = Standard_True,const Standard_Boolean PutInCollector = Standard_True) ;
  
  Standard_EXPORT     void DrawObject(const Handle(AIS2D_InteractiveObject)& anObj,const Standard_Integer aDispMode) ;
  
  Standard_EXPORT     Standard_Boolean AvailableToDetect(const Handle(AIS2D_InteractiveObject)& anObj) const;
  
  Standard_EXPORT     void DoDetectObject(const Handle(AIS2D_InteractiveObject)& anObj,const Handle(Graphic2d_TransientManager)& aDrawer) ;
  
  Standard_EXPORT     Standard_Boolean IsIOPicked(const Handle(AIS2D_InteractiveObject)& anObj) const;
  
  Standard_EXPORT     Standard_Boolean IsPrimPicked(const Handle(AIS2D_InteractiveObject)& anObj,const Handle(Graphic2d_Primitive)& aPrim) const;
  
  Standard_EXPORT     Standard_Boolean IsElemPicked(const Handle(AIS2D_InteractiveObject)& anObj,const Handle(Graphic2d_Primitive)& aPrim,const Standard_Integer ind) const;
  
  Standard_EXPORT     Standard_Boolean IsElemSelected(const Handle(AIS2D_InteractiveObject)& anObj,const Handle(Graphic2d_Primitive)& aPrim,const Standard_Integer ind) const;
  
  Standard_EXPORT     Standard_Boolean IsIOSelected(const Handle(AIS2D_InteractiveObject)& anObj) const;
  
  Standard_EXPORT     Standard_Boolean IsPrimSelected(const Handle(AIS2D_InteractiveObject)& anObj,const Handle(Graphic2d_Primitive)& aPrim) const;

Handle_V2d_Viewer myMainVwr;
Handle_V2d_Viewer myCollectorVwr;
Standard_Boolean myIsCollClosed;
AIS2D_DataMapOfIOStatus myObjects;
Standard_Integer myDetectPrecision;
Standard_Boolean myResetDetect;
Handle_AIS2D_InteractiveObject myLastPicked;
Handle_AIS2D_InteractiveObject myLastinMain;
Handle_AIS2D_InteractiveObject myLastinColl;
Handle_AIS2D_HSequenceOfIO mySeqOfDetIO;
Handle_AIS2D_HSequenceOfIO mySeqOfSelIO;
AIS2D_TypeOfDetection myCurDetectMode;
Standard_Boolean myWasLastMain;
Graphic2d_PickMode myPickMode;
Quantity_NameOfColor myHighlightColor;
Quantity_NameOfColor mySelectionColor;
Quantity_NameOfColor mySubIntensity;
Standard_Integer myDisplayMode;
AIS2D_DataMapOfLC myLocalContexts;
Standard_Integer myCurLocalIndex;
Handle_V2d_View myLastMoveView;
Standard_Integer myCurSelected;
Standard_Integer myMaxSelected;


};


#include <AIS2D_InteractiveContext.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
