(* $Id: netaddress.mli,v 1.2 2001/11/19 02:09:45 pdoane Exp $
 * ----------------------------------------------------------------------
 *
 *)

(* Addresses indicate the senders and recipients of messages and
 * correspond to either an individual mailbox or a group of 
 * mailboxes.
 *)

type local_part = string
type domain = string

type addr_spec = local_part * domain option

class mailbox :
  ?name:string -> string list -> addr_spec -> 
object
  method name  : unit -> string
  method route : string list
  method spec  : addr_spec
end

class group :
  string -> mailbox list ->
object
  method name : string
  method mailboxes : mailbox list
end

type t =
  [ `Mailbox of mailbox
  | `Group of group
  ]

exception Parse_error of int * string

val parse : string -> t list
  (* Parse a string and return an address *)

(* ======================================================================
 * History:
 * 
 * $Log: netaddress.mli,v $
 * Revision 1.2  2001/11/19 02:09:45  pdoane
 * 	Exported exception Parse_error
 *
 * Revision 1.1  2001/10/09 03:54:57  pdoane
 * Added files to project.
 *
 * 
 *)
