(* $Id: netcgi_fcgi.mli,v 1.1 2003/10/07 17:39:32 stolpmann Exp $
 * ----------------------------------------------------------------------
 *
 *)

(* This code is copyright 2003 Eric Stokes, and may be used under
either, the GNU GPL, or the same license as ocamlnet *)

open Netcgi_env
open Netcgi_types
open Netcgi

(* this function "serves". It accepts fastcgi
   connections, builds Netcgi.cgi_activation objects from them
   (those are quite useful you know) and calls a function which
   you supply, passing the activation object as an argument. Fastcgi
   is made with real Beer, and will make your web code l33t.
   It gets all the stuff that it needs to add to the cgi_activation object
   from the fcgiRequest structure (req). That structure is created when 
   the request is read from the web server by fcgi_accept. The stuff that
   is in there (environment vars, stdin, etc) is pretty straitforward, if
   you're curious, link to the low level library, call fcgi_accept yourself,
   and print it all out. Yes, you can make a web app from just the low level
   library (see fcgi_protocal.mli), but netcgi is so much more...fun. 
*)
val serv: (Netcgi_types.cgi_activation -> unit) -> operating_type -> unit

(* ======================================================================
 * History:
 * 
 * $Log: netcgi_fcgi.mli,v $
 * Revision 1.1  2003/10/07 17:39:32  stolpmann
 * 	Imported Eric's patch for fastcgi
 *
 * 
 *)
