<?php
/*
 +-------------------------------------------------------------------------+
 |  Copyright (c) 1997-2007 Aliasource - Groupe LINAGORA                   |
 |                                                                         |
 | This program is free software; you can redistribute it and/or           |
 | modify it under the terms of the GNU General Public License             |
 | as published by the Free Software Foundation; either version 2          |
 | of the License, or (at your option) any later version.                  |
 |                                                                         |
 | This program is distributed in the hope that it will be useful,         |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of          |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           |
 | GNU General Public License for more details.                            |
 +-------------------------------------------------------------------------+
 | http://obm.aliasource.fr/                                               |
 +-------------------------------------------------------------------------+
*/
?>
<?php

include_once('obminclude/of/vcalendar/Element.php');

/**
 * Vcalendar_Element_Vevent
 *
 * @package
 * @version $Id:$
 * @copyright Copyright (c) 1997-2007 Aliasource - Groupe LINAGORA
 * @author Mehdi Rande <mehdi.rande@aliasource.fr>
 * @license GPL 2.0
 */
class Vcalendar_Element_Vevent extends Vcalendar_Element {


  /**
   * Vcalendar_Element_Vevent
   *
   * @param mixed $document
   * @access public
   * @return void
   */
  function Vcalendar_Element_Vevent(&$document) {
    $this->document = &$document;
    $this->name = vevent;
  }


  function setDtstart($value) {
    $this->dtstart = $value;
    if(isset($this->dtend) && !isset($this->duration)) {
      $this->set('duration', strtotime($this->dtend) - strtotime($this->dtstart));
    }
  }

  function setDtend($value) {
    $this->dtend = $value;
    if(isset($this->dtstart) && !isset($this->duration)) {
      $this->set('duration', strtotime($this->dtend) - strtotime($this->dtstart));
    }
  }

  function setDuration($value) {
    $this->duration = $value;
    if(isset($this->duration) && isset($this->dtend)) {
      $this->set('dtend', gmdate('Y-m-d H:i:s',strtotime($this->dtstart) + $this->duration));
    }
  }
    
  function isAllDay() {
    if($this->get('x-obm-all-day') == 1) {
      return true;
    }
    if(date('His', strtotime($this->dtstart)) == '000000' && date('His', strtotime($this->dtstart + $this->duration)) == '000000') {
      return true;
    }
    if($this->duration == '0') {
      return true;
    }
    return false;
  }

}

?>
