<?php
/*
 +-------------------------------------------------------------------------+
 |  Copyright (c) 1997-2007 Aliasource - Groupe LINAGORA                   |
 |                                                                         |
 | This program is free software; you can redistribute it and/or           |
 | modify it under the terms of the GNU General Public License             |
 | as published by the Free Software Foundation; either version 2          |
 | of the License, or (at your option) any later version.                  |
 |                                                                         |
 | This program is distributed in the hope that it will be useful,         |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of          |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           |
 | GNU General Public License for more details.                            |
 +-------------------------------------------------------------------------+
 | http://obm.aliasource.fr/                                               |
 +-------------------------------------------------------------------------+
*/
?>
<?php

require_once "../../Graph.class.php";

$graph = new Graph(300, 200);

$driver = $graph->getDriver();

$driver->filledRectangle(
	new Color(230, 230, 230, 0),
	new Line(
		new Point(10, 10),
		new Point(200, 150)
	)
);

for($i = 7; $i < 400; $i += 15) {
	$driver->line(
		new Color(0, 0, 0),
		new Line(
			new Point($i, 0 + 50),
			new Point($i, 30 + 50)
		)
	);
}

for($i = 7; $i < 30; $i += 15) {
	$driver->line(
		new Color(0, 0, 0),
		new Line(
			new Point(0, $i + 50),
			new Point(400, $i + 50)
		)
	);
}

$driver->filledRectangle(
	new Color(0, 100, 200, 50),
	new Line(
		new Point(100, 100),
		new Point(280, 180)
	)
);

$debut = new Color(230, 250, 0);
$fin = new Color(255, 255, 255, 100);

$driver->filledEllipse(
	new RadialGradient(
		$debut,
		$fin
	),
	new Point(105, 135),
	90, 90
);

$text = new Text(
	"Artichow !",
	new Tuffy(15),
	new Color(0, 0, 80),
	45
);

$driver->string($text, new Point(210, 75));

$graph->draw();

?>
