<?php
/*
 +-------------------------------------------------------------------------+
 |  Copyright (c) 1997-2007 Aliasource - Groupe LINAGORA                   |
 |                                                                         |
 | This program is free software; you can redistribute it and/or           |
 | modify it under the terms of the GNU General Public License             |
 | as published by the Free Software Foundation; either version 2          |
 | of the License, or (at your option) any later version.                  |
 |                                                                         |
 | This program is distributed in the hope that it will be useful,         |
 | but WITHOUT ANY WARRANTY; without even the implied warranty of          |
 | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           |
 | GNU General Public License for more details.                            |
 +-------------------------------------------------------------------------+
 | http://obm.aliasource.fr/                                               |
 +-------------------------------------------------------------------------+
*/
?>
<?php

require_once "../ScatterPlot.class.php";

$graph = new Graph(400, 400);

$graph->shadow->setSize(5);

$y = array();
for($i = 0; $i < 60; $i++) {
	$y[] = cos($i / 30 * 2 * M_PI);
}

$plot = new ScatterPlot($y);
$plot->setSpace(6, 6);

// Set impulses
$plot->setImpulse(new DarkGreen);

$plot->grid->hideVertical();

// Hide axis labels and ticks
$plot->xAxis->label->hide();
$plot->xAxis->hideTicks();

$plot->mark->setType(MARK_SQUARE);
$plot->mark->setSize(4);

$graph->add($plot);
$graph->draw();

?>