/* *****************************************************
   THIS IS AN AUTOMATICALLY GENERATED FILE. DO NOT EDIT.
   *****************************************************

   Generated by:
     cctbx.source_generators.eltbx.generate_henke_cpp
 */

#include <cctbx/eltbx/henke.h>

namespace cctbx { namespace eltbx { namespace henke {

/*
  Henke Tables

  The original data can be found at:
    ftp://grace.lbl.gov/pub/sf/

  From ftp://grace.lbl.gov/pub/sf/read.me:

                Low-Energy X-ray Interaction Coefficients:
                Photoabsorption, Scattering, and Reflection
                        E = 30-30,000 eV, Z = 1-92

                B. L. Henke, E. M. Gullikson, and J. C. Davis
                        Center for X-Ray Optics, 2-400
                        Lawrence Berkeley Laboratory
                        Berkeley, California 94720

  Reference: B. L. Henke, E. M. Gullikson, and J. C. Davis,
  Atomic Data and Nuclear Data Tables Vol. 54 No. 2 (July 1993).
 */

namespace table_data {

using anomalous::e_fp_fdp;

extern e_fp_fdp h[];
extern e_fp_fdp he[];
extern e_fp_fdp li[];
extern e_fp_fdp be[];
extern e_fp_fdp b[];
extern e_fp_fdp c[];
extern e_fp_fdp n[];
extern e_fp_fdp o[];
extern e_fp_fdp f[];
extern e_fp_fdp ne[];
extern e_fp_fdp na[];
extern e_fp_fdp mg[];
extern e_fp_fdp al[];
extern e_fp_fdp si[];
extern e_fp_fdp p[];
extern e_fp_fdp s[];
extern e_fp_fdp cl[];
extern e_fp_fdp ar[];
extern e_fp_fdp k[];
extern e_fp_fdp ca[];
extern e_fp_fdp sc[];
extern e_fp_fdp ti[];
extern e_fp_fdp v[];
extern e_fp_fdp cr[];
extern e_fp_fdp mn[];
extern e_fp_fdp fe[];
extern e_fp_fdp co[];
extern e_fp_fdp ni[];
extern e_fp_fdp cu[];
extern e_fp_fdp zn[];
extern e_fp_fdp ga[];
extern e_fp_fdp ge[];
extern e_fp_fdp as[];
extern e_fp_fdp se[];
extern e_fp_fdp br[];
extern e_fp_fdp kr[];
extern e_fp_fdp rb[];
extern e_fp_fdp sr[];
extern e_fp_fdp y[];
extern e_fp_fdp zr[];
extern e_fp_fdp nb[];
extern e_fp_fdp mo[];
extern e_fp_fdp tc[];
extern e_fp_fdp ru[];
extern e_fp_fdp rh[];
extern e_fp_fdp pd[];
extern e_fp_fdp ag[];
extern e_fp_fdp cd[];
extern e_fp_fdp in[];
extern e_fp_fdp sn[];
extern e_fp_fdp sb[];
extern e_fp_fdp te[];
extern e_fp_fdp i[];
extern e_fp_fdp xe[];
extern e_fp_fdp cs[];
extern e_fp_fdp ba[];
extern e_fp_fdp la[];
extern e_fp_fdp ce[];
extern e_fp_fdp pr[];
extern e_fp_fdp nd[];
extern e_fp_fdp pm[];
extern e_fp_fdp sm[];
extern e_fp_fdp eu[];
extern e_fp_fdp gd[];
extern e_fp_fdp tb[];
extern e_fp_fdp dy[];
extern e_fp_fdp ho[];
extern e_fp_fdp er[];
extern e_fp_fdp tm[];
extern e_fp_fdp yb[];
extern e_fp_fdp lu[];
extern e_fp_fdp hf[];
extern e_fp_fdp ta[];
extern e_fp_fdp w[];
extern e_fp_fdp re[];
extern e_fp_fdp os[];
extern e_fp_fdp ir[];
extern e_fp_fdp pt[];
extern e_fp_fdp au[];
extern e_fp_fdp hg[];
extern e_fp_fdp tl[];
extern e_fp_fdp pb[];
extern e_fp_fdp bi[];
extern e_fp_fdp po[];
extern e_fp_fdp at[];
extern e_fp_fdp rn[];
extern e_fp_fdp fr[];
extern e_fp_fdp ra[];
extern e_fp_fdp ac[];
extern e_fp_fdp th[];
extern e_fp_fdp pa[];
extern e_fp_fdp u[];

static const anomalous::label_z_e_fp_fdp all[] = {
{"H", 1, h},
{"He", 2, he},
{"Li", 3, li},
{"Be", 4, be},
{"B", 5, b},
{"C", 6, c},
{"N", 7, n},
{"O", 8, o},
{"F", 9, f},
{"Ne", 10, ne},
{"Na", 11, na},
{"Mg", 12, mg},
{"Al", 13, al},
{"Si", 14, si},
{"P", 15, p},
{"S", 16, s},
{"Cl", 17, cl},
{"Ar", 18, ar},
{"K", 19, k},
{"Ca", 20, ca},
{"Sc", 21, sc},
{"Ti", 22, ti},
{"V", 23, v},
{"Cr", 24, cr},
{"Mn", 25, mn},
{"Fe", 26, fe},
{"Co", 27, co},
{"Ni", 28, ni},
{"Cu", 29, cu},
{"Zn", 30, zn},
{"Ga", 31, ga},
{"Ge", 32, ge},
{"As", 33, as},
{"Se", 34, se},
{"Br", 35, br},
{"Kr", 36, kr},
{"Rb", 37, rb},
{"Sr", 38, sr},
{"Y", 39, y},
{"Zr", 40, zr},
{"Nb", 41, nb},
{"Mo", 42, mo},
{"Tc", 43, tc},
{"Ru", 44, ru},
{"Rh", 45, rh},
{"Pd", 46, pd},
{"Ag", 47, ag},
{"Cd", 48, cd},
{"In", 49, in},
{"Sn", 50, sn},
{"Sb", 51, sb},
{"Te", 52, te},
{"I", 53, i},
{"Xe", 54, xe},
{"Cs", 55, cs},
{"Ba", 56, ba},
{"La", 57, la},
{"Ce", 58, ce},
{"Pr", 59, pr},
{"Nd", 60, nd},
{"Pm", 61, pm},
{"Sm", 62, sm},
{"Eu", 63, eu},
{"Gd", 64, gd},
{"Tb", 65, tb},
{"Dy", 66, dy},
{"Ho", 67, ho},
{"Er", 68, er},
{"Tm", 69, tm},
{"Yb", 70, yb},
{"Lu", 71, lu},
{"Hf", 72, hf},
{"Ta", 73, ta},
{"W", 74, w},
{"Re", 75, re},
{"Os", 76, os},
{"Ir", 77, ir},
{"Pt", 78, pt},
{"Au", 79, au},
{"Hg", 80, hg},
{"Tl", 81, tl},
{"Pb", 82, pb},
{"Bi", 83, bi},
{"Po", 84, po},
{"At", 85, at},
{"Rn", 86, rn},
{"Fr", 87, fr},
{"Ra", 88, ra},
{"Ac", 89, ac},
{"Th", 90, th},
{"Pa", 91, pa},
{"U", 92, u},
{0, 0, 0}
};

  } // namespace table_data

  table::table(std::string const& label, bool exact)
  {
    std::string work_label = basic::strip_label(label, exact);
    label_z_e_fp_fdp_ = anomalous::find_entry(
      table_data::all, work_label, exact);
  }

  fp_fdp
  table::at_ev(double energy) const
  {
    fp_fdp raw = anomalous::interpolate(label_z_e_fp_fdp_, energy);
    if (!raw.is_valid_fp()) return raw;
    // subtract the number of electrons
    return fp_fdp(raw.fp() - label_z_e_fp_fdp_->z, raw.fdp());
  }

  table_iterator::table_iterator()
  :
    current_("H", true)
  {}

  table
  table_iterator::next()
  {
    table result = current_;
    if (current_.is_valid()) current_.label_z_e_fp_fdp_++;
    return result;
  }

}}} // namespace cctbx::eltbx::henke
