#include "config_nws.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/time.h> 
#include <string.h>
#include <errno.h>
#include <string.h>

#include "batchtest.h"
#include "diagnostic.h"
#include "osutil.h"


void 
batchQueueUseSkill(	const char *options,
			int *length,
			SkillResult **results) {

  char *tmp, *opts, *dbfname, *dbfnamebackup, 
    *dbpath,*scriptfname, *orig, *strbuf, *tok;


  const char *dbs[2] = {"waittime_db",
			"waittime_log_db"};

  unsigned int resources[2] = {batchQueue, batchQueueLog};

  int minnodes, maxnodes, rc, fd, 
    ofd, tmpint, rangecount, queuecount, 
    i, j, k, noderanges[128], allqueues, 
    stored, nodes;

  FILE *FD, *OFD;

  char buf[128], *queues[10], jobid[32], qname[32];

  unsigned ts, wt;

  dbfname = dbfnamebackup = NULL;
  FD = OFD = NULL;
  fd = ofd = -1;

  tmp = GetOptionValue(options, "noderanges", "ALL");
  if (!strcmp(tmp, "ALL")) {
    noderanges[0] = 1;
    noderanges[1] = 32768;
    rangecount=2;
  } else {
    orig = strdup(tmp);
    strbuf = orig;

    rangecount=1;
    bzero(noderanges, 128 * sizeof(int));
    noderanges[0] = 1;
    while((tok = strsep(&strbuf, ",")) != NULL) {
      tmpint = atoi(tok);
      noderanges[rangecount] = tmpint;
      rangecount++;
    }
    noderanges[rangecount] = 32768;
    free(orig);
  }


  tmp = GetOptionValue(options, "queues", "ALL");  
  if (!strcmp(tmp, "ALL")) {
    queuecount=1;
    queues[0] = strdup("ALL");
    allqueues = 1;
  } else {
    allqueues = 0;
    queuecount=0;
    orig = strdup(tmp);
    strbuf = orig;
    while((tok = strsep(&strbuf, ",")) != NULL) {
      queues[queuecount] = strdup(tok);    
      queuecount++;
    }
    free(orig);
  }

  dbpath = GetOptionValue(options, "dbpath", "/tmp");



  scriptfname = malloc(strlen(dbpath) + strlen("/sitescript")+1);
  sprintf(scriptfname, "%s/sitescript", dbpath);

  rc = system(scriptfname);
  rc = rc>>8;

  if (rc != 0) {
    ERROR2("batchtest: script %s failed: %d\n", scriptfname, rc);
    goto finish;
  } else {
    for (k=0; k<2; k++) {
      dbfname = malloc(strlen(dbpath) + strlen(dbs[k])+1);
      dbfnamebackup = malloc(strlen(dbpath) + strlen(dbs[k])+4+1);
    
      sprintf(dbfname, "%s/%s", dbpath, dbs[k]);
      sprintf(dbfnamebackup, "%s/%s.bak", dbpath, dbs[k]);

      rc = rename(dbfname, dbfnamebackup);
      if (rc < 0) {
	goto finish;
      }

      fd = open(dbfnamebackup, O_RDONLY);
      if (fd < 0) {
	goto finish;
      }
      FD = fdopen(fd, "r");

      ofd = open(dbfname, O_WRONLY | O_CREAT | O_TRUNC, 0644);
      if (ofd < 0) {
	goto finish;
      }
      OFD = fdopen(ofd, "w");


      while(fgets(buf, 128, FD) != NULL) {
	bzero(jobid, 32);
	bzero(qname, 32);
	sscanf(buf, "%32s %u %u %d %32s", jobid, &ts, &wt, &nodes, qname);
	/*	printf("%s %u %u %d %s\n", jobid, ts, wt, nodes, qname);*/
	stored=0;
	for (i=0; i<queuecount; i++) {
	  if (!strcmp(qname, queues[i]) || !strcmp(queues[0], "ALL")) {
	    for (j=0; j<(rangecount); j++) {
	      minnodes = noderanges[j];
	      maxnodes = noderanges[j+1];
	      if (nodes >= minnodes && nodes < maxnodes) {
		opts = malloc(strlen(qname) + 128);  
		snprintf(opts, strlen(qname) + 128, "maxnodes:%d\tminnodes:%d\tqueuename:%s", maxnodes-1, minnodes, qname);
		
		AppendResult(resources[k], opts, 1, (double)wt, ts, length, results);
		stored=1;
		free(opts);
	      }
	    }
	  }
	}
	if (!stored) {
	  fprintf(OFD, "%s %u %u %d %s\n", jobid, ts, wt, nodes, qname);
	}
      }

      fclose(FD);
      fclose(OFD);
      close(fd);
      close(ofd);

      unlink(dbfnamebackup);
      free(dbfname);
      free(dbfnamebackup);

      dbfname = dbfnamebackup = NULL;
      FD = OFD = NULL;
      fd = ofd = -1;

    }
  }


  /*
    AppendResult(batchQueue, opts, 1, 10.0, length, results);
    AppendResult(batchQueue5to16, "", 1, 20.0, length, results);
    AppendResult(batchQueue17to64, "", 1, 30.0, length, results);
    AppendResult(batchQueue65plus, "", 1, 40.0, length, results);  
    AppendResult(upTime, "", 0, 0.0, length, results);
  */
 finish:

  for (i=0; i<queuecount; i++) {
    free(queues[i]);
  }

  if (FD != NULL) {
    fclose(FD);
    close(fd);
  }
  if (OFD != NULL) {
    fclose(OFD);
    close(ofd);
  }
  
  if (dbfname != NULL) {
    free(dbfname);
  }
  if (dbfnamebackup != NULL) {
    unlink(dbfnamebackup);
    free(dbfnamebackup);
  }
  

  free(scriptfname);

  return;
}

int
batchQueueMonitorAvailable(const char *options) {
  int returncode=1;
  
  /*
  char *scriptfname, *dbpath;
  int rc, returncode;
  struct stat mystat;

  printf("OPTS: %s\n", options);
  returncode = 0;
  dbpath = GetOptionValue(options, "dbpath", "/tmp");
  
  scriptfname = malloc(strlen(dbpath) + strlen("/sitescript")+1);
  sprintf(scriptfname, "%s/sitescript", dbpath);

  rc = stat(scriptfname, &mystat);
  if (rc < 0 || !S_ISREG(mystat.st_mode)) {
    ERROR1("batchtest: scriptfile %s cannot be stat()ed\n", scriptfname);
  } else {
    returncode=1;
  }

  free(scriptfname);
  */
  return returncode;
}
