/* $Id: nws_nameserver.h,v 1.26 2004/08/19 23:44:37 graziano Exp $ */

#ifndef NWS_NAMESERVER_H
#define NWS_NAMESERVER_H

#ifdef __cplusplus
extern "C" {
#endif

/* used only by nws_nameserver.c. No public interface available here */

/* definitions of expired timestamp */
#define EXPIRED 1


/* how often to save the registrations to file: default is
 * DEFAULT_HOST_BEAT/2  */
#define DEFAULT_COMPRESSION_FREQUENCY (15 * 30)
#define DEFAULT_FILE "registrations"		/* name of the
						   registration's file
						   (backup only) */

/* defaults timeouts for nws_nameserver */
#define MIN_TIME_OUT 10
#define MAX_TIME_OUT 120
#define TIMEOUT_TIME_OUT 15
/* time to wait till try again after a failed connection */
#define NAP_TIME 60

/* attribute name we add when we use mirroring capabilities */
#define FROM_NS   "fromNameserver"
#define FROM_NS_LEN 14


/* 
 * keep a cache of the nameservers we are registering with: we want to
 * keep the socket open 
 */
typedef struct {
	int howMany;		/* the number of nameservers */
	char **reg;		/* the NS registration */
	struct host_cookie *cookie;
	unsigned long *last;	/* last time we tried to talk to them */
	registrations *queue;	/* messages that failed to send (register) */
	registrations *deQueue;	/* messages that failed to send (unregister) */
} nameServerCache;

/* forward declaration */
static int CheckNScache(Object registration, Socket sd);
static int AddToNSqueue(Object registration, long timeOut);
static int ForwardNSqueue(int);

#ifdef __cplusplus
}
#endif

#endif /* NWS_NAMESERVER_H */
