/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.util;

import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;

public class JMSTCPConnection
implements ExceptionListener {
    private Logger mLogger = LoggerUtils.getLogger(this);
    protected TopicConnection mConnection = null;

    public JMSTCPConnection() throws RuntimeException {
        CMCSProperties sysprops = CMCSProperties.getCMCSProperties();
        String host = sysprops.getProperty("msgserver");
        String port = sysprops.getProperty("msgport");
        String factoryname = sysprops.getProperty("jms-tcp-contextfactory");
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.provider.url", "tcp://" + host + ":" + port + "/");
        props.put("java.naming.factory.initial", factoryname);
        try {
            InitialContext context = new InitialContext(props);
            TopicConnectionFactory factory = (TopicConnectionFactory)context.lookup("JmsTopicConnectionFactory");
            if (factory == null) {
                throw new RuntimeException("Failed to locate connection factory");
            }
            this.mConnection = factory.createTopicConnection();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }

    public void startConnection() throws JMSException {
        if (this.mConnection != null) {
            this.mConnection.start();
        } else {
            this.mLogger.warning("Attempt to start a null connection");
        }
    }

    public void closeConnection() throws JMSException {
        if (this.mConnection != null) {
            this.mConnection.close();
        } else {
            this.mLogger.warning("Attempt to close a null connection");
        }
    }

    public void onException(JMSException ex) {
        this.mConnection = null;
    }

    public TopicConnection getConnection() {
        return this.mConnection;
    }
}

