/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.apache.turbine.util.Log;
import org.chefproject.core.Cacher;
import org.chefproject.core.Event;
import org.chefproject.core.Notification;
import org.chefproject.service.EventTrackingService;
import org.chefproject.service.MemoryService;
import org.chefproject.util.CacheRefresher;

public class NotificationCache
implements Cacher,
Observer {
    protected Map m_map = null;
    protected Map m_functionMap = null;
    protected CacheRefresher m_refresher = null;
    protected String m_resourcePattern = null;
    protected boolean m_disabled = false;
    protected boolean m_complete = false;
    protected boolean m_holdEventProcessing = false;
    protected List m_heldEvents = new Vector();

    public NotificationCache(CacheRefresher refresher, String pattern) {
        this.m_map = new HashMap();
        this.m_functionMap = new HashMap();
        MemoryService.registerCacher(this);
        this.m_refresher = refresher;
        this.m_resourcePattern = pattern;
        EventTrackingService.addPriorityObserver(this);
    }

    protected void finalize() {
        MemoryService.unregisterCacher(this);
        EventTrackingService.deleteObserver(this);
    }

    public synchronized void put(Notification payload) {
        if (this.disabled()) {
            return;
        }
        this.m_map.put(payload.getReference(), payload);
        Vector<Notification> notifications = (Vector<Notification>)this.m_functionMap.get(payload.getFunction());
        if (notifications == null) {
            notifications = new Vector<Notification>();
            this.m_functionMap.put(payload.getFunction(), notifications);
        }
        if (!notifications.contains(payload)) {
            notifications.add(payload);
        }
    }

    public synchronized boolean containsKey(Object key) {
        if (this.disabled()) {
            return false;
        }
        return this.m_map.containsKey(key);
    }

    public synchronized Notification get(Object key) {
        if (this.disabled()) {
            return null;
        }
        return (Notification)this.m_map.get(key);
    }

    public List getAll() {
        Vector rv = new Vector();
        if (this.disabled()) {
            return rv;
        }
        if (this.m_map.isEmpty()) {
            return rv;
        }
        Object[] keys = this.m_map.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            Object payload = this.m_map.get(keys[i]);
            if (payload != null) {
                rv.add(payload);
            }
            ++i;
        }
        return rv;
    }

    public List getAll(String function) {
        return (List)this.m_functionMap.get(function);
    }

    public List getKeys() {
        Vector rv = new Vector();
        rv.addAll(this.m_map.keySet());
        return rv;
    }

    public List getIds() {
        Vector<String> rv = new Vector<String>();
        Vector keys = new Vector();
        keys.addAll(this.m_map.keySet());
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            int i = key.indexOf(this.m_resourcePattern);
            if (i != -1) {
                key = key.substring(i + this.m_resourcePattern.length());
            }
            rv.add(key);
        }
        return rv;
    }

    public synchronized void clear() {
        this.m_map.clear();
        this.m_functionMap.clear();
        this.m_complete = false;
    }

    public synchronized void remove(Object key) {
        if (this.disabled()) {
            return;
        }
        Notification payload = (Notification)this.m_map.get(key);
        this.m_map.remove(key);
        if (payload == null) {
            return;
        }
        List notifications = (List)this.m_functionMap.get(payload.getFunction());
        if (notifications != null) {
            notifications.remove(payload);
            if (notifications.isEmpty()) {
                this.m_functionMap.remove(payload.getFunction());
            }
        }
    }

    public void disable() {
        this.m_disabled = true;
        EventTrackingService.deleteObserver(this);
        this.clear();
    }

    public void enable() {
        this.m_disabled = false;
        EventTrackingService.addPriorityObserver(this);
    }

    public boolean disabled() {
        return this.m_disabled;
    }

    public boolean isComplete() {
        if (this.disabled()) {
            return false;
        }
        return this.m_complete;
    }

    public void setComplete() {
        if (this.disabled()) {
            return;
        }
        this.m_complete = true;
    }

    public synchronized void holdEvents() {
        this.m_holdEventProcessing = true;
    }

    public synchronized void processEvents() {
        this.m_holdEventProcessing = false;
        int i = 0;
        while (i < this.m_heldEvents.size()) {
            Event event = (Event)this.m_heldEvents.get(i);
            this.continueUpdate(event);
            ++i;
        }
        this.m_heldEvents.clear();
    }

    public void resetCache() {
        this.clear();
    }

    public void update(Observable o, Object arg) {
        if (this.disabled()) {
            return;
        }
        if (!(arg instanceof Event)) {
            return;
        }
        Event event = (Event)arg;
        if (!event.getModify()) {
            return;
        }
        String key = event.getResource();
        if (!key.startsWith(this.m_resourcePattern)) {
            return;
        }
        if (this.m_holdEventProcessing) {
            this.m_heldEvents.add(event);
            return;
        }
        this.continueUpdate(event);
    }

    private void continueUpdate(Event event) {
        String key = event.getResource();
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".update() [" + this.m_resourcePattern + "] resource: " + key + " event: " + event.getEvent());
        }
        Notification oldValue = this.get(key);
        if (this.m_map.containsKey(key)) {
            this.remove(key);
        }
        if (this.m_complete) {
            if (this.m_refresher != null) {
                Notification value = (Notification)this.m_refresher.refresh(key, oldValue, event);
                if (value != null) {
                    this.put(value);
                }
            } else {
                this.m_complete = false;
            }
        }
    }
}

