/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.RunDataFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.chefproject.core.ContentResource;
import org.chefproject.core.Site;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.AssignmentService;
import org.chefproject.service.ContentHostingService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.service.component.ChefParameterParser;
import org.chefproject.service.generic.GenericAssignmentService;
import org.chefproject.service.generic.GenericContentHostingService;
import org.chefproject.service.generic.GenericSiteService;
import org.chefproject.util.Blob;
import org.chefproject.util.MyPortalsTool;
import org.chefproject.util.PrintFileGenerator;
import org.chefproject.util.Reference;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Validator;

public class AccessServlet
extends HttpServlet {
    protected static final String FORM_VALUE_DELIMETER = "^";
    public static String ME;
    protected boolean m_ready = false;
    protected static final String LOGIN_PATH = "/login";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.startInit();
    }

    public void startInit() {
        new AccessServletInit();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.dispatch(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.dispatch(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatch(HttpServletRequest req, HttpServletResponse res) {
        RunData data;
        AccessServletInfo info;
        block34: {
            block33: {
                block32: {
                    block31: {
                        String path = ChefParameterParser.getPathDecoded(req);
                        if (path == null) {
                            path = "";
                        }
                        if (!this.m_ready) {
                            this.respondNotReady(req, res);
                            return;
                        }
                        info = this.newInfo(req);
                        data = null;
                        try {
                            try {
                                data = RunDataFactory.getRunData(req, res, this.getServletConfig());
                                if (LOGIN_PATH.equals(path)) {
                                    this.respondLogin(req, res);
                                    Object var13_6 = null;
                                    this.log(req, info);
                                    break block31;
                                }
                                Reference ref = new Reference(path);
                                boolean willHandle = false;
                                boolean permitted = false;
                                if (GenericContentHostingService.SERVICE_NAME.equals(ref.getType())) {
                                    if (!ref.getId().endsWith("/")) {
                                        willHandle = true;
                                        permitted = ContentHostingService.allowGetResource(ref.getId());
                                    }
                                } else if (GenericAssignmentService.SERVICE_NAME.equals(ref.getType())) {
                                    if ("submissions".equals(ref.getSubType()) || "grades".equals(ref.getSubType())) {
                                        willHandle = true;
                                        permitted = AssignmentService.allowUpdateAssignment(ref.getReference());
                                    }
                                } else if (GenericSiteService.SERVICE_NAME.equals(ref.getType())) {
                                    willHandle = true;
                                    permitted = true;
                                } else if ("/PrintFileGeneration".equals(path)) {
                                    willHandle = true;
                                    permitted = true;
                                }
                                if (!willHandle) {
                                    this.respondInvalid(req, res, ref.getReference());
                                    break block32;
                                }
                                if (!permitted && UsageSessionService.getSessionUser() == UserDirectoryService.getAnonymousUser()) {
                                    this.respondRedirectToLogin(req, res, path);
                                    break block33;
                                }
                                try {
                                    if (GenericContentHostingService.SERVICE_NAME.equals(ref.getType())) {
                                        if (!ref.getId().endsWith("/")) {
                                            this.doContent(ref.getId(), res);
                                        }
                                        break block34;
                                    }
                                    if (GenericAssignmentService.SERVICE_NAME.equals(ref.getType())) {
                                        if ("submissions".equals(ref.getSubType())) {
                                            this.doAssignmentSubmissions(ref, res);
                                            break block34;
                                        }
                                        if ("grades".equals(ref.getSubType())) {
                                            this.doAssignmentGrades(ref, res);
                                        }
                                        break block34;
                                    }
                                    if (GenericSiteService.SERVICE_NAME.equals(ref.getType())) {
                                        this.doSite(ref, res);
                                        break block34;
                                    } else if ("/PrintFileGeneration".equals(path)) {
                                        this.doPrintingRequest(info, req, res);
                                    }
                                    break block34;
                                }
                                catch (IdUnusedException e) {
                                    this.respondError(req, res, "This Resource does not exit.");
                                }
                                catch (PermissionException e) {
                                    this.respondError(req, res, "You do not have permissions to access this resource.");
                                }
                                catch (Exception e) {
                                    Log.warn("chef", (Object)((Object)this) + ".dispatch(): ref: " + ref.getReference(), (Throwable)e);
                                    this.respondError(req, res, e.toString());
                                }
                                break block34;
                            }
                            catch (Exception e) {
                                Log.warn("chef", (Object)((Object)this) + ".dispatch(): exception: ", (Throwable)e);
                                this.respondError(req, res, e.toString());
                                Object var13_10 = null;
                                this.log(req, info);
                                RunDataFactory.putRunData(data);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var13_11 = null;
                            this.log(req, info);
                            RunDataFactory.putRunData(data);
                            throw throwable;
                        }
                    }
                    RunDataFactory.putRunData(data);
                    return;
                }
                Object var13_7 = null;
                this.log(req, info);
                RunDataFactory.putRunData(data);
                return;
            }
            Object var13_8 = null;
            this.log(req, info);
            RunDataFactory.putRunData(data);
            return;
        }
        Object var13_9 = null;
        this.log(req, info);
        RunDataFactory.putRunData(data);
    }

    public void log(HttpServletRequest req, AccessServletInfo info) {
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", ME + " from:" + req.getRemoteAddr() + " path:" + req.getPathInfo() + " options: " + info.optionsString() + " time: " + info.getElapsedTime());
        }
    }

    protected void respondNotReady(HttpServletRequest req, HttpServletResponse res) {
        try {
            res.setContentType("text/html; charset=UTF-8");
            PrintWriter out = res.getWriter();
            this.startHtml(out);
            VelocityContext context = new VelocityContext();
            context.put("myPortal", new MyPortalsTool());
            TurbineVelocity.handleRequest((Context)context, (String)"access/not_ready.vm", (Writer)out);
            this.endHtml(out);
        }
        catch (Exception e) {
            Log.warn("chef", (Object)((Object)this) + ".respondLogin() exception: " + e.toString());
        }
    }

    protected void respondInvalid(HttpServletRequest req, HttpServletResponse res, String ref) {
        try {
            res.setContentType("text/html; charset=UTF-8");
            PrintWriter out = res.getWriter();
            this.startHtml(out);
            VelocityContext context = new VelocityContext();
            context.put("myPortal", new MyPortalsTool());
            context.put("ref", ref);
            TurbineVelocity.handleRequest((Context)context, (String)"access/invalid.vm", (Writer)out);
            this.endHtml(out);
        }
        catch (Exception e) {
            Log.warn("chef", (Object)((Object)this) + ".respondLogin() exception: " + e.toString());
        }
    }

    protected void respondError(HttpServletRequest req, HttpServletResponse res, String msg) {
        try {
            res.setContentType("text/html; charset=UTF-8");
            PrintWriter out = res.getWriter();
            this.startHtml(out);
            VelocityContext context = new VelocityContext();
            context.put("myPortal", new MyPortalsTool());
            context.put("msg", msg);
            TurbineVelocity.handleRequest((Context)context, (String)"access/error.vm", (Writer)out);
            this.endHtml(out);
        }
        catch (Exception e) {
            Log.warn("chef", (Object)((Object)this) + ".respondLogin() exception: " + e.toString());
        }
    }

    protected void respondRedirectToLogin(HttpServletRequest req, HttpServletResponse res, String path) {
        req.getSession(true).setAttribute("AccessServletPath", (Object)(ServerConfigurationService.getAccessUrl() + path));
        try {
            res.sendRedirect(ServerConfigurationService.getAccessUrl() + LOGIN_PATH);
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    protected void respondLogin(HttpServletRequest req, HttpServletResponse res) {
        String portalRoot = ServerConfigurationService.getPortalUrl();
        if (!UsageSessionService.getSessionUser().equals(UserDirectoryService.getAnonymousUser())) {
            try {
                res.sendRedirect(portalRoot);
            }
            catch (Exception e) {
                Log.warn("chef", (Object)((Object)this) + "respondLogin: exception redirect: ", (Throwable)e);
            }
            return;
        }
        boolean attempted = false;
        String fromLogin = StringUtil.trimToNull(req.getParameter("fromLogin"));
        String name = StringUtil.trimToNull(req.getParameter("username"));
        String pw = StringUtil.trimToNull(req.getParameter("password"));
        if (fromLogin != null) {
            try {
                attempted = true;
                JetspeedUser user = JetspeedSecurity.login((String)name, (String)pw);
                String redirect = (String)req.getSession(false).getAttribute("AccessServletPath");
                req.getSession(false).removeAttribute("AccessServletPath");
                if (redirect == null) {
                    redirect = portalRoot;
                }
                res.sendRedirect(redirect);
                return;
            }
            catch (LoginException e) {
            }
            catch (Exception e) {
                Log.warn("chef", (Object)((Object)this) + "respondLogin: exception logging in", (Throwable)e);
            }
        }
        try {
            res.setContentType("text/html; charset=UTF-8");
            PrintWriter out = res.getWriter();
            this.startHtml(out);
            VelocityContext context = new VelocityContext();
            if (attempted) {
                context.put("message", "Invalid uniqname or password");
            }
            context.put("myPortal", new MyPortalsTool());
            TurbineVelocity.handleRequest((Context)context, (String)"access/um_login.vm", (Writer)out);
            this.endHtml(out);
        }
        catch (Exception e) {
            Log.warn("chef", (Object)((Object)this) + ".respondLogin() exception: " + e.toString());
        }
    }

    protected void doContent(String id, HttpServletResponse res) throws Exception {
        ContentResource resource = ContentHostingService.getResource(id);
        int len = resource.getContentLength();
        String contentType = resource.getContentType();
        byte[] content = resource.getContent();
        if (contentType.equals("text/URL")) {
            res.sendRedirect(new String(content));
        } else {
            if (contentType.equals("text/plain") || contentType.equals("text/html") || contentType.equals("image/gif") || contentType.equals("image/jpeg") || contentType.equals("application/pdf")) {
                res.addHeader("Content-Disposition", "inline; filename=" + id);
            } else {
                res.addHeader("Content-Disposition", "attachment; filename=" + id);
            }
            res.setContentType(contentType);
            res.setContentLength(len);
            res.setBufferSize(len);
            ServletOutputStream out = res.getOutputStream();
            out.write(content);
            out.flush();
            out.close();
        }
    }

    protected void doAssignmentGrades(Reference ref, HttpServletResponse res) throws Exception {
        Blob spreadsheet = AssignmentService.getGradesSpreadsheet(ref.getReference());
        ServletOutputStream out = res.getOutputStream();
        res.setContentType("application/vnd.ms-excel");
        res.setHeader("Content-Disposition", "attachment; filename = export_grades_file.xls");
        out.write(spreadsheet.getBytes());
        out.flush();
    }

    protected void doAssignmentSubmissions(Reference ref, HttpServletResponse res) throws Exception {
        Blob zip = AssignmentService.getSubmissionsZip(ref.getReference());
        ServletOutputStream out = res.getOutputStream();
        res.setContentType("application/x-zip-compressed");
        res.setHeader("Content-Disposition", "attachment; filename = bulk_download.zip");
        out.write(zip.getBytes());
        out.flush();
    }

    protected void doPrintingRequest(AccessServletInfo info, HttpServletRequest req, HttpServletResponse res) {
        try {
            ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
            StringBuffer contentType = new StringBuffer();
            PrintFileGenerator.printSchedule(info.m_options, contentType, this.getServletContext(), outByteStream);
            res.addHeader("Content-Disposition", "inline; filename=schedule.pdf");
            res.setContentType(contentType.toString());
            res.setContentLength(outByteStream.size());
            res.setBufferSize(outByteStream.size());
            ServletOutputStream os = res.getOutputStream();
            outByteStream.writeTo((OutputStream)os);
            os.flush();
            os.close();
        }
        catch (NumberFormatException e) {
            Log.warn("chef", (Object)((Object)this) + ".doPrintingRequest()", (Throwable)e);
            this.respondError(req, res, "Unable to print your request.");
            return;
        }
        catch (IOException e) {
            Log.warn("chef", (Object)((Object)this) + ".doPrintingRequest()", (Throwable)e);
            return;
        }
    }

    protected void doSite(Reference ref, HttpServletResponse res) throws Exception {
        Site site = (Site)ref.getResource();
        res.setContentType("text/html; charset=UTF-8");
        PrintWriter out = res.getWriter();
        out.println("<html><head></head><body>");
        String description = site.getDescription();
        if (description == null) {
            description = site.getTitle();
        }
        description = Validator.escapeHtml(description);
        out.println(description);
        out.println("</body></html>");
    }

    protected void startHtml(PrintWriter out) {
        String webappRoot = ServerConfigurationService.getServerUrl();
        String icon = TurbineResources.getString("topnav.logo.anon.file");
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        out.println("<html><head>");
        out.println("<link href=\"" + webappRoot + "/css/default.css\" type=\"text/css\" rel=\"stylesheet\" media=\"screen\" />");
        out.println("</head><body>");
        out.println("<img src=\"" + webappRoot + "/images/" + icon + "\" border=\"0\" />");
        out.println("<hr class=\"PageNavSpacer\" />");
        out.println("<div style=\"padding: 16px\">");
    }

    protected void endHtml(PrintWriter out) {
        String webappRoot = ServerConfigurationService.getServerUrl();
        out.println("</div><p>&nbsp;</p>");
        out.println("<div align=\"center\" class=\"SmallPrint\">");
        out.println("&nbsp;<br/>");
        out.println("|");
        String[] links = TurbineResources.getStringArray("bottomnav.link");
        int i = 0;
        while (i < links.length) {
            out.println(links[i] + " |");
            ++i;
        }
        out.println("<br/>&nbsp;");
        out.println("</div>");
        out.println("<div align=\"center\" class=\"TinyPrint\">");
        out.println("<a href=\"http://chefproject.org\" target=\"_blank\"><img border=\"0\" src=\"" + webappRoot + "/images/logoC_powered.gif\"></a>");
        out.println("<br/>");
        out.println("&copy; The Regents of the University of Michigan. All rights reserved. Copyright 2002<br/>");
        out.println("CHEF v" + TurbineResources.getString("chef_version") + ", Jetspeed v" + TurbineResources.getString("jetspeed_version"));
        out.println("</div>");
        out.println("</body></html>");
    }

    public AccessServletInfo newInfo(HttpServletRequest req) {
        return new AccessServletInfo(req);
    }

    static {
        FORM_VALUE_DELIMETER = FORM_VALUE_DELIMETER;
        ME = "Access:";
        LOGIN_PATH = LOGIN_PATH;
    }

    public class AccessServletInfo {
        protected long m_startTime = System.currentTimeMillis();
        protected Properties m_options = new Properties();

        public long getStartTime() {
            return this.m_startTime;
        }

        public long getElapsedTime() {
            return System.currentTimeMillis() - this.m_startTime;
        }

        public Properties getOptions() {
            return this.m_options;
        }

        public AccessServletInfo(HttpServletRequest req) {
            String type = req.getContentType();
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String[] values = req.getParameterValues(key);
                if (values.length == 1) {
                    this.m_options.put(key, values[0]);
                    continue;
                }
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < values.length) {
                    buf.append(values[i] + AccessServlet.FORM_VALUE_DELIMETER);
                    ++i;
                }
                this.m_options.put(key, buf.toString());
            }
        }

        public String optionsString() {
            StringBuffer buf = new StringBuffer(1024);
            Enumeration<Object> e = this.m_options.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String o = this.m_options.getProperty(key);
                if (!(o instanceof String)) continue;
                buf.append(key);
                buf.append("=");
                if (key.equals("password")) {
                    buf.append("*****");
                } else {
                    buf.append(o.toString());
                }
                buf.append("&");
            }
            return buf.toString();
        }
    }

    public class AccessServletInit
    extends Thread {
        public AccessServletInit() {
            AccessServlet.this.m_ready = false;
            this.start();
        }

        public void run() {
            AccessServlet.this.m_ready = true;
        }
    }
}

