/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.upload.FileItem;
import org.apache.velocity.context.Context;
import org.chefproject.actions.ActionTeamlet;
import org.chefproject.core.ContentCollection;
import org.chefproject.core.ContentResource;
import org.chefproject.core.ResourcePropertiesEdit;
import org.chefproject.service.ContentHostingService;
import org.chefproject.service.ContentTypeImageService;
import org.chefproject.util.ContentHostingComparator;
import org.chefproject.util.DefaultId;
import org.chefproject.util.Menu;
import org.chefproject.util.MenuEntry;
import org.chefproject.util.Reference;
import org.chefproject.util.ReferenceVector;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Validator;

public class AttachmentAction
extends ActionTeamlet {
    public static final String STATE_MODE = "attachment.mode";
    public static final String STATE_ATTACHMENTS = "attachment.attachments";
    public static final String STATE_FROM_TEXT = "attachment.from_text";
    private static final String STATE_ATTACHMENT = "attachment.attachment";
    private static final String STATE_CONTENT_TYPE_IMAGE_SERVICE = "attachment.content_type_image_service";
    private static final String STATE_BROWSE_COLLECTION_ID = "attachment.collection_id";
    private static final String STATE_HOME_COLLECTION_ID = "attachment.collection_home";
    public static final String MODE_DONE = "done";
    public static final String MODE_MAIN = "main";
    private static final String MODE_BROWSE = "browse";
    private static final String MODE_PROPERTIES = "props";
    private static final String MODE_UPLOAD = "upload";
    private static final String MODE_URL = "url";
    private static final String TEMPLATE_MAIN = "chef_attachment_main";
    private static final String TEMPLATE_BROWSE = "chef_attachment_browse";
    private static final String TEMPLATE_PROPERTIES = "chef_attachment_properties";
    private static final String TEMPLATE_UPLOAD = "chef_attachment_upload";
    private static final String TEMPLATE_URL = "chef_attachment_url";
    public static final String TYPE_URL = "text/URL";

    public static String buildHelperContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        ReferenceVector attachments = (ReferenceVector)state.getAttribute(STATE_ATTACHMENTS);
        if (attachments == null) {
            attachments = new ReferenceVector();
            state.setAttribute(STATE_ATTACHMENTS, (Object)attachments);
        }
        if (state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE) == null) {
            state.setAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE, (Object)TurbineServices.getInstance().getService(ContentTypeImageService.SERVICE_NAME));
        }
        if (state.getAttribute(STATE_FROM_TEXT) == null) {
            state.setAttribute(STATE_FROM_TEXT, (Object)"");
        }
        context.put("action", "AttachmentAction");
        context.put("from", "Attachments for " + state.getAttribute(STATE_FROM_TEXT));
        String mode = (String)state.getAttribute(STATE_MODE);
        if (mode == null) {
            mode = MODE_MAIN;
        }
        if (mode.equals(MODE_MAIN)) {
            return AttachmentAction.buildMainContext(portlet, context, rundata, state);
        }
        if (mode.equals(MODE_BROWSE)) {
            return AttachmentAction.buildBrowseContext(portlet, context, rundata, state);
        }
        if (mode.equals(MODE_PROPERTIES)) {
            return AttachmentAction.buildPropertiesContext(portlet, context, rundata, state);
        }
        if (mode.equals(MODE_UPLOAD)) {
            return AttachmentAction.buildUploadContext(portlet, context, rundata, state);
        }
        if (mode.equals(MODE_URL)) {
            return AttachmentAction.buildUrlContext(portlet, context, rundata, state);
        }
        return null;
    }

    public static String buildMainContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        ReferenceVector attachments = (ReferenceVector)state.getAttribute(STATE_ATTACHMENTS);
        context.put("attachments", attachments);
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        AttachmentAction.buildMenu(portlet, context, rundata, state, true, attachments.size() > 0);
        context.put("enabled", new Boolean(true));
        context.put("anyattachment", new Boolean(attachments.size() > 0));
        return TEMPLATE_MAIN;
    }

    public static String buildBrowseContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        String id = (String)state.getAttribute(STATE_BROWSE_COLLECTION_ID);
        if (id == null) {
            id = DefaultId.getCollection();
            state.setAttribute(STATE_BROWSE_COLLECTION_ID, (Object)id);
            state.setAttribute(STATE_HOME_COLLECTION_ID, (Object)id);
        }
        context.put("contentHostingService", ContentHostingService.getInstance());
        String collectionDisplayName = null;
        List members = null;
        try {
            ContentCollection collection = ContentHostingService.getCollection(id);
            collectionDisplayName = collection.getProperties().getPropertyFormatted("DAV:displayname");
            members = collection.getMemberResources();
            Collections.sort(members, new ContentHostingComparator("DAV:displayname", true));
        }
        catch (Exception e) {
            collectionDisplayName = DefaultId.getDisplayName();
            members = new Vector();
        }
        context.put("collectionDisplayName", collectionDisplayName);
        context.put("collectionMembers", members);
        context.put("includeUp", new Boolean(!id.equals(state.getAttribute(STATE_HOME_COLLECTION_ID))));
        context.put("attachments", state.getAttribute(STATE_ATTACHMENTS));
        context.put("contentTypeImageService", state.getAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE));
        AttachmentAction.buildMenu(portlet, context, rundata, state, false, false);
        context.put("enabled", new Boolean(false));
        context.put("anyattachment", new Boolean(false));
        return TEMPLATE_BROWSE;
    }

    public static String buildUploadContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        AttachmentAction.buildMenu(portlet, context, rundata, state, false, false);
        context.put("enabled", new Boolean(false));
        context.put("anyattachment", new Boolean(false));
        return TEMPLATE_UPLOAD;
    }

    public static String buildUrlContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        AttachmentAction.buildMenu(portlet, context, rundata, state, false, false);
        context.put("enabled", new Boolean(false));
        context.put("anyattachment", new Boolean(false));
        return TEMPLATE_URL;
    }

    private static void buildMenu(VelocityPortlet portlet, Context context, RunData rundata, SessionState state, boolean enabled, boolean anyAttachments) {
        Menu bar = new Menu((Portlet)portlet, rundata, "AttachmentAction");
        String formName = "mainForm";
        bar.add(new MenuEntry("Local File...", null, enabled, 0, "doUpload", formName));
        bar.add(new MenuEntry("Website URL...", null, enabled, 0, "doUrl", formName));
        bar.add(new MenuEntry("From Resources...", null, enabled, 0, "doBrowse", formName));
        bar.add(new MenuEntry("Remove Selected", null, enabled && anyAttachments, 0, "doRemove", formName));
        bar.add(new MenuEntry("Remove All", null, enabled && anyAttachments, 0, "doRemove_all", formName));
        context.put("menu", bar);
        context.put("action", "AttachmentAction");
        state.setAttribute("menu", (Object)bar);
    }

    public static String buildPropertiesContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("attachment", state.getAttribute(STATE_ATTACHMENT));
        return TEMPLATE_PROPERTIES;
    }

    private void cleanupState(SessionState state) {
        state.removeAttribute(STATE_ATTACHMENT);
        state.removeAttribute(STATE_CONTENT_TYPE_IMAGE_SERVICE);
        state.removeAttribute(STATE_BROWSE_COLLECTION_ID);
        state.removeAttribute(STATE_HOME_COLLECTION_ID);
        state.removeAttribute(STATE_FROM_TEXT);
    }

    public void doSave(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_MODE, (Object)MODE_DONE);
        this.cleanupState(state);
    }

    public void doCancel(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_MODE, (Object)MODE_DONE);
        state.removeAttribute(STATE_ATTACHMENTS);
        this.cleanupState(state);
    }

    public void doBrowse(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_MODE, (Object)MODE_BROWSE);
    }

    public void doUpload(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_MODE, (Object)MODE_UPLOAD);
    }

    public void doUrl(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_MODE, (Object)MODE_URL);
    }

    public void doAdd(RunData data) {
        FileItem file;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        Vector attachments = (Vector)state.getAttribute(STATE_ATTACHMENTS);
        String url = data.getParameters().getString(MODE_URL);
        if (url != null) {
            url = url.trim();
        }
        if (url != null && url.length() > 0) {
            if (url.indexOf("://") == -1) {
                url = "http://" + url;
            }
            ResourcePropertiesEdit props = ContentHostingService.newResourceProperties();
            props.addProperty("DAV:displayname", url);
            props.addProperty("CHEF:description", url);
            try {
                ContentResource attachment = ContentHostingService.addAttachmentResource(Validator.escapeResourceName(url), TYPE_URL, url.getBytes(), props);
                attachments.add(new Reference(attachment.getReference()));
            }
            catch (Exception any) {
                Log.warn("chef", this + ".doAdd: exception adding attachment resource (urlName: " + Validator.escapeResourceName(url) + "): " + any.toString());
            }
        }
        if ((file = data.getParameters().getFileItem("file")) != null) {
            byte[] in = file.get();
            String contentType = file.getContentType();
            String browserFileName = file.getFileName();
            String name = Validator.getFileName(browserFileName);
            ResourcePropertiesEdit props = ContentHostingService.newResourceProperties();
            props.addProperty("DAV:displayname", name);
            props.addProperty("CHEF:description", browserFileName);
            try {
                ContentResource attachment = ContentHostingService.addAttachmentResource(name, contentType, in, props);
                attachments.add(new Reference(attachment.getReference()));
            }
            catch (Exception any) {
                Log.warn("chef", this + ".doAdd: exception adding attachment resource (fileName: " + name + "): " + any.toString());
            }
        }
        state.setAttribute(STATE_MODE, (Object)MODE_MAIN);
    }

    public void doRemove(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        Vector attachments = (Vector)state.getAttribute(STATE_ATTACHMENTS);
        String[] selected = data.getParameters().getStrings("select");
        if (selected == null) {
            if (attachments.size() == 1) {
                attachments.clear();
            } else {
                state.setAttribute("message", (Object)"Alert: No attachments were selected to be removed.");
            }
        } else {
            int i = selected.length - 1;
            while (i >= 0) {
                try {
                    int index = Integer.parseInt(selected[i]) - 1;
                    attachments.removeElementAt(index);
                }
                catch (Exception e) {
                    Log.warn("chef", this + ".doRemove(): processing selected [" + i + "] : " + e.toString());
                }
                --i;
            }
        }
        state.setAttribute(STATE_MODE, (Object)MODE_MAIN);
    }

    public void doRemove_all(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        Vector attachments = (Vector)state.getAttribute(STATE_ATTACHMENTS);
        attachments.clear();
        state.setAttribute(STATE_MODE, (Object)MODE_MAIN);
    }

    public void doProperties(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        Vector attachments = (Vector)state.getAttribute(STATE_ATTACHMENTS);
        Object attachment = null;
        state.setAttribute(STATE_ATTACHMENT, attachment);
        state.setAttribute(STATE_MODE, (Object)MODE_PROPERTIES);
    }

    public void doCancel_browse(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.removeAttribute(STATE_BROWSE_COLLECTION_ID);
        state.removeAttribute(STATE_HOME_COLLECTION_ID);
        state.setAttribute(STATE_MODE, (Object)MODE_MAIN);
    }

    public void doCancel_add(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute(STATE_MODE, (Object)MODE_MAIN);
    }

    public void doBrowse_option(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String[] ids = data.getParameters().getStrings("selectedMembers");
        Vector<String> idVector = new Vector<String>();
        if (ids != null && ids.length > 0) {
            int index = 0;
            while (index < ids.length) {
                idVector.add(ids[index]);
                ++index;
            }
        }
        this.updateAttachments(state, idVector);
        String option = data.getParameters().getString("option");
        if (option.equals("up")) {
            String id = (String)state.getAttribute(STATE_BROWSE_COLLECTION_ID);
            if (id.equals(state.getAttribute(STATE_HOME_COLLECTION_ID))) {
                return;
            }
            String containingId = ContentHostingService.getContainingCollectionId(id);
            if (ContentHostingService.allowGetCollection(containingId)) {
                state.setAttribute(STATE_BROWSE_COLLECTION_ID, (Object)containingId);
            } else {
                state.setAttribute("message", (Object)"Alert: You do not have permission to view that folder.");
            }
            state.setAttribute(STATE_MODE, (Object)MODE_BROWSE);
        } else if (option.equals("down")) {
            String id = data.getParameters().getString("itemId");
            if (ContentHostingService.allowGetCollection(id)) {
                state.setAttribute(STATE_BROWSE_COLLECTION_ID, (Object)id);
            } else {
                state.setAttribute("message", (Object)"Alert: You do not have permission to view that folder.");
            }
            state.setAttribute(STATE_MODE, (Object)MODE_BROWSE);
        } else {
            state.removeAttribute(STATE_BROWSE_COLLECTION_ID);
            state.removeAttribute(STATE_HOME_COLLECTION_ID);
            state.setAttribute(STATE_MODE, (Object)MODE_MAIN);
        }
    }

    private void updateAttachments(SessionState state, Vector ids) {
        String id = (String)state.getAttribute(STATE_BROWSE_COLLECTION_ID);
        ReferenceVector attachments = (ReferenceVector)state.getAttribute(STATE_ATTACHMENTS);
        List members = null;
        try {
            ContentCollection collection = ContentHostingService.getCollection(id);
            members = collection.getMembers();
            int i = 0;
            while (i < members.size()) {
                String memberId = (String)members.get(i);
                String ref = ContentHostingService.getReference(memberId);
                if (ids.contains(memberId)) {
                    if (!attachments.contains(ref)) {
                        attachments.add(new Reference(ref));
                    }
                } else {
                    attachments.remove(ref);
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void doCancel_properties(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.removeAttribute(STATE_ATTACHMENT);
        state.setAttribute(STATE_MODE, (Object)MODE_MAIN);
    }

    public void doUpdate_properties(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        Reference attachment = (Reference)state.getAttribute(STATE_ATTACHMENT);
        state.removeAttribute(STATE_ATTACHMENT);
        state.setAttribute(STATE_MODE, (Object)MODE_MAIN);
    }

    public void doPerform(RunData data) throws Exception {
        String special = StringUtil.trimToNull(data.getParameters().getString("special"));
        if (MODE_UPLOAD.equals(special)) {
            SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
            state.setAttribute("message", (Object)"The request is over the maximum request limit.  This file cannot be uploaded.");
        } else {
            Log.warn("chef", this + ".doPerform(): unexpected call");
        }
        ActionTeamlet.redirectToPane((JetspeedRunData)data);
    }

    static {
        STATE_MODE = STATE_MODE;
        STATE_ATTACHMENTS = STATE_ATTACHMENTS;
        STATE_FROM_TEXT = STATE_FROM_TEXT;
        STATE_ATTACHMENT = STATE_ATTACHMENT;
        STATE_CONTENT_TYPE_IMAGE_SERVICE = STATE_CONTENT_TYPE_IMAGE_SERVICE;
        STATE_BROWSE_COLLECTION_ID = STATE_BROWSE_COLLECTION_ID;
        STATE_HOME_COLLECTION_ID = STATE_HOME_COLLECTION_ID;
        MODE_DONE = MODE_DONE;
        MODE_MAIN = MODE_MAIN;
        MODE_BROWSE = MODE_BROWSE;
        MODE_PROPERTIES = MODE_PROPERTIES;
        MODE_UPLOAD = MODE_UPLOAD;
        MODE_URL = MODE_URL;
        TEMPLATE_MAIN = TEMPLATE_MAIN;
        TEMPLATE_BROWSE = TEMPLATE_BROWSE;
        TEMPLATE_PROPERTIES = TEMPLATE_PROPERTIES;
        TEMPLATE_UPLOAD = TEMPLATE_UPLOAD;
        TEMPLATE_URL = TEMPLATE_URL;
        TYPE_URL = TYPE_URL;
    }
}

