/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.xmlrpc.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import javax.mail.internet.MimeUtility;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.services.servlet.TurbineServlet;
import org.apache.turbine.util.Log;

public class FileHandler {
    public boolean send(String fileContents, String targetLocationProperty, String fileName) {
        return FileHandler.writeFileContents(fileContents, targetLocationProperty, fileName);
    }

    public String get(String targetLocationProperty, String fileName) {
        return FileHandler.readFileContents(targetLocationProperty, fileName);
    }

    public static String readFileContents(String targetLocationProperty, String fileName) {
        String file = TurbineServlet.getRealPath(TurbineResources.getString(targetLocationProperty) + "/" + fileName);
        try {
            StringWriter sw = new StringWriter();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            char[] buf = new char[1024];
            int len = 0;
            while ((len = reader.read(buf, 0, 1024)) != -1) {
                sw.write(buf, 0, len);
            }
            return MimeUtility.encodeText(sw.toString(), "UTF-8", "base64");
        }
        catch (IOException ioe) {
            Log.error("[FileHandler] Unable to encode the contents of the request file.", ioe);
            return null;
        }
    }

    public static boolean writeFileContents(String fileContents, String targetLocationProperty, String fileName) {
        File targetLocation = new File(TurbineServlet.getRealPath(TurbineResources.getString(targetLocationProperty)));
        if (!targetLocation.exists()) {
            if (!targetLocation.mkdirs()) {
                Log.error("[FileHandler] Could not create target location: " + targetLocation + ". Cannot transfer file from client.");
                return false;
            }
            Log.info("[FileHandler] Creating target location:" + targetLocation + " in order to complete file transfer from client.");
        }
        try {
            FileWriter fileWriter = new FileWriter(targetLocation + "/" + fileName);
            fileWriter.write(MimeUtility.decodeText(fileContents));
            fileWriter.close();
            return true;
        }
        catch (IOException ioe) {
            Log.error("[FileHandler] Could not write the decoded file contents to disk for the following reason.", ioe);
            return false;
        }
    }

    public static void remove(String sourceLocationProperty, String sourceFileName) {
        File sourceFile = new File(TurbineServlet.getRealPath(TurbineResources.getString(sourceLocationProperty) + "/" + sourceFileName));
        if (sourceFile.exists()) {
            sourceFile.delete();
        }
    }
}

