/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.resourceobject;

import com.sourceforge.knecs.dsm.resourceobject.ResourceObject;

public class DigestNotification
extends ResourceObject {
    public static final String SUBJECT = "http://purl.oclc.org/NET/cmcs/schema/:title";
    public static final String BODY = "http://purl.oclc.org/NET/cmcs/schema/:message";
    public static final String RECIPIENTS = "http://purl.oclc.org/NET/cmcs/schema/:recipient";
    public static final String DIGESTPERIOD = "http://purl.oclc.org/NET/cmcs/internal/schema/:notify-interval";
    public static final String URLCONTEXT = "http://purl.oclc.org/NET/cmcs/internal/schema/:samurl";
    public static final String URLDISPLAYNAME = "http://purl.oclc.org/NET/cmcs/internal/schema/:samurldisplayname";
    public static final String URLRESOURCETYPE = "http://purl.oclc.org/NET/cmcs/internal/schema/:samurlresourcetype";
    public static final String URLCONTENTTYPE = "http://purl.oclc.org/NET/cmcs/internal/schema/:samurlcontenttype";
    public static final String PARENTURL = "http://purl.oclc.org/NET/cmcs/internal/schema/:parenturl";
    public static final String PARENTURLDISPLAYNAME = "http://purl.oclc.org/NET/cmcs/internal/schema/:parenturldisplayname";
    public static final String PRODUCER = "http://purl.oclc.org/NET/cmcs/schema/:producer";
    public static final String METHOD = "http://purl.oclc.org/NET/cmcs/internal/schema/:sammethod";
    public static final String SUBSCRIPTION = "http://purl.oclc.org/NET/cmcs/internal/schema/:subscription";
    public static final String TIMERECEIVED = "http://purl.org/dc/terms/:created";
    public static final String SECONDS = "http://purl.oclc.org/NET/cmcs/internal/schema/:seconds";
    public static final String QUERYPROPERTIES = "http://purl.oclc.org/NET/cmcs/internal/schema/:queryproperties";
    public static final String SAMPROPERTIES = "http://purl.oclc.org/NET/cmcs/internal/schema/:samproperties";
    public static final String DESTURL = "http://purl.oclc.org/NET/cmcs/internal/schema/:samnewurl";
    public static final String DESTURLDISPLAYNAME = "http://purl.oclc.org/NET/cmcs/internal/schema/:samnewurldisplayname";
    public static final String TRANSLATEDBY = "http://purl.oclc.org/NET/cmcs/internal/schema/:samtranslatedby";

    public DigestNotification() {
        this.setAttributeTypes();
        try {
            this.add("http://purl.org/dc/elements/1.1/:type", this.getClass().getName());
        }
        catch (Exception dsme) {
            this.mLog.severe("Exception creating DigestNotification class: " + dsme.toString());
        }
    }

    private void setAttributeTypes() {
        this.mAttributeTypes.put(URLCONTEXT, String.class);
        this.mAttributeTypes.put(URLDISPLAYNAME, String.class);
        this.mAttributeTypes.put(URLCONTENTTYPE, String.class);
        this.mAttributeTypes.put(URLRESOURCETYPE, String.class);
        this.mAttributeTypes.put(PRODUCER, String.class);
        this.mAttributeTypes.put(METHOD, String.class);
        this.mAttributeTypes.put(TIMERECEIVED, String.class);
        this.mAttributeTypes.put(SECONDS, String.class);
        this.mAttributeTypes.put(DESTURL, String.class);
        this.mAttributeTypes.put(DESTURLDISPLAYNAME, String.class);
        this.mAttributeTypes.put(TRANSLATEDBY, String.class);
        this.mAttributeTypes.put(RECIPIENTS, String[].class);
        this.mAttributeTypes.put(SUBJECT, String.class);
        this.mAttributeTypes.put(BODY, String.class);
        this.mAttributeTypes.put(PARENTURL, String.class);
        this.mAttributeTypes.put(PARENTURLDISPLAYNAME, String.class);
        this.mAttributeTypes.put(DIGESTPERIOD, String.class);
        this.mAttributeTypes.put(SAMPROPERTIES, String.class);
        this.mAttributeTypes.put(QUERYPROPERTIES, String[].class);
        this.mAttributeTypes.put(SUBSCRIPTION, String.class);
    }

    public String getSubject() {
        Object obj = this.mResourceEntry.get(SUBJECT);
        return (String)obj;
    }

    public String getProducer() {
        Object obj = this.mResourceEntry.get(PRODUCER);
        return (String)obj;
    }

    public String[] getRecipients() {
        return this.getAsStringArray(RECIPIENTS);
    }

    public String getTranslator() {
        Object obj = this.mResourceEntry.get(TRANSLATEDBY);
        return (String)obj;
    }

    public String getDestination() {
        Object obj = this.mResourceEntry.get(DESTURL);
        return (String)obj;
    }

    public String getDestinationDisplayName() {
        Object obj = this.mResourceEntry.get(DESTURLDISPLAYNAME);
        return (String)obj;
    }

    public String getBody() {
        Object obj = this.mResourceEntry.get(BODY);
        return (String)obj;
    }

    public String getPeriod() {
        Object obj = this.mResourceEntry.get(DIGESTPERIOD);
        return (String)obj;
    }

    public String getURL() {
        Object obj = this.mResourceEntry.get(URLCONTEXT);
        return (String)obj;
    }

    public String getURLDisplayName() {
        Object obj = this.mResourceEntry.get(URLDISPLAYNAME);
        return (String)obj;
    }

    public String getURLContentType() {
        Object obj = this.mResourceEntry.get(URLCONTENTTYPE);
        return (String)obj;
    }

    public String getURLResourceType() {
        Object obj = this.mResourceEntry.get(URLRESOURCETYPE);
        return (String)obj;
    }

    public String getMethod() {
        Object obj = this.mResourceEntry.get(METHOD);
        return (String)obj;
    }

    public String getTimeReceived() {
        Object obj = this.mResourceEntry.get(TIMERECEIVED);
        return (String)obj;
    }

    public String getTimeReceivedInSeconds() {
        Object obj = this.mResourceEntry.get(SECONDS);
        return (String)obj;
    }

    public String[] getQueryProperties() {
        Object[] properties = (Object[])this.mResourceEntry.get(QUERYPROPERTIES);
        if (properties != null) {
            properties = (Object[])properties.clone();
        }
        return (String[])properties;
    }

    public String getSAMProperties() {
        Object obj = this.mResourceEntry.get(SAMPROPERTIES);
        return (String)obj;
    }

    public String getSubscriptionName() {
        Object obj = this.mResourceEntry.get(SUBSCRIPTION);
        return (String)obj;
    }

    public String getParentURL() {
        Object obj = this.mResourceEntry.get(PARENTURL);
        return (String)obj;
    }

    public String getParentDisplayName() {
        Object obj = this.mResourceEntry.get(PARENTURLDISPLAYNAME);
        return (String)obj;
    }

    public void setSubject(String subject) {
        this.mResourceEntry.put(SUBJECT, subject);
    }

    public void setBody(String body) {
        this.mResourceEntry.put(BODY, body);
    }

    public void setURL(String url) {
        this.mResourceEntry.put(URLCONTEXT, url);
    }

    public void setURLDisplayName(String name) {
        this.mResourceEntry.put(URLDISPLAYNAME, name);
    }

    public void setURLResourceType(String type) {
        this.mResourceEntry.put(URLRESOURCETYPE, type);
    }

    public void setURLContentType(String type) {
        this.mResourceEntry.put(URLCONTENTTYPE, type);
    }

    public void setProducer(String producer) {
        this.mResourceEntry.put(PRODUCER, producer);
    }

    public void setRecipients(String[] recipients) {
        this.mResourceEntry.put(RECIPIENTS, recipients);
    }

    public void setTranslator(String transname) {
        this.mResourceEntry.put(TRANSLATEDBY, transname);
    }

    public void setDestination(String destination) {
        this.mResourceEntry.put(DESTURL, destination);
    }

    public void setDestinationDisplayName(String name) {
        this.mResourceEntry.put(DESTURLDISPLAYNAME, name);
    }

    public void setMethod(String method) {
        this.mResourceEntry.put(METHOD, method);
    }

    public void setPeriod(String period) {
        this.mResourceEntry.put(DIGESTPERIOD, period);
    }

    public void setTimeReceived(String time) {
        this.mResourceEntry.put(TIMERECEIVED, time);
    }

    public void setTimeReceivedInSeconds(String time) {
        this.mResourceEntry.put(SECONDS, time);
    }

    public void setQueryProperties(String[] properties) {
        this.mResourceEntry.put(QUERYPROPERTIES, properties);
    }

    public void setSAMProperties(String properties) {
        this.mResourceEntry.put(SAMPROPERTIES, properties);
    }

    public void setSubscriptionName(String subscription) {
        this.mResourceEntry.put(SUBSCRIPTION, subscription);
    }

    public void setParentURL(String url) {
        this.mResourceEntry.put(PARENTURL, url);
    }

    public void setParentDisplayName(String name) {
        this.mResourceEntry.put(PARENTURLDISPLAYNAME, name);
    }
}

