/*                               -*- Mode: C -*- 
 * sec.h -- header for sec protocol module
 * 
 * Copyright (C) 2000 John Marley
 * The author can be contacted at: John.Marley@alcatel.com.au
 * 
 * Author          : John Marley
 * Created On      : Thu Mar 29 11:07:01 2001
 * Last Modified By: John Marley
 * Last Modified On: Fri May  4 16:26:00 2001
 * Update Count    : 53
 * Status          : Unknown, Use with caution!
 * $Locker:  $
 * $Log: sec.h,v $
 * Revision 1.2  2001/05/08 03:21:09  marleyj
 * Added supported() macro.
 *
 * Revision 1.1  2001/05/02 04:54:33  marleyj
 * Initial revision
 *
 */

#define SEC_MSG_STARTCHAR	'^'
#define SEC_POLLCMD		'P'
#define SEC_SETCMD		'S'
#define SEC_DATAMSG		'D'
#define SEC_UPSMSG		'*'
#define SEC_ACK			'1'
#define SEC_NAK			'0'

/* commands */
#define SEC_AVAILP1	"AP1"		/* Part1 of available variables */
#define SEC_AVAILP2	"AP2"		/* Part1 of available variables */
#define SEC_AUTORESTART	"ATR"		/* Enable/disable auto restart */
#define SEC_MFR		"MAN"		/* UPS Manufacturer */
#define SEC_MOD		"MOD"		/* UPS Model */
#define SEC_NOMINAL	"NOM"		/* Nominal Values */
#define SEC_SHUTDOWN	"PSD"		/* Shutdown after delay/cancel */
#define SEC_REBOOT	"RWD"		/* Reboot with duration/cancel */
#define SEC_SHUTTYPE	"SDA"		/* Shutdown Type */
#define SEC_BATTSTAT	"ST1"		/* Battery Status */
#define SEC_INPUTSTAT	"ST2"		/* Input Status */
#define SEC_OUTPUTSTAT	"ST3"		/* Output Status */
#define SEC_BYPASSSTAT	"ST4"		/* Bypass Status */
#define SEC_ALARMSTAT	"ST5"		/* UPS Alarms */
#define SEC_STARTDELAY	"STD"		/* Startup after delay */
#define SEC_TESTRESULT	"STR"		/* Test Results */
#define SEC_TEST	"TST"		/* UPS Test/abort */
#define SEC_BAUDRATE	"UBR"		/* UPS Baud Rate */
#define SEC_UPSID	"UID"		/* UPS Identifier */
#define SEC_VERSION	"VER"		/* UPS Software Version */

/* Some baud rates for setup_serial() */
struct baud_rate_t {
    int rate;
    int name;
} baud_rates[] = {
    { B1200,  1200 },
    { B2400,  2400 },
    { B4800,  4800 },
    { B9600,  9600 },
    { B19200, 19200 },
};

/*
 * Exhaustive information for each possible variable
 */
#define SEC_NUMVARS 89
#define SEC_MAX_VARSIZE 65

/* macro for checking whether a variable is supported */
#define supported(v)	(getdata(v) != NULL)

struct sec_varlist_t {
    int  infotag;	/* INFO_x define from shared.h */
    char *name;		/* Human readable text (also in shared-tables.h) */
    int  unit;		/* Variable should be divided by this */
    char *cmd;		/* Command to send to pool/set variable */
    int  field;		/* Which returned field variable corresponsd to */
    int  size;		/* string length/integer max/enum count */
    int  edi;		/* 'E'numerated 'D'ata 'I'ndex */
    int  flags;		/* Flags for addinfo() */
    char value[SEC_MAX_VARSIZE];
} sec_varlist[] = {
    { INFO_UNUSED,          "",                          0, "",              0,       0,  0, 0 },
    /*infotag               name                      unit  cmd          field     size edi  flags */
    { INFO_ALRM_PWRWAIT,    "Alarm Awaiting Power",      1, SEC_ALARMSTAT,  13,       2,  0, FLAG_ENUM },
    { INFO_ALRM_BADBYPASS,  "Alarm Bypass Bad",          1, SEC_ALARMSTAT,   5,       2,  2, FLAG_ENUM },
    { INFO_ALRM_CHARGFAIL,  "Alarm Charger Failure",     1, SEC_ALARMSTAT,   8,       2,  4, FLAG_ENUM },
    { INFO_ALRM_FANFAIL,    "Alarm Fan Failure",         1, SEC_ALARMSTAT,  10,       2,  6, FLAG_ENUM },
    { INFO_ALRM_FUSEFAIL,   "Alarm Fuse Failure",        1, SEC_ALARMSTAT,  11,       2,  8, FLAG_ENUM },
    { INFO_ALRM_GENERAL,    "Alarm General Fault",       1, SEC_ALARMSTAT,  12,       2, 10, FLAG_ENUM },
    { INFO_ALRM_BADINPUT,   "Alarm Input Bad",           1, SEC_ALARMSTAT,   2,       2, 12, FLAG_ENUM },
    { INFO_ALRM_BADOUTPUT,  "Alarm Output Bad",          1, SEC_ALARMSTAT,   3,       2, 14, FLAG_ENUM },
    { INFO_ALRM_OUTPUTOFF,  "Alarm Output Off",          1, SEC_ALARMSTAT,   6,       2, 16, FLAG_ENUM },
    { INFO_ALRM_OVERLOAD,   "Alarm Overload",            1, SEC_ALARMSTAT,   4,       2, 18, FLAG_ENUM },
    { INFO_ALRM_IMMSHUT,    "Alarm Shutdown Imminent",   1, SEC_ALARMSTAT,  15,       2, 20, FLAG_ENUM },
    { INFO_ALRM_PENDSHUT,   "Alarm Shutdown Pending",    1, SEC_ALARMSTAT,  14,       2, 22, FLAG_ENUM },
    { INFO_ALRM_SYSOFF,     "Alarm System Off",          1, SEC_ALARMSTAT,   9,       2, 24, FLAG_ENUM },
    { INFO_ALRM_TEMP,       "Alarm Temperature",         1, SEC_ALARMSTAT,   1,       2, 26, FLAG_ENUM },
    { INFO_ALRM_UPSSHUT,    "Alarm UPS Shutdown",        1, SEC_ALARMSTAT,   7,       2, 28, FLAG_ENUM },
    { INFO_AUDIBLEALRM,     "Audible Alarm",             1, SEC_NOMINAL,     8,       4, 29, FLAG_ENUM | FLAG_RW },
    { INFO_AUTORESTART,     "Auto Restart",              1, SEC_AUTORESTART, 1,       2, 33, FLAG_ENUM | FLAG_RW },
    { INFO_BATT_CHARGE,     "Battery Charge",            1, SEC_BATTSTAT,    3,       4, 36, FLAG_ENUM },
    { INFO_BATT_COND,       "Battery Condition",         1, SEC_BATTSTAT,    1,       3, 40, FLAG_ENUM },
    { INFO_BATT_CURRENT,    "Battery Current",          10, SEC_BATTSTAT,    8,    9999,  0, 0 },
    { INFO_BATT_DATE,       "Battery Installed",         1, SEC_NOMINAL,    11,       8,  0, FLAG_STRING | FLAG_RW },
    { INFO_BATT_STATUS,     "Battery Status",            1, SEC_BATTSTAT,    2,       3, 43, FLAG_ENUM },
    { INFO_BATT_TEMP,       "Battery Temperature",       1, SEC_BATTSTAT,    9,      99,  0, 0 },
    { INFO_BATT_VOLT,	    "Battery Voltage",          10, SEC_BATTSTAT,    7,    9999,  0, 0 },
    { INFO_BYPASS_CURRENT1, "Bypass Current 1",         10, SEC_BYPASSSTAT,  4,    9999,  0, 0 },
    { INFO_BYPASS_CURRENT2, "Bypass Current 2",         10, SEC_BYPASSSTAT,  7,    9999,  0, 0 },
    { INFO_BYPASS_CURRENT3, "Bypass Current 3",         10, SEC_BYPASSSTAT, 10,    9999,  0, 0 },
    { INFO_BYPASS_FREQ,     "Bypass Frequency",         10, SEC_BYPASSSTAT,  1,     999,  0, 0 },
    { INFO_BYPASS_NLINES,   "Bypass Num Lines",          1, SEC_BYPASSSTAT,  2,       9,  0, 0 },
    { INFO_BYPASS_PWR1,     "Bypass Power 1",            1, SEC_BYPASSSTAT,  5,   99999,  0, 0 },
    { INFO_BYPASS_PWR2,     "Bypass Power 2",            1, SEC_BYPASSSTAT,  8,   99999,  0, 0 },
    { INFO_BYPASS_PWR3,     "Bypass Power 3",            1, SEC_BYPASSSTAT, 11,   99999,  0, 0 },
    { INFO_BYPASS_VOLT1,    "Bypass Voltage 1",         10, SEC_BYPASSSTAT,  3,    9999,  0, 0 },
    { INFO_BYPASS_VOLT2,    "Bypass Voltage 2",         10, SEC_BYPASSSTAT,  6,    9999,  0, 0 },
    { INFO_BYPASS_VOLT3,    "Bypass Voltage 3",         10, SEC_BYPASSSTAT,  9,    9999,  0, 0 },
    { INFO_BATT_PCT,        "Estimated Charge",          1, SEC_BATTSTAT,    6,     999,  0, 0 },
    { INFO_RUNTIME,         "Estimated Minutes",         1, SEC_BATTSTAT,    5,     999,  0, 0 },
    { INFO_HIGHXFER,        "High Volt Xfer Pt",         1, SEC_NOMINAL,    10,     999,  0, FLAG_STRING | FLAG_RW },
    { INFO_UPSIDENT,        "Identification",            1, SEC_UPSID,       1,      64,  0, FLAG_STRING | FLAG_RW },
    { INFO_IN_CURRENT1,     "Input Current 1",          10, SEC_INPUTSTAT,   5,    9999,  0, 0 },
    { INFO_IN_CURRENT2,     "Input Current 2",          10, SEC_INPUTSTAT,   9,    9999,  0, 0 },
    { INFO_IN_CURRENT3,     "Input Current 3",          10, SEC_INPUTSTAT,  13,    9999,  0, 0 },
    { INFO_IN_ACFREQ1,      "Input Frequency 1",        10, SEC_INPUTSTAT,   3,     999,  0, 0 },
    { INFO_IN_ACFREQ2,      "Input Frequency 2",        10, SEC_INPUTSTAT,   7,     999,  0, 0 },
    { INFO_IN_ACFREQ3,      "Input Frequency 3",        10, SEC_INPUTSTAT,  11,     999,  0, 0 },
    { INFO_IN_LINEBADS,     "Input Line Bads",           1, SEC_INPUTSTAT,   1,     999,  0, 0 },
    { INFO_IN_NLINES,       "Input Num Lines",           1, SEC_INPUTSTAT,   2,       9,  0, 0 },
    { INFO_IN_PWR1,         "Input Power 1",             1, SEC_INPUTSTAT,   6,   99999,  0, 0 },
    { INFO_IN_PWR2,         "Input Power 2",             1, SEC_INPUTSTAT,  10,   99999,  0, 0 },
    { INFO_IN_PWR3,         "Input Power 3",             1, SEC_INPUTSTAT,  14,   99999,  0, 0 },
    { INFO_IN_VOLT1,        "Input Voltage 1",          10, SEC_INPUTSTAT,   4,    9999,  0, 0 },
    { INFO_IN_VOLT2,        "Input Voltage 2",          10, SEC_INPUTSTAT,   8,    9999,  0, 0 },
    { INFO_IN_VOLT3,        "Input Voltage 3",          10, SEC_INPUTSTAT,  12,    9999,  0, 0 },
    { INFO_LOWXFER,         "Low Volt Xfer Pt",          1, SEC_NOMINAL,     9,     999,  0, FLAG_STRING | FLAG_RW },
    { INFO_MFR,             "Manufacturer",              1, SEC_MFR,         1,      32,  0, FLAG_STRING },
    { INFO_MODEL,           "Model",                     1, SEC_MOD,         1,      64,  0, FLAG_STRING },
    { INFO_NOM_BATTLIFE,    "Nominal Battery Life",      1, SEC_NOMINAL,    12,   99999,  0, FLAG_STRING | FLAG_RW },
    { INFO_NOM_IN_FREQ,     "Nominal Input Frequency",  10, SEC_NOMINAL,     2,     999,  0, FLAG_RW },
    { INFO_NOM_IN_VOLT,     "Nominal Input Voltage",     1, SEC_NOMINAL,     1,     999,  0, FLAG_STRING | FLAG_RW },
    { INFO_NOM_LOBATTIME,   "Nominal Low Battery Time",  1, SEC_NOMINAL,     7,      99,  0, FLAG_STRING | FLAG_RW },
    { INFO_NOM_OUT_FREQ,    "Nominal Output Frequency", 10, SEC_NOMINAL,     4,     999,  0, FLAG_RW },
    { INFO_NOM_OUT_PWR,     "Nominal Output Power",      1, SEC_NOMINAL,     6,   99999,  0, FLAG_STRING | FLAG_RW },
    { INFO_NOM_OUT_VOLT,    "Nominal Output Voltage",    1, SEC_NOMINAL,     3,     999,  0, FLAG_STRING | FLAG_RW },
    { INFO_NOM_VA_RATE,     "Nominal VA Rating",         1, SEC_NOMINAL,     5,   99999,  0, FLAG_STRING | FLAG_RW },
    { INFO_OUT_CURRENT1,    "Output Current 1",         10, SEC_OUTPUTSTAT,  5,    9999,  0, 0 },
    { INFO_OUT_CURRENT2,    "Output Current 2",         10, SEC_OUTPUTSTAT,  9,    9999,  0, 0 },
    { INFO_OUT_CURRENT3,    "Output Current 3",         10, SEC_OUTPUTSTAT, 13,    9999,  0, 0 },
    { INFO_OUT_FREQ,        "Output Frequency",         10, SEC_OUTPUTSTAT,  2,     999,  0, 0 },
    { INFO_OUT_LOADPCT1,    "Output Load 1",             1, SEC_OUTPUTSTAT,  7,     999,  0, 0 },
    { INFO_OUT_LOADPCT2,    "Output Load 2",             1, SEC_OUTPUTSTAT, 11,     999,  0, 0 },
    { INFO_OUT_LOADPCT3,    "Output Load 3",             1, SEC_OUTPUTSTAT, 15,     999,  0, 0 },
    { INFO_OUT_NLINES,      "Output Num Lines",          1, SEC_OUTPUTSTAT,  3,       9,  0, 0 },
    { INFO_OUT_LOADPWR1,    "Output Power 1",            1, SEC_OUTPUTSTAT,  6,   99999,  0, 0 },
    { INFO_OUT_LOADPWR2,    "Output Power 2",            1, SEC_OUTPUTSTAT, 10,   99999,  0, 0 },
    { INFO_OUT_LOADPWR3,    "Output Power 3",            1, SEC_OUTPUTSTAT, 14,   99999,  0, 0 },
    { INFO_OUT_SOURCE,      "Output Source",             1, SEC_OUTPUTSTAT,  1,       6, 46, FLAG_ENUM },
    { INFO_OUT_VOLT1,       "Output Voltage 1",         10, SEC_OUTPUTSTAT,  4,    9999,  0, 0 },
    { INFO_OUT_VOLT2,       "Output Voltage 2",         10, SEC_OUTPUTSTAT,  8,    9999,  0, 0 },
    { INFO_OUT_VOLT3,       "Output Voltage 3",         10, SEC_OUTPUTSTAT, 12,    9999,  0, 0 },
    { INFO_RBTWDUR,         "Reboot With Duration",      1, SEC_REBOOT,      1, 9999999,  0, FLAG_WONLY },
    { INFO_SECSONBATT,      "Seconds on Battery",        1, SEC_BATTSTAT,    4,   99999,  0, 0 },
    { INFO_SHUTTYPE,        "Shutdown Type",             1, SEC_SHUTTYPE,    1,       2, 51, FLAG_ENUM | FLAG_RW },
    { INFO_DELAYSHUT,       "Shutdown After Delay",      1, SEC_STARTDELAY,  1, 9999999,  0, FLAG_WONLY },
    { INFO_FIRMREV,         "Software Version",          1, SEC_VERSION,     1,      32,  0, FLAG_STRING },
    { INFO_WAKEDELAY,       "Startup After Delay",       1, SEC_STARTDELAY,  1, 9999999,  0, FLAG_WONLY },
    { INFO_SLFTSTDETAIL,    "Test Results Detail",       1, SEC_TESTRESULT,  2,      64,  0, FLAG_STRING },
    { INFO_SLFTSTSUM,       "Test Results Summary",      1, SEC_TESTRESULT,  1,       6, 54, FLAG_ENUM },
    { INFO_SLFTSTTYPE,      "Test Type",                 1, SEC_TEST,        1,       5, 61, FLAG_ENUM | FLAG_WONLY },
    { INFO_BAUDRATE,        "Baud Rate",                 1, SEC_BAUDRATE,    1,   19200,  0, FLAG_RW },
};


/*
 * List of possible enumerations
 */

struct sec_enumdata_t {
    int type;		/* INFO_x type */
    int index;		/* ups value */
    const char *value;	/* enumerated value */
} sec_enumdata[] = {
    { INFO_ALRM_PWRWAIT,	0, "Not Awaiting Power" },
    { INFO_ALRM_PWRWAIT,	1, "Awaiting Power" },
    { INFO_ALRM_BADBYPASS,	0, "Bypass OK" },
    { INFO_ALRM_BADBYPASS,	1, "Bypass Fault" },
    { INFO_ALRM_CHARGFAIL,	0, "Charger OK" },
    { INFO_ALRM_CHARGFAIL,	1, "Charger Fault" },
    { INFO_ALRM_FANFAIL,	0, "Fan OK" },
    { INFO_ALRM_FANFAIL,	1, "Fan Fault" },
    { INFO_ALRM_FUSEFAIL,	0, "Fuse OK" },
    { INFO_ALRM_FUSEFAIL,	1, "Fuse Fault" },
    { INFO_ALRM_GENERAL,	0, "General system OK" },
    { INFO_ALRM_GENERAL,	1, "General system Fault" },
    { INFO_ALRM_BADINPUT,	0, "Input OK" },
    { INFO_ALRM_BADINPUT,	1, "Input Fault" },
    { INFO_ALRM_BADOUTPUT,	0, "Output OK" },
    { INFO_ALRM_BADOUTPUT,	1, "Output Fault" },
    { INFO_ALRM_OUTPUTOFF,	0, "Output On" },
    { INFO_ALRM_OUTPUTOFF,	1, "Output off" },
    { INFO_ALRM_OVERLOAD,	0, "UPS not overloaded" },
    { INFO_ALRM_OVERLOAD,	1, "UPS Overloaded" },
    { INFO_ALRM_IMMSHUT,	0, "No Shutdown Imminent" },
    { INFO_ALRM_IMMSHUT,	1, "Shutdown Imminent" },
    { INFO_ALRM_PENDSHUT,	0, "No Shutdown Pending" },
    { INFO_ALRM_PENDSHUT,	1, "Shutdown Pending" },
    { INFO_ALRM_SYSOFF,		0, "System On" },
    { INFO_ALRM_SYSOFF,		1, "System off" },
    { INFO_ALRM_TEMP,		0, "Temperature OK" },
    { INFO_ALRM_TEMP,		1, "Over Temperature" },
    { INFO_ALRM_UPSSHUT,	0, "UPS not Shutdown" },
    { INFO_ALRM_UPSSHUT,	1, "UPS Shutdown" },
    { INFO_AUDIBLEALRM,		1, "Disabled" },
    { INFO_AUDIBLEALRM,		2, "Enabled" },
    { INFO_AUDIBLEALRM,		3, "Muted" },
    { INFO_AUDIBLEALRM,		4, "Disabled Until Low Battery warning" },
    { INFO_AUTORESTART,		1, "Automatic Restart" },
    { INFO_AUTORESTART,		2, "Manual Restart" },
    { INFO_BATT_CHARGE,		0, "Floating" },
    { INFO_BATT_CHARGE,		1, "Charging" },
    { INFO_BATT_CHARGE,		2, "Resting" },
    { INFO_BATT_CHARGE,		3, "Discharging" },
    { INFO_BATT_COND,		0, "Good" },
    { INFO_BATT_COND,		1, "Weak" },
    { INFO_BATT_COND,		2, "Replace" },
    { INFO_BATT_STATUS,		0, "Battery OK" },
    { INFO_BATT_STATUS,		1, "Battery Low" },
    { INFO_BATT_STATUS,		2, "Battery Depleted" },
    { INFO_OUT_SOURCE,		0, "Normal" },
    { INFO_OUT_SOURCE,		1, "On Battery" },
    { INFO_OUT_SOURCE,		2, "On Bypass" },
    { INFO_OUT_SOURCE,		3, "Reducing" },
    { INFO_OUT_SOURCE,		4, "Boosting" },
    { INFO_OUT_SOURCE,		5, "Other" },
    { INFO_SHUTTYPE,		1, "UPS output only" },
    { INFO_SHUTTYPE,		2, "Entire UPS" },
    { INFO_SLFTSTSUM,		0, "No test performed" },
    { INFO_SLFTSTSUM,		1, "Test Passed" },
    { INFO_SLFTSTSUM,		2, "Test in progress" },
    { INFO_SLFTSTSUM,		3, "General Test failed" },
    { INFO_SLFTSTSUM,		4, "Battery Test failed" },
    { INFO_SLFTSTSUM,		5, "Deep Battery Test failed" },
    { INFO_SLFTSTTYPE,		-1, "Abort test in progress" },
    { INFO_SLFTSTTYPE,		0, "No test" },
    { INFO_SLFTSTTYPE,		1, "General Systems Test" },
    { INFO_SLFTSTTYPE,		2, "Quick Battery Test" },
    { INFO_SLFTSTTYPE,		3, "Deep Battery Calibration" },
};


/* a type for the supported variables */
#define SEC_QUERYLIST_LEN	17
#define SEC_MAXFIELDS		16

struct sec_querylist_t {
    char *command;	/* sec command */
    int  varnum[SEC_MAXFIELDS];	/* sec variable number for each field */
} sec_querylist[SEC_QUERYLIST_LEN];

#define sqv(a,b) sec_querylist[a].varnum[b]
