/*
	BCM/XCP protocol driver. (tested with a Powerware 9120 UPS)
	This is guesswork. Maybe I am wrong here and there. Maybe
	it works with other Powerware upses...
	
	This is a 'passive' driver. You can't send any commands 
	like shutdown, battery test etc. to the ups.
	
	It compiles and runs on a Solaris/x86 platform. It should 
	be easy to get it up and running on the Linux/x86 platform.
	
	As all binary values read from the ups are little endian, you
	have to insert code on big endian platforms to swap these.
	
	Hints are welcome.
*/
/*
 * Copyright (c) 2002, Martin Schroeder
 * emes -at- geomer.de
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Martin Schroeder nor the names of his contributors 
 *    may be used to endorse or promote products derived from this software 
 *    without specific prior written permission. 
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */    

#include <sys/time.h>
#include <sys/ioctl.h>
#include <string.h>

#include "main.h"
#include "bcmxcp.h"


extern int nut_debug_level;
int pw_upsfd;
int firstrun;



int pw_wait(){
 fd_set  readfds;
 struct  timeval tv;
   
 	FD_ZERO(&readfds);
        FD_SET(pw_upsfd, &readfds);
        tv.tv_sec = 0;
        tv.tv_usec = 100000;
                                    
        return select(pw_upsfd+1, &readfds, NULL, NULL, &tv);
}       

int pw_checksum_test(char *buf){
unsigned char c;
int i;	
	
	c = 0;
	for(i = 0; i < 5 + buf[2]; i++)
		c -= buf[i];

	return c == 0;
}

unsigned char pw_calc_checksum(char *buf){
 unsigned char c;
 int i;

	c = 0;
	for(i = 0; i < 2 + buf[1]; i++)
		c -= buf[i];
	
	return c;
}

int pw_send_command(char command){
int  retval, i;
int  clen = 0;
char cbuf[4];

	cbuf[0] = PW_COMMAND_START_BYTE;
	cbuf[1] = 1; 		/* For now there is only       */
				/* support for 1 byte commands */
	cbuf[2] = command;
	cbuf[3] = pw_calc_checksum(cbuf);
	

	clen      = 2 + cbuf[1];	
	retval = write(pw_upsfd, cbuf, clen + 1);
	
	if(retval != (clen + 1)){
		upslogx(LOG_INFO, "pw_send_command: send failure\n");
		exit(-1);
	}

	if(nut_debug_level > 4){
		printf("pw_send_command: dump data\n"); 
		for(i = 0; i <= clen; i++)
			printf("%02X ", cbuf[i] & 0xFF);	
		
		printf("\n");
	}
	return retval == (clen + 1);
}

int pw_getdata(char *buf){
 int   bytes_read, r;

	bytes_read = 0;
	while(pw_wait() > 0){
		r = read(pw_upsfd, buf + bytes_read, 1024 - bytes_read);
		if(r > 0)
			bytes_read += r;	
	}
	
	if(nut_debug_level > 3){
		printf("pw_getdata: %d bytes read\n", bytes_read);
	
	}
	
	if(!bytes_read){
		upslogx(LOG_ERR, "pw_getdata: read error\n");
		return -1;
					
	}else if(!pw_checksum_test(buf)){
		upslogx(LOG_ERR, "pw_getdata: checksum error\n");
		return -2;
	} 
	return bytes_read;	/* OK */
}

int pw_queryups(char *buf, char command){
int i, ret;

	ret = 0;
	for(i = 0; i < PW_MAX_TRY; i++){	/* Try MAX_TRY times in case of a read error */
		pw_send_command(command);
		if((ret = pw_getdata(buf)) > 0)
			break;
	}	
	
	if(ret <= 0){
		upslogx(LOG_ERR, "pw_queryups: Can't get valid data from the ups.\n");
		exit(-1);
	}
			
	return ret;
}

int pw_open_serial(const char *device, int baud){
 int i;
 int mybaud;
 struct termios term; 

	mybaud = 0;
	for(i = 0; i < PW_MAX_BAUD; i++)
		if(baud == pw_baud_rates[i].name){
			mybaud = pw_baud_rates[i].rate;
			break;
		}
	if( i == PW_MAX_BAUD){
		upslogx(LOG_ERR, "pw_open_serial: %d not a legal baud rate\n", baud);
		exit(-1);
	}
			
	if ((pw_upsfd = open(device, O_RDWR|O_NONBLOCK|O_EXCL|O_NOCTTY, 0777)) < 0) {
		upslogx(LOG_ERR, "couldn't open device: %s\n", device);
		exit(-1);
	}

	if (tcgetattr(pw_upsfd, &term) < 0) {
		upslogx(LOG_ERR, 
			"pw_open_serial: Can't read attributes from %s\n", device);
		exit(-1);
	}

	/*
	 * Set canonical mode and local connection; set specified speed,
	 * 8 bits and no parity; map CR to NL; ignore break.
	 */

	memset(term.c_cc, 0, 16);
	term.c_cc[VEOF] = 1;

	term.c_iflag = IGNBRK | IGNPAR ;
	term.c_oflag = 0;


	term.c_cflag = CS8 | mybaud | CLOCAL | CREAD;
	term.c_lflag = IEXTEN;

	if (tcsetattr(pw_upsfd, TCSAFLUSH, &term) < 0) {
		upslogx(LOG_ERR, 
			"pw_open_serial: Can't write attributes to %s \n", device);
		exit(-1);
	}
	return pw_upsfd;
}

void upsdrv_initinfo(void)
{
	dstate_setinfo("ups.mfr", "Powerware");
	dstate_setinfo("input.transfer.low", "187");
	dstate_setinfo("input.transfer.high", "264");
}

void upsdrv_updateinfo(void)
{
 char buf[1024];		/* This should be enough */
 
 /* User settings */
 int IPFreqBypass, IPFreqBypassThresh, IPVoltBypassMin, IPVoltBypassMax;
 int OPVoltStandard;
 
 /* current values */
 int OPWatt, OPVA, OPVolt, IPVolt;
 int BackupTimeLeft, BattCharge, maxVA; 
 float OPFreq, OPCurr, IPFreq, BattVolt;
 unsigned char UPSStat, ABMStat; 
 
 char *fstr;
 

	if(firstrun){	/* Read the system info only once */
		pw_queryups(buf, PW_SYSTEM_INFO1);
		dstate_setinfo("ups.model", "%s", &buf[15]);
		
		if(nut_debug_level > 2)
			printf("Modelname: %s\n", &buf[15]);

		pw_queryups(buf, PW_SYSTEM_INFO2);
		dstate_setinfo("ups.serial", "%.16s", &buf[68]);
		dstate_setinfo("battery.packs", "%d",
			*((unsigned short *) &(buf[30])));
		

		if(nut_debug_level > 2){
			printf("Serial no.: %.16s\n",  &buf[52]);
			printf("Part no.: %.16s\n",  &buf[68]);
			printf("External battery cabinets: %hd\n", *((unsigned short *) &(buf[30]))); 
		}
		firstrun = 0;
	}
	
	pw_queryups(buf, PW_SYSTEM_SETTINGS);

	OPVoltStandard 	= *((unsigned short *) &(buf[4]));
	IPFreqBypass    = *((unsigned short *) &(buf[6]));
	IPFreqBypassThresh = *((unsigned short *) &(buf[12]));
	IPVoltBypassMin = *((unsigned short *) &(buf[14]));
	IPVoltBypassMax = *((unsigned short *) &(buf[16]));

	if(IPFreqBypassThresh == 100)
		fstr = FreqTol[0];
	else if(IPFreqBypassThresh == 250)
		fstr = FreqTol[1];
	else if(IPFreqBypassThresh == 350)
		fstr = FreqTol[2];
	else
		fstr = "unknown";

	if(nut_debug_level > 2){
		printf("\n\n--\n");
		printf("OP voltage standard: %d\n", OPVoltStandard);
		printf("IP frequency bypass: %d %s", IPFreqBypass, fstr);
	
		printf("IP voltage bypass min: ");
		printf("%dV (-%d%%)\n", IPVoltBypassMin,
			(int) ((OPVoltStandard - IPVoltBypassMin) * 100 / 
			IPVoltBypassMin));			
		printf("IP voltage bypass max: ");
		printf("%dV (+%d%%)\n", IPVoltBypassMax,
			(int) ((IPVoltBypassMax - OPVoltStandard) * 100 / 
			IPVoltBypassMin));			

	}

	dstate_setinfo("output.voltage.target.battery", "%d", OPVoltStandard);
	
	/* FIXME: not mapped yet
	setinfo(INFO_BYPASS_FREQ, "%d %s", IPFreqBypass, fstr);   
	*/

	dstate_setinfo("input.transfer.low", "%d", IPVoltBypassMin);
	dstate_setinfo("input.transfer.high", "%d", IPVoltBypassMax);

	pw_queryups(buf, PW_SYSTEM_STATUS);

	OPWatt		= *((int *)  (&buf[4]));
	OPVA		= *((int *)  (&buf[8]));
	OPFreq		= *((float *)(&buf[12]));
	IPFreq		= *((float *)(&buf[16]));
	BattVolt	= *((float *)(&buf[20]));
	BattCharge	= *((int *)  (&buf[24]));
	BackupTimeLeft	= *((int *)  (&buf[28]));
	IPVolt		= *((int *)  (&buf[32]));
	OPCurr		= *((float *)(&buf[40]));
	maxVA		= *((int *)  (&buf[48]));
	OPVolt		= *((int *)  (&buf[52]));
	
	 	
	if(nut_debug_level > 2){
		printf("IP voltage:   %d\n", IPVolt);
		printf("IP frequency: %.1f\n", IPFreq);
		printf("OP voltage:   %d\n", OPVolt);
		printf("OP current:   %.1f\n", OPCurr);
		printf("OP frequency: %.1f\n", OPFreq);
		printf("OP VA:        %d\n", OPVA);
		printf("OP watt:      %d\n", OPWatt);
		printf("OP load:      %.1f%%\n", ((float)OPVA / maxVA) * 100);
		printf("Maximum VA:   %d\n", maxVA);
		printf("Battery charge:   %d%%\n", BattCharge);
		printf("Battery voltage:  %.1f\n", BattVolt);
		printf("Backup time left: %d min\n", (int)BackupTimeLeft/60);		
	}	
	dstate_setinfo("input.voltage", "%d", IPVolt);
	dstate_setinfo("output.voltage", "%d", OPVolt);
	dstate_setinfo("output.current", "%.1f", OPCurr);
	dstate_setinfo("output.frequency", "%.1f", OPFreq);
	dstate_setinfo("input.frequency", "%.1f", IPFreq);
	dstate_setinfo("battery.voltage", "%.1f", BattVolt);
	dstate_setinfo("battery.charge", "%d", BattCharge);
	dstate_setinfo("battery.runtime", "%d", (int)BackupTimeLeft);
	dstate_setinfo("ups.load", "%.1f",  ((float)OPVA / maxVA) * 100);
	
	pw_queryups(buf,  PW_SYSTEM_MODE);
		
	UPSStat = buf[4];
	switch(UPSStat){
		case 0x60:
			fstr = "BYPASS"; /* On Bypass  */
			break;
		case 0x50:
			fstr = "OL";  /* On Line    */
			break;
		case 0xf0:
			fstr = "OB";  /* On Battery */
			break;
		default:
			fstr = "LB"; /* Don't now the real value for LB... */
		}

	if(nut_debug_level > 2)
		printf("UPS: %s\n", fstr);

	/* FIXME: this should be using status_set */
	dstate_setinfo("ups.status", "%s", fstr);	
	
	pw_queryups(buf, PW_ABM_STATUS);
	
	ABMStat = buf[24];
	switch(ABMStat){
		case 0x1:
			fstr = ABMStatus[0]; /* Charging    */
			break;
		case 0x2:
			fstr = ABMStatus[1]; /* Discharging */
			break;
		case 0x3:
			fstr = ABMStatus[2]; /* Floating    */
			break;
		case 0x4:
			fstr = ABMStatus[3]; /* Resting     */
			break;
		default:
			fstr = "Unknown";
	}
	
	if(nut_debug_level > 2)
		printf("ABM: %s\n", fstr);

	/* FIXME: not mapped 
	setinfo(INFO_BATT_STATUS, "%s", fstr);
	*/
}

void upsdrv_shutdown(void)
{
	/* replace with a proper shutdown function */
	fatalx("shutdown not supported");
}


void instcmd (int auxcmd, int dlen, char *data)
{
	/* TODO: reply to upsd? */
	switch (auxcmd) {
		/* stop battery test */
		/* case CMD_BTEST0:	
		 *	upssend("???");
		 *	break;
		 */
		 /* start battery test */
		 /* case CMD_BTEST1:	
		 *	upssend("???");
		 *	break;
		 */
		default:
			upslogx(LOG_ERR, "instcmd: unknown type 0x%04x\n", auxcmd);
	}
}


void upsdrv_help(void)
{
}

/* list flags and values that you want to receive via -x */
void upsdrv_makevartable(void)
{
	/* allow '-x xyzzy' */
	/* addvar(VAR_FLAG, "xyzzy", "Enable xyzzy mode"); */

	/* allow '-x foo=<some value>' */
	/* addvar(VAR_VALUE, "foo", "Override foo setting"); */
}

void upsdrv_banner(void)
{
	printf("Network UPS Tools - Powerware XCP/BCM protocol driver 0.02 (%s)\n\n", UPS_VERSION);
}

void upsdrv_initups(void)
{
	/* this driver doesn't do sanity checks in upsdrv_updateinfo */
	broken_driver = 1;
	return;

	pw_open_serial(device_path, 9600); 
	firstrun = 1;
	/* to get variables and flags from the command line, use this:
	 *
	 * first populate with upsdrv_buildvartable above, then...
	 *
	 *                   set flag foo : /bin/driver -x foo
	 * set variable 'cable' to '1234' : /bin/driver -x cable=1234
	 *
	 * to test flag foo in your code:
	 *
	 * 	if (testvar("foo"))
	 * 		do_something();
	 *
	 * to show the value of cable:
	 *
	 *      if ((cable == getval("cable")))
	 *		printf("cable is set to %s\n", getval("cable"));
	 *	else
	 *		printf("cable is not set!\n");
	 *
	 * don't use NULL pointers - test the return result first!
	 */

	/* the upsh handlers can't be done here, as they get initialized
	 * shortly after upsdrv_initups returns to main.
	 */
}

void upsdrv_cleanup(void)
{
}
