/* db.h */

/*
    NUT nutrition software 
    Copyright (C) 1996-2009 by Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef DB_H
#define DB_H

#define MAJVERSION 14
#define MINVERSION 4
#define VERSIONQ "14.4"

#include <stdio.h>
#include "food.h"

extern char subuser[];

void read_food_files(void);
void read_joined_db(char *);
void read_FOOD(char *);
void read_NUT(char *);
void read_WEIGHT(char *);
void read_weightlib(int, char *, int, char **, int *);
void write_food_db(void);
int read_food_db(void);
void read_meal_db(void);
void read_theusual_db(void);
void write_meal_db(void);
void write_theusual_db(void);
void write_OPTIONS(void);
void write_recipe(struct food *);
void write_serving(struct food *);
void read_options_db(int);
void read_OPTIONS(int);
void make_filenames(char *);
int version(int);
void write_version(void);
void check_version_file(void);

#endif
