/*
 ** Copyright 2004-2007 - INL
 ** Written by Eric Leblond <eric.leblond@inl.fr>
 **            Vincent Deffontaines <vincent@inl.fr>
 ** INL http://www.inl.fr/
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <QtGui>

#include "preferences.h"
#include "preferences.moc"
#include "editbox.h"

/*
 * See http://doc.trolltech.com/4.3/mainwindows-application.html
 */

NuAppPreferences::NuAppPreferences() : QDialog(NULL, Qt::Dialog)
{
	createDialog();
	resize(10, 10);
}

void NuAppPreferences::createDialog()
{
	// GUI stuffs
	// Username
	QLabel *hostnameLabel = new QLabel( tr("Hostname"));
	hostname = new NuEditBox();
	hostname->setFocus();
	connect(hostname, SIGNAL(returnPressed()), this, SLOT(save_preferences()));
	connect(hostname, SIGNAL(escapePressed()), this, SLOT(reject()));

	// Password
	QLabel *portLabel  = new QLabel( tr("Port"));
	port = new NuEditBox();
	connect(port, SIGNAL(returnPressed()), this, SLOT(save_preferences()));
	connect(port, SIGNAL(escapePressed()), this, SLOT(reject()));

	QVBoxLayout *host_layout = new QVBoxLayout;
	host_layout->addWidget(hostnameLabel);
	host_layout->addWidget(hostname);
	host_layout->addWidget(portLabel);
	host_layout->addWidget(port);

	QGroupBox *host_gb = new QGroupBox(tr("Authentication server"));
	host_gb->setLayout(host_layout);


	// Certificates
	QVBoxLayout *cert_layout = new QVBoxLayout;

	use_certs = new QCheckBox( tr("Use certificates"));
	cert_layout->addWidget(use_certs);

	current_key = new QLabel(tr("Current key:"));
	key_open = new QPushButton(tr("Select key..."));
	current_cert = new QLabel(tr("Current certificate:"));
	cert_open = new QPushButton(tr("Select certificate..."));
	current_ca = new QLabel(tr("Current CA certificate:"));
	ca_open = new QPushButton(tr("Select CA certificate..."));
	cert_layout->addWidget(current_key);
	cert_layout->addWidget(key_open);
	cert_layout->addWidget(current_cert);
	cert_layout->addWidget(cert_open);
	cert_layout->addWidget(current_ca);
	cert_layout->addWidget(ca_open);

	QGroupBox *cert_gb = new QGroupBox(tr("Certificate authentication"));
	cert_gb->setLayout(cert_layout);

	QDialogButtonBox *buttonBox = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel, Qt::Horizontal);
	QVBoxLayout *top_layout = new QVBoxLayout(this);
	top_layout->addWidget(host_gb);
	top_layout->addWidget(cert_gb);
	top_layout->addWidget(buttonBox);

	// Set signals
	connect(use_certs, SIGNAL(stateChanged(int)), this, SLOT(switch_use_certs(int)));
	connect(key_open, SIGNAL(pressed()), this, SLOT(popup_open_key()));
	connect(cert_open, SIGNAL(pressed()), this, SLOT(popup_open_cert()));
	connect(ca_open, SIGNAL(pressed()), this, SLOT(popup_open_ca()));

	connect(buttonBox, SIGNAL(accepted()), this, SLOT(save_preferences()));
	connect(buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

	QIcon icon = QIcon(":/images/nuapplet2-running.png");
	setWindowIcon(icon);
	setWindowTitle(tr("Preferences"));
}

void NuAppPreferences::setCertificateButtons()
{
	if(settings.value("use_certificate").toBool())
	{
		use_certs->setCheckState(Qt::Checked);
		key_open->setEnabled(true);
		current_key->setEnabled(true);
		cert_open->setEnabled(true);
		current_cert->setEnabled(true);
		ca_open->setEnabled(true);
		current_ca->setEnabled(true);
	}
	else
	{
		use_certs->setCheckState(Qt::Unchecked);
		key_open->setEnabled(false);
		current_key->setEnabled(false);
		cert_open->setEnabled(false);
		current_cert->setEnabled(false);
		ca_open->setEnabled(false);
		current_ca->setEnabled(false);
	}

	if(settings.value("key").toString() == "" )
		current_key->setText(tr("Current key:") + tr("None"));
	else
		current_key->setText(tr("Current key:") + settings.value("key").toString() );

	if(settings.value("cert").toString() == "" )
		current_cert->setText(tr("Current certificate:") + tr("None"));
	else
		current_cert->setText(tr("Current certificate:") + settings.value("cert").toString() );

	if(settings.value("ca").toString() == "" )
		current_ca->setText(tr("Current CA certificate:") + tr("None"));
	else
		current_ca->setText(tr("Current CA certificate:") + settings.value("ca").toString() );

}

void NuAppPreferences::show()
{
	load_preferences();
	setCertificateButtons();
	QDialog::show();
}

void NuAppPreferences::load_preferences()
{
	settings.sync();
	hostname->setText(settings.value("hostname").toString());
	port->setText(settings.value("port").toString());
	settings.sync();
}

void NuAppPreferences::switch_use_certs(int state)
{
	if(state == Qt::Checked)
		settings.setValue("use_certificate", true);
	else
		settings.setValue("use_certificate", false);
	setCertificateButtons();
}

void NuAppPreferences::save_preferences()
{	
	settings.setValue("hostname", hostname->text());
	settings.setValue("port", port->text());
	settings.sync();
	accept();
}

void NuAppPreferences::popup_open_key()
{
	QString fileName = QFileDialog::getOpenFileName(this, tr("Select key"),
						QDir::homePath(),
						tr("Key (*.key *.pem);;All Files (*)"));
	settings.setValue("key", fileName);
	setCertificateButtons();
}

void NuAppPreferences::popup_open_cert()
{
	QString fileName = QFileDialog::getOpenFileName(this, tr("Select certificate"),
						QDir::homePath(),
						tr("Key (*.crt *.pem);;All Files (*)"));
	settings.setValue("cert", fileName);
	setCertificateButtons();
}

void NuAppPreferences::popup_open_ca()
{
	QString fileName = QFileDialog::getOpenFileName(this, tr("Select CA certificate"),
						QDir::homePath(),
						tr("Key (*.crt *.pem);;All Files (*)"));
	settings.setValue("ca", fileName);
	setCertificateButtons();
}

