#!/bin/sh

DEB_UPSTREAM_VERSION=$1
DEB_SOURCE_VERSION=$2

uscan --noconf --force-download --rename --download-current-version --destdir=.
rm -rf ntop-$DEB_UPSTREAM_VERSION
rm -rf ntop-$DEB_SOURCE_VERSION
tar zxf ntop_$DEB_UPSTREAM_VERSION.orig.tar.gz
rm ntop_$DEB_UPSTREAM_VERSION.orig.tar.gz
# remove files not DFSG-compliant
rm ntop-$DEB_UPSTREAM_VERSION/ntop_darwin.*
rm ntop-$DEB_UPSTREAM_VERSION/ntop_win32.*
rm ntop-$DEB_UPSTREAM_VERSION/packages/Win32/ntop-VC6-project.zip

# remove binary-onyl files from MaxMind
rm ntop-$DEB_UPSTREAM_VERSION/3rd_party/Geo*.dat.gz

# remove non-DFSG-compliant part of ntop.h
ed ntop-$DEB_UPSTREAM_VERSION/ntop.h > /dev/null <<EOF
/Declaration of POSIX directory browsing functions and types for Win32.
?/\* \** \*/?,/\/\* \** \*\//d
wq
EOF

mv ntop-$DEB_UPSTREAM_VERSION ntop-$DEB_SOURCE_VERSION

GZIP=--best tar -cz --owner root --group root --mode a+rX \
    -f ntop_$DEB_SOURCE_VERSION.orig.tar.gz ntop-$DEB_SOURCE_VERSION

mv ntop_$DEB_SOURCE_VERSION.orig.tar.gz ..

rm -fr ntop-$DEB_SOURCE_VERSION
