/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#ifndef STAFF_CONTEXT_DIALOG_H

#define STAFF_CONTEXT_DIALOG_H
#include "config.h"
#include <gtk/gtk.h>
#include <cairo.h>

#define DELETE_STAFF_CMD 12
#define DELETE_SYSTEM_CMD 13

class NedMainWindow;


class NedStaffContextDialog {
	public:
		NedStaffContextDialog(GtkWindow *parent,  NedMainWindow *main_window, bool allow_delete_system, int staff_count, int staff_pos, char *staff_name, char *staffshortname, int clef_number, int octave_shift, int key_signature_number, int numerator, int demoninator, int volume, int midi_program, int channel, int tempo, int pan, int chorus, int play_transposed, int reverb, bool muted);
		void getValues(bool *state, bool *delete_staff, bool *delete_system, int *staff_pos, char **staff_name, char **staff_short_name, int *clef_number, int *octave_shift, int *key_signature_number, bool *ajdust_notes, int *numerator, int *demoninator, int *volume, int *midi_program, int *channel, int *tempo, int *pan, int *chorus, int *play_transposed, int *reverb, bool *config_changed, bool *muted);
	private:
		static void OnClose(GtkDialog *dialog, gint result, gpointer data);
		static gboolean OnScroll(GtkWidget *widget, GdkEventScroll *event, gpointer data);
		static gboolean draw_clefs(GtkWidget *widget,
			 GdkEventExpose *event, gpointer data);
		static void decrease_clef_number (GtkButton *button, gpointer user_data);
		static void increase_clef_number (GtkButton *button, gpointer user_data);
		static void octave_shift_change(GtkSpinButton *spinbutton, gpointer user_data);
		GtkWidget *m_clef_show_window;
		static char *m_keyTab[];
		GtkWidget *m_sig_radio_buttons[14];
		GtkWidget *m_denominator;
		GtkWidget *m_numerator;
		GtkWidget *m_clef_bu_up;
		GtkWidget *m_clef_bu_down;
		GtkWidget *m_instrument_list;
		GtkWidget *m_volume_scale;
		GtkWidget *m_tempo_scale;
		GtkWidget *m_pan_scale;
		GtkWidget *m_chorus_scale;
		GtkWidget *m_play_transposed_scale;
		GtkWidget *m_reverb_scale;
		GtkWidget *m_channel_spin_box;
		GtkWidget *m_mute_box;
		GtkWidget *m_octave_shift_spin_box;
		GtkWidget *m_adjust_check_box;
		GtkWidget *m_position_list;
		GtkWidget *m_staffname;
		GtkWidget *m_staffshortname;
		GtkWidget *m_table;
		GtkObject *m_instrument_adjustment;
		int m_octave_shift;
		int m_tempo;
		int m_pan;
		int m_chorus;
		int m_play_transposed;
		int m_reverb;
		int m_volume;
		int m_channel_value;
		bool m_state;
		int m_numerator_value;
		int m_denominator_value;
		int m_key_signature_number;
		int m_current_clef, m_newclef;
		bool m_do_adjust;
		int m_midi_program_number;
		bool m_config_changed;
		bool m_delete_staff;
		bool m_delete_system;
		int m_staff_pos;
		int m_staff_count;
		char *m_staff_name;
		char *m_staff_short_name;
		bool m_muted;

	friend class NedKeysigDialog;

		
};

#endif /* STAFF_CONTEXT_DIALOG_H */
