;
; NoteCase Windows setup script file (Inno Setup)
;

[Setup]
AppName=NoteCase
AppVerName=NoteCase v1.5.6
AppPublisherURL=http://notecase.sourceforge.net
AppSupportURL=http://notecase.sourceforge.net
AppUpdatesURL=http://notecase.sourceforge.net
AppCopyright=Copyright 2004-2007 by NoteCase developer team
DefaultDirName={pf}\NoteCase
DefaultGroupName=NoteCase
UninstallDisplayIcon={app}\notecase.exe
;it is possible to skip creating program group
AllowNoIcons=yes
; display this file before selection the destination
InfoBeforeFile=readme.txt
PrivilegesRequired=none

[Tasks]
;Name: menuitems; Description: "Create a start menu items"; GroupDescription: "Additional items:";
Name: desktopicon; Description: "Create a &desktop icon"; GroupDescription: "Additional items:";
Name: quicklaunchicon; Description: "Create a &Quick Launch icon"; GroupDescription: "Additional items:"; Flags: unchecked
Name: startmenuicon; Description: "Create a &start menu icon"; GroupDescription: "Additional items:"; Flags: unchecked
Name: gtkinstall; Description: "Install GTK";

[Files]
Source: "notecase.exe"; DestDir: "{app}"; Flags: promptifolder
Source: "readme.txt"; DestDir: "{app}"; Flags: isreadme
Source: "help.ncd"; DestDir: "{app}"
Source: "notecase.url"; DestDir: "{app}"
Source: "gtk-2.10.11-win32-1.exe"; Tasks: gtkinstall; DestDir: "{tmp}"; Flags: deleteafterinstall;
Source: "msvcrt.dll"; DestDir: "{sys}"; Flags: onlyifdoesntexist uninsneveruninstall
Source: "locale\*.*"; DestDir: "{app}\locale"; Flags: recursesubdirs;

[Run]
; execute gtk installer if required
Filename: "{tmp}\gtk-2.10.11-win32-1.exe";  Tasks: gtkinstall;  Flags: hidewizard skipifdoesntexist; AfterInstall: UpdateAppPath;

[Icons]
Name: "{group}\NoteCase"; Filename: "{app}\notecase.exe"; WorkingDir: "{app}";
Name: "{group}\Visit the Web Site"; Filename: "{app}\notecase.url";
Name: "{group}\Read me"; Filename: "{app}\readme.txt";
Name: "{group}\Uninstall NoteCase"; Filename: "{uninstallexe}";
Name: "{userappdata}\Microsoft\Internet Explorer\Quick Launch\NoteCase"; Filename: "{app}\notecase.exe"; Tasks: quicklaunchicon;  WorkingDir: "{app}"
Name: "{userdesktop}\NoteCase"; Filename: "{app}\notecase.exe"; Tasks: desktopicon; WorkingDir: "{app}"
Name: "{userstartmenu}\NoteCase"; Filename: "{app}\notecase.exe"; Tasks: startmenuicon; WorkingDir: "{app}"

[Registry]
; register .ncd format with notecase
Root: HKCR; Subkey: ".ncd"; ValueType: string; ValueName: ""; ValueData: "NoteCase.PlainFormat"; Flags: uninsdeletevalue
Root: HKCR; Subkey: "NoteCase.PlainFormat"; ValueType: string; ValueName: ""; ValueData: "NoteCase unencrypted file format"; Flags: uninsdeletekey
Root: HKCR; Subkey: "NoteCase.PlainFormat\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\notecase.exe,0"
Root: HKCR; Subkey: "NoteCase.PlainFormat\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\notecase.exe"" ""%1"""
; register .nce format with notecase
Root: HKCR; Subkey: ".nce"; ValueType: string; ValueName: ""; ValueData: "NoteCase.EncryptedFormat"; Flags: uninsdeletevalue
Root: HKCR; Subkey: "NoteCase.EncryptedFormat"; ValueType: string; ValueName: ""; ValueData: "NoteCase encrypted file format"; Flags: uninsdeletekey
Root: HKCR; Subkey: "NoteCase.EncryptedFormat\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\notecase.exe,0"
Root: HKCR; Subkey: "NoteCase.EncryptedFormat\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\notecase.exe"" ""%1"""
; This adds the GTK+ libraries to notecase.exe's path
Root: HKLM; Subkey: "Software\Microsoft\Windows\CurrentVersion\App Paths\notecase.exe"; Flags: uninsdeletekeyifempty
Root: HKLM; Subkey: "Software\Microsoft\Windows\CurrentVersion\App Paths\notecase.exe"; ValueType: string; ValueData: "{app}\notecase.exe"; Flags: uninsdeletevalue
; this one is a placeholder, its value is filled in UpdateAppPath();
Root: HKLM; Subkey: "Software\Microsoft\Windows\CurrentVersion\App Paths\notecase.exe"; ValueType: string; ValueName: "Path"; ValueData: ""; Flags: uninsdeletevalue


[Code]

var
  Exists: Boolean;
  GtkPath: String;

function GetGtkInstalled(): Boolean;
begin
  Exists := RegQueryStringValue (HKLM, 'Software\GTK\2.0', 'Path', GtkPath);
  if not Exists then begin
    Exists := RegQueryStringValue (HKCU, 'Software\GTK\2.0', 'Path', GtkPath);
  end;
   Result := Exists
end;

procedure UpdateAppPath();
var
 AppPath: String;
 RegValue: String;
begin
    AppPath := ExpandConstant('{app}');

    GetGtkInstalled (); //first read Gtk Path

    //create and write registry key
    RegValue := AppPath;
    RegValue := RegValue + ';';
    RegValue := RegValue + GtkPath;
    RegValue := RegValue + '\bin';
    
    //MsgBox(RegValue, mbInformation, MB_OK);
    RegWriteStringValue (HKLM, 'Software\Microsoft\Windows\CurrentVersion\App Paths\notecase.exe', 'Path', RegValue);
end;
