////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Main method implementation (application startup)
////////////////////////////////////////////////////////////////////////////

#include "mru.h"
#include <gtk/gtk.h>
#include <libintl.h>

#include "interface.h"
#include "callbacks.h"
#include "support.h"
#include "lib/IniFile.h"
#include "lib/FilePath.h"
#include "lib/NoteDocument.h"
#include "gui/GuiLanguage.h"
#include "MainWnd.h"

#ifdef _WIN32
 #include "_win/SingleInstance.h"
 CSingleInstance g_instance("NoteCase");
#else
 #include "_unx/SingleInstance.h"
 CSingleInstance g_instance("/NoteCase");
#endif

GtkWidget *window1;
extern MRU g_objMRU;
bool g_bMinimizeToTray = false;
extern MainWindow g_wnd;

int  load_file(const char *filename);
int gtkMessageBox(const char *szText, int nButtons = GTK_BUTTONS_OK, int nIcon = GTK_MESSAGE_INFO);

const char *get_locale_dir()
{
	static std::string strDir;
#ifdef _WIN32
	strDir  = GetAppPath();
	strDir  = GetParentDir(strDir.c_str());
	strDir += "locale/";
#else
	strDir  = INSTALL_PREFIX;
	strDir += LOCALE_DIR;
#endif
	return strDir.c_str();
}

GuiLanguage g_lang(PACKAGE, get_locale_dir());

int main (int argc, char *argv[])
{
	//check startup options
	IniFile file;
	file.Load(MRU::getfilename());

	//initialize language system
	std::string strLocale;
	file.GetValue("Display", "Language", strLocale, "");
	g_lang.Initialize(strLocale.c_str());

	gtk_init (&argc, &argv);
	
	bool bAllowSingleInst = false;
	file.GetValue("Startup", "AllowSingleInstance", bAllowSingleInst);
	if(bAllowSingleInst && g_instance.ProgramAlreadyStarted())
	{
		gtkMessageBox(_("Another NoteCase instance detected! Exiting!"));
		return 0;
	}

	g_wnd.Create();

	bool bBackupLoaded = autosave_check_crash();

	// check for command line arguments: file name to open
	if(!bBackupLoaded)
	{
		if(argc > 1){
			int  nResult = load_file(argv[1]);
			//do not delete MRU for file that exists, but failed to open		
			g_objMRU.Change(argv[1], (DOC_LOAD_NOT_FOUND != nResult));	//update MRU
		}
		else{
			//check "reload last file" option
			bool bLoadLast;
			if(file.GetValue("Startup", "ReloadLastDocument", bLoadLast))
				if(bLoadLast && (g_objMRU.GetSize() > 0))
					load_file(g_objMRU.GetFile(0));
		}
	}

	gtk_main ();
	
	//TOFIX move this to quit handler
	autosave_shutdown();
	g_objMRU.Save();
	return 0;
}

#ifdef _WIN32
#include <windows.h>
int APIENTRY WinMain( HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR lpCmdLine, int nCmdShow)
{
	return main( __argc, __argv );
}
#endif

