////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Abstract class for different document formats I/O
////////////////////////////////////////////////////////////////////////////

#ifndef NODEFORMATIO_H__
#define NODEFORMATIO_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//supported formats
#define FORMAT_NONE			0
#define FORMAT_HTML			1
#define FORMAT_HTML_ENC		2
#define FORMAT_GJOTS2		3
#define FORMAT_STICKY		4

#include "NoteDocument.h"
class NoteDocument;

class NoteFormatIO  
{
public:
	NoteFormatIO();
	virtual ~NoteFormatIO();

	virtual int  Load(const char *szFile, NoteDocument &doc) = 0;
	virtual bool Save(const char *szFile, NoteDocument &doc) = 0;
	virtual int  GetFormat() = 0;

protected:
	NoteDocument *m_objDoc;
};

#endif // NODEFORMATIO_H__
