////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: GTK+ TextView wrapper class
////////////////////////////////////////////////////////////////////////////

#ifndef TEXTVIEW_H__
#define TEXTVIEW_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <gtk/gtk.h>

class TextView  
{
public:
	TextView();
	virtual ~TextView();
	void Create();
	
	void Clear();
	void DeleteText(int nOffset, int nLength);

	gchar *GetText();	//requires user to free result with g_free
	void SetText(const gchar *szText);
	void InsertText(int nOffset, const gchar *szText);

	int  GetSelectionEnd();
	void GetSelectionBounds(unsigned int& cursor, unsigned int& selection);
	void RestoreSelectionBounds(unsigned int cursor, unsigned int selection);
	void SelectRange(int nStart, int nEnd);
	void EnsureVisible(int nOffset);

	bool IsWrapped();
	bool GetModified();
	void SetModified(bool bModified);

	void ClipboardCut();
	void ClipboardCopy();
	void ClipboardPaste();
	void ClipboardDelete();

	void SetFocus();

public:
	GtkWidget *m_pWidget;
};

#endif // TEXTVIEW_H__
