////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Window class for Options dialog
////////////////////////////////////////////////////////////////////////////

#include "ExportDialog.h"
#include "support.h"

extern GtkWidget *window1;
static GtkWidget* create_export_dialog (GtkWidget* parent=NULL);

ExportDialog::ExportDialog()
{
	Create();
}

ExportDialog::~ExportDialog()
{
}

void ExportDialog::Create()
{
	m_pDialog = create_export_dialog (window1);
}

GtkWidget*
create_export_dialog (GtkWidget* parent)
{
	GtkWidget *export_dialog;
	GtkWidget *dialog_vbox1;
	GtkWidget *vbox1;
	GtkWidget *radiobutton1;
	GSList *radiobutton1_group = NULL;
	GtkWidget *radiobutton2;
	GtkWidget *radiobutton3;
	GtkWidget *dialog_action_area1;
	GtkWidget *cancelbutton1;
	GtkWidget *okbutton1;
	
	export_dialog = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (export_dialog), _("Select export source"));
	gtk_window_set_modal (GTK_WINDOW (export_dialog), TRUE);
	gtk_window_set_destroy_with_parent (GTK_WINDOW (export_dialog), TRUE);
#ifndef _WIN32  //TOFIX API is buggy on Win32 (kills modal dialog state)
	gtk_window_set_skip_taskbar_hint (GTK_WINDOW (export_dialog), TRUE);
#endif
	gtk_window_set_skip_pager_hint (GTK_WINDOW (export_dialog), TRUE);
	gtk_window_set_type_hint (GTK_WINDOW (export_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);
	
	if(parent)
		gtk_window_set_transient_for(GTK_WINDOW (export_dialog), GTK_WINDOW(parent));   //set parent
#if GTK_CHECK_VERSION(2,4,0) //new API TOFIX set proper version
	#ifndef _WIN32  //TOFIX API is buggy on Win32 (kills modal dialog state)
	  gtk_window_set_keep_above(GTK_WINDOW (export_dialog), TRUE);
	#endif
#endif
	
	dialog_vbox1 = GTK_DIALOG (export_dialog)->vbox;
	gtk_widget_show (dialog_vbox1);
	
	vbox1 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);
	
	radiobutton1 = gtk_radio_button_new_with_mnemonic (NULL, _("Selected node only"));
	gtk_widget_show (radiobutton1);
	gtk_box_pack_start (GTK_BOX (vbox1), radiobutton1, FALSE, FALSE, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobutton1), radiobutton1_group);
	radiobutton1_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton1));
	
	radiobutton2 = gtk_radio_button_new_with_mnemonic (NULL, _("Selected node with children"));
	gtk_widget_show (radiobutton2);
	gtk_box_pack_start (GTK_BOX (vbox1), radiobutton2, FALSE, FALSE, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobutton2), radiobutton1_group);
	radiobutton1_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton2));
	
	radiobutton3 = gtk_radio_button_new_with_mnemonic (NULL, _("Entire document"));
	gtk_widget_show (radiobutton3);
	gtk_box_pack_start (GTK_BOX (vbox1), radiobutton3, FALSE, FALSE, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobutton3), radiobutton1_group);
	radiobutton1_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton3));
	
	dialog_action_area1 = GTK_DIALOG (export_dialog)->action_area;
	gtk_widget_show (dialog_action_area1);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);
	
	cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
	gtk_widget_show (cancelbutton1);
	gtk_dialog_add_action_widget (GTK_DIALOG (export_dialog), cancelbutton1, GTK_RESPONSE_CANCEL);
	GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);
	
	okbutton1 = gtk_button_new_from_stock ("gtk-ok");
	gtk_widget_show (okbutton1);
	gtk_dialog_add_action_widget (GTK_DIALOG (export_dialog), okbutton1, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);
	
	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (export_dialog, export_dialog, "export_dialog");
	GLADE_HOOKUP_OBJECT_NO_REF (export_dialog, dialog_vbox1, "dialog_vbox1");
	GLADE_HOOKUP_OBJECT (export_dialog, vbox1, "vbox1");
	GLADE_HOOKUP_OBJECT (export_dialog, radiobutton1, "radiobutton1");
	GLADE_HOOKUP_OBJECT (export_dialog, radiobutton2, "radiobutton2");
	GLADE_HOOKUP_OBJECT (export_dialog, radiobutton3, "radiobutton3");
	GLADE_HOOKUP_OBJECT_NO_REF (export_dialog, dialog_action_area1, "dialog_action_area1");
	GLADE_HOOKUP_OBJECT (export_dialog, cancelbutton1, "CANCEL");
	GLADE_HOOKUP_OBJECT (export_dialog, okbutton1, "OK");
	
	gtk_widget_grab_focus (cancelbutton1);
	gtk_widget_grab_default (cancelbutton1);
	return export_dialog;
}


