# SPDX-License-Identifier: Apache-2.0

# Copyright 2020 igo95862

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

# http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
from time import sleep

from notcurses import Notcurses

nc = Notcurses()

stdplane = nc.stdplane()

red = 0x80
green = 0x80
blue = 0x80

y_dimension, x_dimension = stdplane.dim_yx()

for y in range(y_dimension):
    for x in range(x_dimension):
        stdplane.set_fg_rgb8(red, green, blue)
        stdplane.set_bg_rgb8(blue, red, green)
        stdplane.putstr_yx(y, x, 'X')
        blue += 2
        if blue == 256:
            blue = 0
            green += 2
            if green == 256:
                green = 0
                red = (red + 2) % 256


nc.render()

sleep(5)
