import { declare } from "@babel/helper-plugin-utils";
import { types as t } from "@babel/core";

export default declare(api => {
  api.assertVersion(7);

  return {
    name: "transform-jscript",

    visitor: {
      FunctionExpression: {
        exit(path) {
          const { node } = path;
          if (!node.id) return;

          path.replaceWith(
            t.callExpression(
              t.functionExpression(
                null,
                [],
                t.blockStatement([
                  // @ts-ignore fixme: t.toStatement may return false
                  t.toStatement(node),
                  t.returnStatement(t.cloneNode(node.id)),
                ]),
              ),
              [],
            ),
          );
        },
      },
    },
  };
});
