# {%= name %} {%= badge("fury") %} {%= badge("travis") %}

> {%= description %}

Why another flatten utility? I wanted the fastest implementation I could find, with implementation choices that should work for 95% of use cases, but no cruft to cover the other 5%.

## Run benchmarks

```bash
npm run benchmarks
```

Benchmark results comparing this library to [array-flatten]:

```bash
#1: large.js
  arr-flatten.js x 487,030 ops/sec ±0.67% (92 runs sampled)
  array-flatten.js x 347,020 ops/sec ±0.57% (98 runs sampled)

#2: medium.js
  arr-flatten.js x 1,914,516 ops/sec ±0.76% (94 runs sampled)
  array-flatten.js x 1,391,661 ops/sec ±0.63% (96 runs sampled)

#3: small.js
  arr-flatten.js x 5,158,980 ops/sec ±0.85% (94 runs sampled)
  array-flatten.js x 3,683,173 ops/sec ±0.79% (97 runs sampled)
```

## Run tests

Install dev dependencies:

```bash
npm i -d && npm test
```

{%= include("install-npm", {save: true}) %}
{%= include("install-bower", {save: true}) %}


## Usage

```js
var flatten = require('{%= name %}');

flatten(['a', ['b', ['c']], 'd', ['e']]);
//=> ['a', 'b', 'c', 'd', 'e']
```

## Author
{%= include("author") %}

## License
{%= copyright({start: 2014}) %}
{%= license() %}

***

{%= include("footer") %}

[array-flatten]: https://github.com/blakeembrey/array-flatten
