/* led indicator
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /*HAVE_UNISTD_H*/
#include <string.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "led.h"

#include "BITMAPS/noneled.xpm"
#include "BITMAPS/offled.xpm"
#include "BITMAPS/redled.xpm"
#include "BITMAPS/greenled.xpm"
#include "BITMAPS/blueled.xpm"
#include "BITMAPS/cyanled.xpm"
#include "BITMAPS/magentaled.xpm"
#include "BITMAPS/yellowled.xpm"

#include "BITMAPS/noneled_big.xpm"
#include "BITMAPS/offled_big.xpm"
#include "BITMAPS/redled_big.xpm"
#include "BITMAPS/greenled_big.xpm"
#include "BITMAPS/blueled_big.xpm"
#include "BITMAPS/cyanled_big.xpm"
#include "BITMAPS/magentaled_big.xpm"
#include "BITMAPS/yellowled_big.xpm"

static GtkPixmapClass *parent_class = NULL;

static GdkPixmap *led_px[2][LED_LAST] = { { NULL, }, };
static GdkBitmap *led_mask[2][LED_LAST] = { { NULL, }, };

static void
led_destroy( GtkObject *object )
{
	Led *ld;

	g_return_if_fail( object != NULL);
	g_return_if_fail( IS_LED( object ) );

	ld = LED( object );

	/* My instance destroy stuff.
	 */

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

static void
led_realize( GtkWidget *widget )
{
	Led *ld;
	static char **xpms[LED_LAST] = { noneled, offled, 
		redled, greenled, blueled,
		cyanled, magentaled, yellowled };
	static char **xpms_big[LED_LAST] = { noneled_big, offled_big, 
		redled_big, greenled_big, blueled_big,
		cyanled_big, magentaled_big, yellowled_big };

	g_return_if_fail( widget != NULL );
	g_return_if_fail( IS_LED( widget ) );

	ld = LED( widget );

	if( GTK_WIDGET_CLASS( parent_class )->realize )
		(*GTK_WIDGET_CLASS( parent_class )->realize )( widget );

	if( !led_px[0][0] ) {
		int i;

		for( i = 0; i < LED_LAST; i++ )
			led_px[0][i] = gdk_pixmap_create_from_xpm_d( 
				widget->window, &led_mask[0][i], NULL, 
				xpms[i] );
		for( i = 0; i < LED_LAST; i++ )
			led_px[1][i] = gdk_pixmap_create_from_xpm_d( 
				widget->window, &led_mask[1][i], NULL, 
				xpms_big[i] );
	}

	gtk_pixmap_set( GTK_PIXMAP( widget ), 
		led_px[ld->type][ld->colour], led_mask[ld->type][ld->colour] );
}

static void
led_class_init( LedClass *class )
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;

	object_class = (GtkObjectClass *) class;
	widget_class = (GtkWidgetClass *) class;

	parent_class = g_type_class_peek_parent( class );

	object_class->destroy = led_destroy;
	widget_class->realize = led_realize;
}

static void
led_init( Led *ld )
{
	ld->colour = LED_OFF;
	ld->type = 0;
}

GtkType
led_get_type( void )
{
	static GtkType led_type = 0;

	if (!led_type) {
		static const GtkTypeInfo ld_info = {
			"Led",
			sizeof( Led ),
			sizeof( LedClass ),
			(GtkClassInitFunc) led_class_init,
			(GtkObjectInitFunc) led_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		led_type = gtk_type_unique( GTK_TYPE_PIXMAP, &ld_info );
	}

	return( led_type );
}

GtkWidget *
led_new( void )
{
	Led *ld = (Led *) gtk_type_new( TYPE_LED );

	return( GTK_WIDGET( ld ) );
}

void
led_set_colour( Led *ld, LedColour colour )
{
	g_return_if_fail( ld != NULL );
	g_return_if_fail( IS_LED( ld ) );

	if( colour < 0 )
		colour = 0;
	else if( colour >= LED_LAST )
		colour = LED_LAST - 1;

	if( ld->colour != colour ) {
		ld->colour = colour;

		if( GTK_WIDGET_REALIZED( ld ) )
			gtk_pixmap_set( GTK_PIXMAP( ld ), 
				led_px[ld->type][ld->colour], 
				led_mask[ld->type][ld->colour] );
	}
}

void
led_set_type( Led *ld, int type )
{
	g_return_if_fail( ld != NULL );
	g_return_if_fail( IS_LED( ld ) );

	if( type < 0 )
		type = 0;
	else if( type > 1 )
		type = 1;

	if( ld->type != type ) {
		ld->type = type;
		
		if( GTK_WIDGET_REALIZED( ld ) )
			gtk_pixmap_set( GTK_PIXMAP( ld ), 
				led_px[ld->type][ld->colour], 
				led_mask[ld->type][ld->colour] );
	}
}
