/* Decls supportibng calibrate.c 
 */

/* Need colour.h
 */
#include <vips/colour.h>

/* A calibrate struct. Hold a display characterisation, and a set of tables
 * computed from that. Also a reference count, for calibrate_info sharing.
 */
struct _CalibrateInfo {
	int ref;
	struct im_col_display disp;
	IMAGE *dummy;		/* close this to free next thing */
	void *table;		/* From im_LabQ2disp_build_table() */
};

/* Calibration preferences.
 */
extern CalibrateInfo *calibrate_preferences;

extern void init_calibrate( void );
extern CalibrateInfo *copy_cal_info( CalibrateInfo *cal );
extern void free_cal_info( CalibrateInfo *cal );
extern void pop_cal_pref( Widget, CalibrateInfo **, struct display * );
extern Bool build_lab_tables( CalibrateInfo *cal );
