/* Declarations supporting table.c.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

*/

/* A symbol table. We hash into this array, then search linearly along each
 * list for the symbol we want. sofar is used to help generate unique
 * names for the table. traverse keeps the table in insert order.
 */
struct _SymTable {
	Compile *compile;	/* Enclosing compile */
	GSList **array;		/* Hash spine */
	GSList *traverse;	/* Members, in insert order */
	int size;
	int sofar;
};

Symbol *stable_map( SymTable *tab, 
	symbol_map_fn fn, void *a, void *b, void *c );
Symbol *stable_map_rev( SymTable *tab, 
	symbol_map_fn fn, void *a, void *b, void *c );
SymTable *stable_get_parent( SymTable *tab );
void stable_name_print( SymTable *tab );

void stable_destroy( SymTable *tab );
SymTable *stable_new( Compile *compile, int size );

Symbol *stable_find( SymTable *tab, const char *name );
void stable_add( SymTable *tab, Symbol *sym );
void stable_to_end( Symbol *sym );
void stable_unlink( Symbol *sym );

void stable_resolve_names( SymTable *inner, SymTable *outer );
void stable_resolve_names_top( SymTable *inner );
void stable_resolve_dynamic( SymTable *tab, SymTable *context );
