/* coordinate the display of regionviews on imageviews
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ViewClass *parent_class = NULL;

static void
iregiongroupview_destroy( GtkObject *object )
{
	Iregiongroupview *iregiongroupview;
	Classmodel *classmodel;

#ifdef DEBUG
	printf( "iregiongroupview_destroy\n" );
#endif /*DEBUG*/

	g_return_if_fail( object != NULL );
	g_return_if_fail( IS_IREGIONGROUPVIEW( object ) );

	iregiongroupview = IREGIONGROUPVIEW( object );

	/* Destroy all regionviews we manage.
	 */
	classmodel = CLASSMODEL( VIEW( iregiongroupview )->model->parent );
	slist_map( classmodel->views, (SListMapFn) object_destroy, NULL );

	GTK_OBJECT_CLASS( parent_class )->destroy( object );
}

/* What we track during a refresh.
 */
typedef struct {
	GSList *notused;
	Iregiongroupview *iregiongroupview;
	Classmodel *classmodel;
	Iimage *iimage;
	Imageview *iv;
} IregiongroupviewRefreshState;

static Regionview *
iregiongroupview_refresh_imageview_test( Regionview *regionview,
	IregiongroupviewRefreshState *irs )
{
	if( regionview->classmodel == irs->classmodel && 
		regionview->ip == irs->iv->ip )
		return( regionview );

	return( NULL );
}

static void *
iregiongroupview_refresh_imageview( Imageview *iv, 
	IregiongroupviewRefreshState *irs )
{
	Regionview *regionview;

	irs->iv = iv;

	/* Do we have a Regionview for this iv already?
	 */
	if( (regionview = slist_map( irs->notused,
		(SListMapFn) iregiongroupview_refresh_imageview_test, irs )) ) {
		/* Yes ... reuse.
		 */
		irs->notused = g_slist_remove( irs->notused, regionview );
	}
	else {
		/* Nope ... make a new one.
		 */
		IregionInstance *instance = 
			classmodel_get_instance( irs->classmodel );
		PElement *root = &HEAPMODEL( irs->classmodel )->row->expr->root;

		Regionview *regionview = regionview_new( 
			irs->classmodel, &instance->area, iv->ip );

		/* Set the display type from the heap class name.
		 */
		regionview_set_type( regionview, root );
	}

	return( NULL );
}

static void *
iregiongroupview_refresh_iimage( Iimage *iimage, 
	IregiongroupviewRefreshState *irs )
{
	irs->iimage = iimage;
	slist_map( iimage->views,
		(SListMapFn) iregiongroupview_refresh_imageview, irs );

	return( NULL );
}

static void 
iregiongroupview_refresh( View *view )
{
	Iregiongroupview *iregiongroupview = IREGIONGROUPVIEW( view );
	Classmodel *classmodel = CLASSMODEL( view->model );

	IregiongroupviewRefreshState irs;

#ifdef DEBUG
	printf( "iregiongroupview_refresh\n" );
#endif /*DEBUG*/

	/* Make a note of all the displays we have now, loop over the 
	 * displays we should have, reusing when possible ... remove any 
	 * unused displays at the end.
	 */
	irs.classmodel = CLASSMODEL( MODEL( classmodel )->parent );
	irs.notused = g_slist_copy( irs.classmodel->views );
	irs.iregiongroupview = iregiongroupview;

	slist_map( irs.classmodel->iimages,
		(SListMapFn) iregiongroupview_refresh_iimage, &irs );

	/* Remove all the regionviews we've not used. 
	 */
	slist_map( irs.notused, (SListMapFn) object_destroy, NULL );
	FREEF( g_slist_free, irs.notused );

	VIEW_CLASS( parent_class )->refresh( view );
}

static void
iregiongroupview_class_init( IregiongroupviewClass *klass )
{
	GtkObjectClass *object_class = (GtkObjectClass *) klass;
	ViewClass *view_class = (ViewClass *) klass;

	parent_class = gtk_type_class( TYPE_VIEW );

	object_class->destroy = iregiongroupview_destroy;

	/* Create signals.
	 */

	/* Init methods.
	 */
	view_class->refresh = iregiongroupview_refresh;
}

static void
iregiongroupview_init( Iregiongroupview *iregiongroupview )
{
#ifdef DEBUG
	printf( "iregiongroupview_init\n" );
#endif /*DEBUG*/
}

GtkType
iregiongroupview_get_type( void )
{
	static GtkType iregiongroupview_type = 0;

	if( !iregiongroupview_type ) {
		static const GtkTypeInfo info = {
			"Iregiongroupview",
			sizeof( Iregiongroupview ),
			sizeof( IregiongroupviewClass ),
			(GtkClassInitFunc) iregiongroupview_class_init,
			(GtkObjectInitFunc) iregiongroupview_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		iregiongroupview_type = gtk_type_unique( TYPE_VIEW, &info );
	}

	return( iregiongroupview_type );
}

View *
iregiongroupview_new( void )
{
	Iregiongroupview *iregiongroupview = 
		gtk_type_new( TYPE_IREGIONGROUPVIEW );

#ifdef DEBUG
	printf( "iregiongroupview_new\n" );
#endif /*DEBUG*/

	return( VIEW( iregiongroupview ) );
}
