/* decls for boxes.
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

void box_error( GtkWidget *par, const char *fmt, ... );
void box_alert( GtkWidget *par );
void box_info( GtkWidget *par, const char *fmt, ... );
iDialog *box_yesno( GtkWidget *par, 
	iWindowFn okcb, iWindowFn cancelcb, void *client,
	iWindowNotifyFn nfn, void *sys,
	const char *yes_label, 
	const char *fmt, ... );
void box_savenosave( GtkWidget *par, 
	iWindowFn save, iWindowFn nosave, void *client, 
	iWindowNotifyFn nfn, void *sys,		
	const char *fmt, ... );

void box_help( GtkWidget *par, const char *name );
void box_help_cb( gpointer data, guint action, GtkWidget *widget );
void box_about( GtkWidget *par );

/* A dialog showing a bunch of editable strings ... eg. name and caption for
 * new toolkit etc. etc.
 */
#define TYPE_STRINGSET (stringset_get_type())
#define STRINGSET( obj ) \
	(GTK_CHECK_CAST( (obj), TYPE_STRINGSET, Stringset ))
#define STRINGSET_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), TYPE_STRINGSET, StringsetClass ))
#define IS_STRINGSET( obj ) (GTK_CHECK_TYPE( (obj), TYPE_STRINGSET ))
#define IS_STRINGSET_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_STRINGSET ))

/* A Stringset is a bunch of these.
 */
typedef struct {
	struct _Stringset *ss;

	GtkWidget *entry;	
	const char *label;	
	const char *text;	/* Current text value */
	const char *tooltip;
} StringsetChild;

typedef struct _Stringset {
	iDialog parent;

	GSList *children;	
} Stringset;

typedef struct _StringsetClass {
	iDialogClass parent_class;

	/* My methods.
	 */
} StringsetClass;

void *stringset_child_destroy( StringsetChild *ssc );
StringsetChild *stringset_child_new( Stringset *ss,
	const char *label, const char *text, const char *tooltip );
GtkType stringset_get_type( void );
GtkWidget *stringset_new( void );
StringsetChild *stringset_child_get( Stringset *, const char *label );

/* Find dialog.
 */
#define TYPE_FIND (find_get_type())
#define FIND( obj ) \
	(GTK_CHECK_CAST( (obj), TYPE_FIND, Find ))
#define FIND_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), TYPE_FIND, FindClass ))
#define IS_FIND( obj ) (GTK_CHECK_TYPE( (obj), TYPE_FIND ))
#define IS_FIND_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_FIND ))

typedef struct _Find {
	iDialog parent;

	/* My instance vars.
	 */
	GtkWidget *search;
	GtkWidget *regexp;
	GtkWidget *csens;
	GtkWidget *fromtop;
} Find;

typedef struct _FindClass {
	iDialogClass parent_class;

	/* My methods.
	 */
} FindClass;

GtkType find_get_type( void );
GtkWidget *find_new( void );

/* Image header dialog.
 */
#define TYPE_IMAGEHEADER (imageheader_get_type())
#define IMAGEHEADER( obj ) \
	(GTK_CHECK_CAST( (obj), TYPE_IMAGEHEADER, Imageheader ))
#define IMAGEHEADER_CLASS( klass ) \
	(GTK_CHECK_CLASS_CAST( (klass), TYPE_IMAGEHEADER, ImageheaderClass ))
#define IS_IMAGEHEADER( obj ) (GTK_CHECK_TYPE( (obj), TYPE_IMAGEHEADER ))
#define IS_IMAGEHEADER_CLASS( klass ) \
	(GTK_CHECK_CLASS_TYPE( (klass), TYPE_IMAGEHEADER ))

typedef struct _Imageheader {
	iDialog parent;

	Conversion *conv;
	guint changed_sid;

	GtkWidget *xsize;
	GtkWidget *ysize;
	GtkWidget *bands;
	GtkWidget *bbits;
	GtkWidget *fmt;
	GtkWidget *coding;
	GtkWidget *type;
	GtkWidget *xres;
	GtkWidget *yres;
	GtkWidget *xoff;
	GtkWidget *yoff;
	GtkWidget *history;
	GtkWidget *filename;
} Imageheader;

typedef struct _ImageheaderClass {
	iDialogClass parent_class;

	/* My methods.
	 */
} ImageheaderClass;

GtkType imageheader_get_type( void );
GtkWidget *imageheader_new( Conversion *conv );

void box_url( GtkWidget *par, const char *url );
void box_url_cb( gpointer callback_data, guint callback_action,
        GtkWidget *widget );
