/*
 *  Nikwi Deluxe
 *  Copyright (C) 2006  Kostas Michalopoulos
 *  
 *  A game by Kostas "Bad Sector" Michalopoulos
 *  email: badsector@slashstone.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
** Nikwi Engine - Utilities
*/

#include "nikwi.h"

void fatal(String msg)
{
	#ifdef WIN32
	MessageBox(NULL, msg, "Fatal error", MB_ICONERROR|MB_OK);
	#else
	fprintf(stderr, "Fatal error: %s", msg);
	#endif
	exit(1);
}

BadCFGNode *loadCFG(String file)
{
	BadCFGNode	*root;
	String		textData = getStringData(file);
	if (!textData)
		return NULL;
	root = parseBadCFGCode(textData);
	free(textData);

	return root;
}

uint makeCode(String code)
{
	return code[0]|(code[1] << 8)|(code[2] << 16)|(code[3] << 24);
}

bool rectOverRect(int ax1, int ay1, int ax2, int ay2, int bx1, int by1, int bx2,
	int by2)
{
	return !(bx1 > ax2 || bx2 < ax1 || by1 > ay2 || by2 < ay1);
}

