/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DirectoryClassLoader
extends ClassLoader {
    private File[] dirs;

    public DirectoryClassLoader(File[] dirs, ClassLoader parent) {
        super(parent);
        this.dirs = dirs;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/') + ".class";
        for (int i = 0; i < this.dirs.length; ++i) {
            Class res = this.findClass(name, new File(this.dirs[i], path));
            if (res == null) continue;
            return res;
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findClass(String name, File file) {
        FileInputStream fi = null;
        try {
            fi = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        try {
            byte[] classBytes = new byte[fi.available()];
            fi.read(classBytes);
            Class<?> clazz = this.defineClass(name, classBytes, 0, classBytes.length);
            return clazz;
        }
        catch (IOException e) {
            Class clazz = null;
            return clazz;
        }
        finally {
            try {
                fi.close();
            }
            catch (IOException e) {}
        }
    }
}

