/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.testsuite;

import bossa.modules.Compilation;
import bossa.modules.fun;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nice.tools.compiler.console.ConsoleOutput;
import nice.tools.testsuite.CompilerBugException;
import nice.tools.testsuite.NiceSourceFile;
import nice.tools.testsuite.TestNice;
import nice.tools.testsuite.TestSuite;
import nice.tools.testsuite.TestSuiteException;

public abstract class TestCase {
    private static final String ERROR_MSG = "Compilation failed with errors.";
    private static final String BUG_MSG = "Compilation failed because of a bug in the compiler.";
    private static final String WARNING_MSG = "Compilation successful despite warnings.";
    private static final String OK_MSG = "Compilation successful.";
    private TestSuite _testSuite;
    private List _niceSourceFiles = new ArrayList();
    private NiceSourceFile _currentSourceFile;
    private Set _dontCompilePackages = new HashSet();
    private ByteArrayOutputStream _compilerMessagesStream;
    private List _failPositions = new ArrayList();
    private int _lineCounter = 0;
    boolean isKnownBug;
    boolean skip;
    static /* synthetic */ Class array$Ljava$lang$String;

    public TestCase(TestSuite suite) {
        this._testSuite = suite;
        this.createNewSourceFile();
    }

    private void createNewSourceFile() {
        this._currentSourceFile = new NiceSourceFile();
        this._niceSourceFiles.add(this._currentSourceFile);
        if (this._testSuite.hasGlobalSource()) {
            this._currentSourceFile.addImportGlobal();
        }
        this._lineCounter = 1;
    }

    protected List getFailPositions() {
        return this._failPositions;
    }

    public void consumeLine(String line) throws TestSuiteException {
        if (this.consumeKeywordLine(line)) {
            return;
        }
        ++this._lineCounter;
        this.consumeCommentedKeyword(line);
        this._currentSourceFile.consumeLine(line);
    }

    private boolean consumeKeywordLine(String line) throws TestSuiteException {
        if (!(line = line.trim()).startsWith("///")) {
            return false;
        }
        String keywordStatement = line.substring("///".length()).trim();
        if ("toplevel".equalsIgnoreCase(keywordStatement.toLowerCase())) {
            this._currentSourceFile.setStatus(1);
        } else if (keywordStatement.startsWith("package")) {
            if (!this._currentSourceFile.isEmpty()) {
                this.createNewSourceFile();
            }
            this._currentSourceFile.consumePackageKeyword(keywordStatement);
            if (keywordStatement.indexOf("dontcompile") != -1) {
                this._dontCompilePackages.add(this._currentSourceFile.getPackage());
            }
        } else {
            this._testSuite.consumeComment(line);
        }
        return true;
    }

    private void consumeCommentedKeyword(String line) {
        int startCommentPos;
        int pos = 0;
        while ((startCommentPos = line.indexOf("/*", pos)) != -1) {
            int endCommentPos;
            pos = endCommentPos = line.indexOf("*/", startCommentPos + 2);
            if (startCommentPos == -1 || endCommentPos == -1) {
                return;
            }
            String comment = line.substring(startCommentPos, endCommentPos);
            int keywordSignPos = line.indexOf("///");
            if (keywordSignPos < startCommentPos || endCommentPos < keywordSignPos) {
                return;
            }
            String keywordStatement = line.substring(keywordSignPos + "///".length(), endCommentPos).trim();
            if (!"fail here".equalsIgnoreCase(keywordStatement.toLowerCase())) continue;
            int columnNum = endCommentPos + 2;
            while (Character.isWhitespace(line.charAt(columnNum))) {
                ++columnNum;
            }
            int lineNum = this._lineCounter + this._currentSourceFile.getCountImports() + 2;
            this._failPositions.add(new FailPosition(this._currentSourceFile.getFileName(), lineNum, columnNum + 1, this._currentSourceFile, this._currentSourceFile.getStatus() == 0));
        }
    }

    public void writeFiles() throws TestSuiteException {
        Iterator iter = this._niceSourceFiles.iterator();
        while (iter.hasNext()) {
            NiceSourceFile sourceFile = (NiceSourceFile)iter.next();
            sourceFile.write();
        }
        if (this._testSuite.hasGlobalSource()) {
            this._testSuite.getGlobalSource().write();
        }
    }

    public void performTest() {
        TestNice.getOutput().startTestCase(this);
    }

    private List getPackages() {
        ArrayList<String> packages = new ArrayList<String>();
        Iterator iter = this._niceSourceFiles.iterator();
        while (iter.hasNext()) {
            NiceSourceFile sourceFile = (NiceSourceFile)iter.next();
            if (packages.contains(sourceFile.getPackage())) continue;
            packages.add(sourceFile.getPackage());
        }
        return packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compilePackages() throws TestSuiteException, CompilerBugException {
        this._compilerMessagesStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(this._compilerMessagesStream);
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        System.setOut(out);
        System.setErr(out);
        boolean showMessages = false;
        try {
            List packageNames = this.getPackages();
            Iterator iter = packageNames.iterator();
            while (iter.hasNext()) {
                String packageName = (String)iter.next();
                if (this._dontCompilePackages.contains(packageName)) continue;
                int retval = this.compilePackage(packageName);
                switch (retval) {
                    case 2: {
                        showMessages = true;
                        throw new TestSuiteException(ERROR_MSG);
                    }
                    case 1: {
                        showMessages = true;
                        throw new CompilerBugException(BUG_MSG);
                    }
                    case 3: {
                        showMessages = true;
                    }
                }
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            System.setOut(origOut);
            System.setErr(origErr);
            try {
                this._compilerMessagesStream.close();
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        System.setOut(origOut);
        System.setErr(origErr);
        try {
            this._compilerMessagesStream.close();
            out.close();
        }
        catch (IOException e) {}
    }

    private int compilePackage(String packageName) throws TestSuiteException {
        String tempDir;
        ConsoleOutput output = nice.tools.compiler.console.fun.consoleOutput();
        Compilation compilation = fun.createCompilation(output);
        compilation.sourcePath = tempDir = TestNice.getTempFolder().getAbsolutePath();
        compilation.destinationDir = tempDir;
        compilation.runtimeFile = TestNice.getRuntime();
        nice.tools.compiler.fun.compile(compilation, packageName, null, null, false);
        return output.statusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runMain() throws TestSuiteException {
        ByteArrayOutputStream mainMessagesStream = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(mainMessagesStream);
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        System.setOut(out);
        System.setErr(out);
        try {
            Iterator iter = this._niceSourceFiles.iterator();
            while (iter.hasNext()) {
                NiceSourceFile sourceFile = (NiceSourceFile)iter.next();
                if (!sourceFile.hasMainMethod() || this._dontCompilePackages.contains(sourceFile.getPackage())) continue;
                try {
                    Class<?> c = Class.forName(sourceFile.getPackage() + ".fun", true, TestNice.getClassLoader());
                    Class[] parameterTypes = new Class[]{array$Ljava$lang$String == null ? TestCase.class$("[Ljava.lang.String;") : array$Ljava$lang$String};
                    Method m = c.getMethod("main", parameterTypes);
                    Object[] arguments = new Object[]{new String[0]};
                    try {
                        m.invoke(c.newInstance(), arguments);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(out);
                    throw new TestSuiteException("Exception while invoking main()", e);
                }
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            System.setOut(origOut);
            System.setErr(origErr);
            try {
                mainMessagesStream.close();
                out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (mainMessagesStream.size() != 0) {
                TestNice.getOutput().log("main", mainMessagesStream.toString());
            }
            throw throwable;
        }
        System.setOut(origOut);
        System.setErr(origErr);
        try {
            mainMessagesStream.close();
            out.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (mainMessagesStream.size() != 0) {
            TestNice.getOutput().log("main", mainMessagesStream.toString());
        }
    }

    public void pass() {
        if (this.isKnownBug) {
            TestNice.increaseFixed();
            this.printSources();
            TestNice.getOutput().logAndFlush("The above known bug is now FIXED!");
        } else {
            TestNice.increaseSucceeded();
        }
        TestNice.getOutput().endTestCase(true);
    }

    public void fail() {
        if (this.isKnownBug) {
            TestNice.increaseKnownBug();
            TestNice.getOutput().endTestCase(true);
        } else {
            TestNice.increaseFailed();
            this.printSources();
            TestNice.getOutput().log("nicec", this.getCompilerMessages());
            TestNice.getOutput().endTestCase(false);
        }
        TestNice.moveFilesToFailFolder();
    }

    public void warning() {
        TestNice.increaseWarning();
        this.printSources();
        TestNice.getOutput().log("nicec", this.getCompilerMessages());
        TestNice.getOutput().endTestCase(false);
        TestNice.moveFilesToFailFolder();
    }

    private void printSources() {
        BufferedWriter writer;
        StringWriter contentWriter;
        Iterator iter = this._niceSourceFiles.iterator();
        while (iter.hasNext()) {
            NiceSourceFile sourceFile = (NiceSourceFile)iter.next();
            contentWriter = new StringWriter();
            writer = new BufferedWriter(contentWriter);
            try {
                sourceFile.write(writer);
                contentWriter.close();
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            TestNice.getOutput().log("file " + sourceFile.getPackage() + "." + sourceFile.getFileName(), contentWriter.toString());
            TestNice.getOutput().log("");
        }
        if (this._testSuite.hasGlobalSource()) {
            contentWriter = new StringWriter();
            writer = new BufferedWriter(contentWriter);
            try {
                this._testSuite.getGlobalSource().write(writer);
                contentWriter.close();
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            TestNice.getOutput().log("file " + this._testSuite.getGlobalSource().getPackage() + "." + this._testSuite.getGlobalSource().getFileName(), contentWriter.toString());
            TestNice.getOutput().log("");
        }
    }

    protected String getCompilerMessages() {
        return this._compilerMessagesStream.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class FailPosition {
        private String _fileName;
        private int _line;
        private int _column;
        private NiceSourceFile _sourceFile;
        private boolean _inMain;

        FailPosition(String fileName, int line, int column, NiceSourceFile sourceFile, boolean inMain) {
            this._fileName = fileName;
            this._line = line;
            this._column = column;
            this._sourceFile = sourceFile;
            this._inMain = inMain;
        }

        protected String getFileName() {
            return this._fileName;
        }

        protected int getLine() {
            int res = this._line;
            res = this._inMain ? (res += this._sourceFile.getTopLevelSectionLength() + 2) : (res -= this._sourceFile.getMainSectionLength());
            return res;
        }

        protected int getColumn() {
            return this._column;
        }
    }
}

