/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import bossa.syntax.LocatedString;
import bossa.syntax.Node;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import gnu.bytecode.Type;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedList;
import nice.tools.util.System;

public class TypeImport {
    private static String runtime;
    static HashMap stringToReflectClass;
    private static ClassLoader classLoader;
    private static String currentClasspath;

    public static void setRuntime(String file) {
        runtime = file;
    }

    public static String getRuntime() {
        return runtime;
    }

    public static Type lookup(LocatedString className) {
        return TypeImport.lookup(className.toString(), className.location());
    }

    public static Type lookup(String className, Location loc) {
        Type res = null;
        try {
            res = TypeImport.lookupQualified(className);
        }
        catch (NoClassDefFoundError e) {
            User.error((Located)loc, "Class " + className + " depends on class " + e.getMessage().replace('/', '.') + ", which is not available on the classpath");
        }
        if (res != null) {
            return res;
        }
        String[] pkgs = Node.getGlobalTypeScope().module.listImplicitPackages();
        for (int i = 0; i < pkgs.length; ++i) {
            Type found = TypeImport.lookupQualified(pkgs[i] + "." + className);
            if (found == null) continue;
            if (i == 0) {
                return found;
            }
            if (res != null) {
                User.error((Located)loc, "Ambiguity for native class " + className + ":\n" + res.getName() + " and " + found.getName() + " both exist");
            }
            res = found;
        }
        if (res != null) {
            return res;
        }
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            char[] chars = className.toCharArray();
            chars[lastDot] = 36;
            return TypeImport.lookup(new String(chars), loc);
        }
        return null;
    }

    public static Type lookupQualified(String className) {
        Type res = Type.loadFromClasspath(className);
        if (res != null) {
            return res;
        }
        Class c = TypeImport.lookupQualifiedJavaClass(className);
        if (c == null) {
            return null;
        }
        return Type.make(c);
    }

    static Class lookupJavaClass(String className) {
        Class res = TypeImport.lookupQualifiedJavaClass(className);
        if (res != null) {
            return res;
        }
        String[] pkgs = Node.getGlobalTypeScope().module.listImplicitPackages();
        for (int i = 0; i < pkgs.length; ++i) {
            res = TypeImport.lookupQualifiedJavaClass(pkgs[i] + "." + className);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public static Class lookupQualifiedJavaClass(String className) {
        if (stringToReflectClass.containsKey(className)) {
            return (Class)stringToReflectClass.get(className);
        }
        Class<?> c = null;
        try {
            c = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        stringToReflectClass.put(className, c);
        return c;
    }

    public static void setClasspath(String classpath) {
        int start;
        if (currentClasspath.equals(classpath)) {
            return;
        }
        currentClasspath = classpath;
        LinkedList<URL> components = new LinkedList<URL>();
        for (start = 0; start < classpath.length() && classpath.charAt(start) == File.pathSeparatorChar; ++start) {
        }
        while (start < classpath.length()) {
            String pathComponent;
            int end = classpath.indexOf(File.pathSeparatorChar, start);
            if (end == -1) {
                end = classpath.length();
            }
            if ((pathComponent = classpath.substring(start, end)).length() > 0) {
                try {
                    File f = System.getFile(pathComponent);
                    if (f.canRead()) {
                        components.add(f.getCanonicalFile().toURL());
                    } else if (!f.exists()) {
                        User.warning("Classpath component " + pathComponent + " does not exist");
                    } else {
                        User.warning("Classpath component " + pathComponent + " is not readable");
                    }
                }
                catch (MalformedURLException e) {
                    User.warning("Classpath component " + pathComponent + " is invalid");
                }
                catch (IOException e) {
                    User.warning("Classpath component " + pathComponent + " is invalid");
                }
            }
            start = end + 1;
        }
        classLoader = new URLClassLoader(components.toArray(new URL[components.size()]), null);
    }

    static {
        currentClasspath = "NOT INITIALIZED";
    }
}

