/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing.lowlevel;

import bossa.util.Internal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import mlsub.typing.ImplementsCst;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeLeqCst;
import mlsub.typing.MonotypeVar;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeConstructorLeqCst;
import mlsub.typing.Variance;
import mlsub.typing.lowlevel.BackableList;
import mlsub.typing.lowlevel.BitVector;
import mlsub.typing.lowlevel.Debug;
import mlsub.typing.lowlevel.Element;
import mlsub.typing.lowlevel.InternalError;
import mlsub.typing.lowlevel.K0;
import mlsub.typing.lowlevel.Kind;
import mlsub.typing.lowlevel.LowlevelSolutionHandler;
import mlsub.typing.lowlevel.LowlevelUnsatisfiable;
import mlsub.typing.lowlevel.Unsatisfiable;

public abstract class Engine {
    private static int existentialLevel;
    private static Element top;
    private static final int FLOATING = -3;
    private static final int RIGID = -4;
    private static final BackableList frozenLeqs;
    private static HashMap kindsMap;
    private static final BackableList floating;
    private static final BackableList soft;
    private static final BackableList formerFree;
    public static Constraint variablesConstraint;
    private static ArrayList constraints;
    private static boolean initialContext;
    public static boolean dbg;

    public static void enter(boolean tentative) {
        if (dbg) {
            Debug.println("Enter");
        }
        floating.mark();
        soft.mark();
        formerFree.mark();
        if (!tentative && existentialLevel > 0) {
            ++existentialLevel;
        } else {
            frozenLeqs.mark();
            Iterator i = constraints.iterator();
            while (i.hasNext()) {
                Constraint k = (Constraint)i.next();
                k.mark();
            }
        }
    }

    public static void implies() throws Unsatisfiable {
        Engine.assertFrozens();
        if (dbg) {
            Debug.println("Implies");
        }
        Iterator i = constraints.iterator();
        while (i.hasNext()) {
            Constraint k = (Constraint)i.next();
            k.satisfy();
            k.rigidify();
        }
    }

    public static void satisfy() throws Unsatisfiable {
        Engine.assertFrozens();
        Iterator i = constraints.iterator();
        while (i.hasNext()) {
            Constraint k = (Constraint)i.next();
            k.satisfy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void leave(boolean tentative, boolean commit) throws Unsatisfiable {
        commit &= (tentative &= existentialLevel > 0);
        boolean ok = false;
        try {
            Engine.assertFrozens();
            if (dbg) {
                Debug.println("Leave");
            }
            Iterator i = constraints.iterator();
            while (i.hasNext()) {
                Constraint k = (Constraint)i.next();
                try {
                    if (dbg) {
                        Debug.println("** Satisfying " + k);
                    }
                    k.satisfy();
                }
                catch (Unsatisfiable e) {
                    if (dbg) {
                        Debug.println("** Exception in " + k + e);
                    }
                    throw e;
                }
            }
            ok = true;
            Engine.backtrack(tentative, ok && commit);
        }
        catch (Throwable throwable) {
            Engine.backtrack(tentative, ok && commit);
            throw throwable;
        }
    }

    public static void backtrack(boolean tentative, boolean commit) {
        floating.backtrack();
        if (existentialLevel <= 1 || tentative) {
            Iterator i = constraints.iterator();
            while (i.hasNext()) {
                Constraint k = (Constraint)i.next();
                k.backtrack(commit);
            }
            if (!commit) {
                frozenLeqs.backtrack();
            }
        }
        soft.backtrack();
        formerFree.backtrack();
        if (!tentative && existentialLevel > 0) {
            --existentialLevel;
        }
    }

    public static void startSimplify() {
        Iterator i = constraints.iterator();
        while (i.hasNext()) {
            Constraint k = (Constraint)i.next();
            k.startSimplify();
        }
    }

    public static void stopSimplify() {
        Iterator i = constraints.iterator();
        while (i.hasNext()) {
            Constraint k = (Constraint)i.next();
            k.stopSimplify();
        }
    }

    public static void leq(Element[] e1, Element[] e2) throws Unsatisfiable {
        if (e1.length != e2.length) {
            throw new IllegalArgumentException("Bad size in Engine.leq(Element[])");
        }
        for (int i = e1.length - 1; i >= 0; --i) {
            Engine.leq(e1[i], e2[i]);
        }
    }

    public static final void leq(Element e1, Element e2) throws Unsatisfiable {
        Engine.leq(e1, e2, false);
    }

    public static void setTop(Element top) {
        Engine.top = top;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void leq(Element e1, Element e2, boolean initial) throws Unsatisfiable {
        if (e2 == top) {
            return;
        }
        Kind k1 = e1.getKind();
        Kind k2 = e2.getKind();
        if (k2 == TopMonotype.TopKind.instance) {
            return;
        }
        if (k1 != null) {
            if (k2 == null) {
                Engine.setKind(e2, k1);
                k1.leq(e1, e2, initial);
                return;
            }
            if (k1.equals(k2)) {
                k1.leq(e1, e2, initial);
                return;
            }
            if (k1 == TopMonotype.TopKind.instance && e2 instanceof MonotypeVar && !Engine.isRigid(e2)) {
                ((MonotypeVar)e2).resetKind(k1);
                return;
            }
            if (!dbg) throw new LowlevelUnsatisfiable("Bad Kinding for " + e1 + " and " + e2);
            Debug.println("Bad kinding discovered by Engine : " + k1 + " != " + k2 + "\nfor elements " + e1 + " and " + e2);
            throw new LowlevelUnsatisfiable("Bad Kinding for " + e1 + " and " + e2);
        }
        if (k2 != null) {
            Engine.setKind(e1, k2);
            k2.leq(e1, e2, initial);
            return;
        }
        if (dbg) {
            Debug.println("Freezing " + e1 + " <: " + e2 + " (" + e1.getId() + " <: " + e2.getId() + ")");
            if (!floating.contains(e1)) {
                throw new InternalError("Unknown floating element 1 : " + e1);
            }
            if (!floating.contains(e2)) {
                throw new InternalError("Unknown floating element 2 : " + e2);
            }
        }
        frozenLeqs.add(new Leq(e1, e2));
    }

    public static void register(Element e) {
        if (dbg) {
            Debug.println("Registering " + e);
        }
        if (e.isExistential() && existentialLevel == 0) {
            existentialLevel = 1;
        }
        if (e.getKind() != null) {
            e.getKind().register(e);
        } else {
            e.setId(-3);
            floating.add(e);
        }
    }

    public static boolean isRigid(Element e) {
        if (e.getId() == -3) {
            return false;
        }
        Kind kind = e.getKind();
        if (kind == null) {
            throw new InternalError("null kind in Engine.isRigid for " + e);
        }
        Constraint k = Engine.getConstraint(kind);
        if (k == null) {
            throw new InternalError("null constraint in Engine.isRigid for " + e);
        }
        return k.isRigid(e);
    }

    public static void tag(Element e, int variance) {
        Kind kind = e.getKind();
        if (kind == null) {
            return;
        }
        Constraint k = Engine.getConstraint(kind);
        if (k == null) {
            throw new InternalError("null constraint for " + e);
        }
        k.tag(e, variance);
    }

    public static void simplify(ArrayList binders, final ArrayList atoms) {
        Iterator it = constraints.iterator();
        while (it.hasNext()) {
            int b;
            final Constraint k = (Constraint)it.next();
            k.simplify();
            final int soft = k.k0.weakMarkedSize();
            int n = k.k0.size();
            for (b = soft; b < n; ++b) {
                binders.add(k.getElement(b));
            }
            try {
                k.k0.implementsIter(new K0.ImplementsIterator(){

                    protected void iter(int x, int iid) {
                        if (x < soft) {
                            return;
                        }
                        TypeConstructor tc = (TypeConstructor)k.getElement(x);
                        atoms.add(new ImplementsCst(tc, ((Variance)tc.variance).getInterface(iid)));
                    }
                });
                for (b = soft; b < n; ++b) {
                    for (int i = 0; i < n; ++i) {
                        Engine.addIfLeq(b, i, k, atoms);
                    }
                }
                for (int i = 0; i < soft; ++i) {
                    for (int b2 = soft; b2 < n; ++b2) {
                        Engine.addIfLeq(i, b2, k, atoms);
                    }
                }
            }
            catch (Unsatisfiable ex) {
            }
        }
    }

    private static void addIfLeq(int i1, int i2, Constraint k, List atoms) {
        if (k.k0.wasEntered(i1, i2)) {
            atoms.add(k == variablesConstraint ? new MonotypeLeqCst((MonotypeVar)k.getElement(i1), (MonotypeVar)k.getElement(i2)) : new TypeConstructorLeqCst((TypeConstructor)k.getElement(i1), (TypeConstructor)k.getElement(i2)));
        }
    }

    public static Element canonify(Element e) {
        Kind kind = e.getKind();
        if (kind == null) {
            return e;
        }
        Constraint k = Engine.getConstraint(kind);
        if (k == null) {
            throw new InternalError("null constraint for " + e);
        }
        return k.getElement(e.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setKind(Element element, Kind k) throws Unsatisfiable {
        boolean toTop = k == TopMonotype.TopKind.instance;
        Stack<Element> s = new Stack<Element>();
        s.push(element);
        while (!s.empty()) {
            Element e = (Element)s.pop();
            if (e.getKind() != null) {
                if (e.getKind() == k) continue;
                throw new LowlevelUnsatisfiable("Bad Kinding for " + e + ":\nhad: " + e.getKind() + "\nnew: " + k);
            }
            if (e.isExistential()) {
                formerFree.add(e);
            }
            k.register(e);
            e.setKind(k);
            floating.remove(e);
            if (e.getId() == -3) {
                soft.add(e);
            }
            try {
                Iterator i = frozenLeqs.iterator();
                while (i.hasNext()) {
                    Leq leq = (Leq)i.next();
                    if (leq.e1 == e) {
                        if (leq.e2.getKind() == null) {
                            s.push(leq.e2);
                            continue;
                        }
                        if (leq.e1.getKind() != leq.e2.getKind()) {
                            throw new InternalError("Bad kinding in Engine.setKind 1");
                        }
                        i.remove();
                        k.leq(leq.e1, leq.e2, initialContext);
                        continue;
                    }
                    if (leq.e2 != e) continue;
                    if (toTop) {
                        i.remove();
                        continue;
                    }
                    if (leq.e1.getKind() == null) {
                        s.push(leq.e1);
                        continue;
                    }
                    if (leq.e1.getKind() != leq.e2.getKind()) {
                        throw new InternalError("Bad kinding in Engine.setKind 2");
                    }
                    i.remove();
                    k.leq(leq.e1, leq.e2, initialContext);
                }
            }
            finally {
                frozenLeqs.endOfIteration();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceKind(Element element, Kind k) throws Unsatisfiable {
        Stack<Element> s = new Stack<Element>();
        s.push(element);
        while (!s.empty()) {
            Element e = (Element)s.pop();
            e.setKind(k);
            k.register(e);
            floating.remove(e);
            try {
                Iterator i = frozenLeqs.iterator();
                while (i.hasNext()) {
                    Leq leq = (Leq)i.next();
                    if (leq.e1 == e) {
                        if (leq.e2.getKind() == null) {
                            s.push(leq.e2);
                            continue;
                        }
                        i.remove();
                        k.leq(leq.e1, leq.e2);
                        continue;
                    }
                    if (leq.e2 != e) continue;
                    if (leq.e1.getKind() == null) {
                        s.push(leq.e1);
                        continue;
                    }
                    i.remove();
                    k.leq(leq.e1, leq.e2);
                }
            }
            finally {
                frozenLeqs.endOfIteration();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertFrozens() throws Unsatisfiable {
        Element e2;
        Element e1;
        Leq leq;
        Iterator i;
        boolean more;
        try {
            Iterator i2 = soft.iterator();
            while (i2.hasNext()) {
                Element e = (Element)i2.next();
                e.setId(-4);
            }
        }
        finally {
            soft.endOfIteration();
        }
        soft.clear();
        do {
            more = false;
            try {
                i = frozenLeqs.iterator();
                while (i.hasNext()) {
                    leq = (Leq)i.next();
                    e1 = leq.e1;
                    e2 = leq.e2;
                    if ((!e1.isExistential() || e2.isExistential()) && (!e2.isExistential() || e1.isExistential())) continue;
                    more = true;
                    if (e1.isExistential()) {
                        ((MonotypeVar)e2).setExistential();
                        continue;
                    }
                    if (!e2.isExistential()) continue;
                    ((MonotypeVar)e1).setExistential();
                }
            }
            finally {
                frozenLeqs.endOfIteration();
            }
        } while (more);
        try {
            i = floating.iterator();
            while (i.hasNext()) {
                Element e = (Element)i.next();
                if (e.getKind() != null || e.isExistential()) continue;
                if (dbg) {
                    Debug.println("Registering variable " + e);
                }
                e.setKind(variablesConstraint);
                variablesConstraint.register(e);
                i.remove();
            }
        }
        finally {
            floating.endOfIteration();
        }
        try {
            i = frozenLeqs.iterator();
            while (i.hasNext()) {
                leq = (Leq)i.next();
                e1 = leq.e1;
                e2 = leq.e2;
                if (e1.isExistential()) continue;
                variablesConstraint.leq(leq.e1, leq.e2, initialContext);
                i.remove();
            }
        }
        finally {
            frozenLeqs.endOfIteration();
        }
    }

    public static Constraint getConstraint(Kind kind) {
        if (kind instanceof Constraint) {
            return (Constraint)kind;
        }
        Constraint res = (Constraint)kindsMap.get(kind);
        if (res != null) {
            return res;
        }
        if (dbg) {
            Debug.println("Creating new Lowlevel constraint for " + kind);
        }
        res = new Constraint("kind " + kind.toString());
        res.associatedKind = kind;
        if (!initialContext) {
            try {
                if (dbg) {
                    Debug.println("createInitialContext() and mark() called for new constraint");
                }
                res.createInitialContext();
                res.mark();
            }
            catch (Unsatisfiable e) {
                throw new InternalError("This shouldn't happen, Engine.Constraint is empty here !");
            }
        }
        constraints.add(res);
        kindsMap.put(kind, res);
        return res;
    }

    public static Iterator listConstraints() {
        return constraints.iterator();
    }

    public static void reset() {
        kindsMap = new HashMap();
        variablesConstraint = new Constraint("type variables", true);
        constraints = new ArrayList(10);
        constraints.add(variablesConstraint);
        initialContext = true;
    }

    public static void createInitialContext() throws Unsatisfiable {
        Iterator i = constraints.iterator();
        while (i.hasNext()) {
            Constraint k = (Constraint)i.next();
            k.createInitialContext();
        }
        initialContext = false;
    }

    public static void releaseInitialContext() {
        Iterator i = constraints.iterator();
        while (i.hasNext()) {
            Constraint k = (Constraint)i.next();
            k.releaseInitialContext();
        }
        initialContext = true;
    }

    public static boolean isInRigidContext() {
        return !initialContext;
    }

    static {
        LowlevelUnsatisfiable.refinedReports = false;
        existentialLevel = 0;
        frozenLeqs = new BackableList();
        floating = new BackableList();
        soft = new BackableList();
        formerFree = new BackableList();
        initialContext = true;
    }

    public static final class Constraint
    implements Kind {
        private String name;
        private boolean variables = false;
        final K0 k0 = new K0(1, new Callbacks());
        private Vector elements = new Vector(10);
        private BitVector concreteElements = new BitVector();
        public Kind associatedKind;

        Constraint(String name) {
            this.name = name;
        }

        Constraint(String name, boolean variables) {
            this(name);
            this.variables = variables;
        }

        public Monotype freshMonotype(boolean existential) {
            return null;
        }

        public boolean hasConstants() {
            return !this.variables;
        }

        public final void register(Element e) {
            int id = this.k0.extend();
            e.setId(id);
            if (id >= this.elements.size()) {
                this.elements.setSize(id + 1);
            }
            this.elements.set(id, e);
            if (e.isConcrete()) {
                this.concreteElements.set(id);
            }
            if (dbg) {
                Debug.println(e + " has id " + e.getId());
            }
        }

        public Element getElement(int index) {
            return (Element)this.elements.get(index);
        }

        void tag(Element e, int variance) {
            this.k0.tag(e.getId(), variance);
        }

        public String toString() {
            return "Constraint " + this.name + " for " + this.associatedKind + ":\n" + this.k0.toString();
        }

        public final boolean isValid(Element e) {
            int id = e.getId();
            return id >= 0 && id < this.k0.size();
        }

        public final void leq(Element e1, Element e2) throws Unsatisfiable {
            this.leq(e1, e2, false);
        }

        public final void leq(Element e1, Element e2, boolean initial) throws Unsatisfiable {
            if (dbg) {
                Debug.println(e1 + " <: " + e2 + " (" + e1.getId() + " <: " + e2.getId() + ")");
                if (e1.getId() < 0 || e1.getId() >= this.k0.size()) {
                    Debug.println(e1 + " has invalid index");
                    Internal.printStackTrace();
                }
                if (e2.getId() < 0 || e2.getId() >= this.k0.size()) {
                    Debug.println(e2 + " has invalid index");
                    Internal.printStackTrace();
                }
            }
            if (initial) {
                this.k0.initialLeq(e1.getId(), e2.getId());
            } else {
                this.k0.leq(e1.getId(), e2.getId());
            }
        }

        public final void assertMinimal(Element e) {
            if (dbg) {
                Debug.println("Minimal: " + e);
            }
            this.k0.minimal(e.getId());
        }

        public final boolean isMinimal(Element e) {
            return this.k0.isMinimal(e.getId());
        }

        public Element lowestInstance(Element e) {
            int elem;
            int id = e.getId();
            int res = -1;
            for (elem = 0; elem < this.k0.initialContextSize(); ++elem) {
                if (!this.k0.wasEntered(id, elem) || res != -1 && !this.k0.isLeq(elem, res)) continue;
                res = elem;
            }
            if (res == -1) {
                for (elem = 0; elem < this.k0.initialContextSize(); ++elem) {
                    if (!this.k0.wasEntered(elem, id) || res != -1 && !this.k0.isLeq(res, elem)) continue;
                    res = elem;
                }
            }
            if (res != -1) {
                boolean[] ok = new boolean[]{true};
                int candidate = res;
                try {
                    this.k0.ineqIter(new K0.IneqIterator(this, id, ok, candidate){
                        private final /* synthetic */ int val$id;
                        private final /* synthetic */ boolean[] val$ok;
                        private final /* synthetic */ int val$candidate;
                        private final /* synthetic */ Constraint this$0;
                        {
                            this.this$0 = this$0;
                            this.val$id = val$id;
                            this.val$ok = val$ok;
                            this.val$candidate = val$candidate;
                        }

                        protected void iter(int x1, int x2) {
                            if (x1 == this.val$id) {
                                this.val$ok[0] = this.val$ok[0] & this.this$0.k0.isLeq(this.val$candidate, x2);
                            } else if (x2 == this.val$id) {
                                this.val$ok[0] = this.val$ok[0] & this.this$0.k0.isLeq(x1, this.val$candidate);
                            }
                        }
                    });
                }
                catch (Unsatisfiable ex) {
                    throw new Error("assert false");
                }
                if (!ok[0]) {
                    res = -1;
                }
            }
            if (res == -1) {
                return null;
            }
            return this.getElement(res);
        }

        void mark() {
            this.k0.mark();
        }

        void backtrack(boolean ignore) {
            this.k0.backtrack(ignore);
        }

        void startSimplify() {
            this.k0.startSimplify();
        }

        void simplify() {
            this.k0.simplify();
        }

        void stopSimplify() {
            this.k0.stopSimplify();
        }

        void satisfy() throws Unsatisfiable {
            this.k0.satisfy();
        }

        void rigidify() {
            this.k0.rigidify();
        }

        boolean isRigid(Element e) {
            return this.k0.isRigid(e.getId());
        }

        void createInitialContext() throws Unsatisfiable {
            this.k0.createInitialContext();
        }

        void releaseInitialContext() {
            this.k0.releaseInitialContext();
        }

        public int newInterface() {
            return this.k0.newInterface();
        }

        public void subInterface(int i1, int i2) {
            this.k0.subInterface(i1, i2);
        }

        public void initialImplements(int x, int iid) {
            this.k0.initialImplements(x, iid);
        }

        public void initialAbstracts(int x, int iid) {
            this.k0.initialAbstracts(x, iid);
        }

        public void indexImplements(int x, int iid) throws Unsatisfiable {
            this.k0.indexImplements(x, iid);
        }

        public void enumerate(BitVector observers, LowlevelSolutionHandler handler) {
            this.k0.enumerate(observers, handler);
        }

        public void reduceDomainToConcrete(Element e) throws Unsatisfiable {
            this.k0.reduceDomain(e.getId(), false, this.concreteElements);
        }

        public boolean isLeq(Element e1, Element e2) {
            return this.k0.isLeq(e1.getId(), e2.getId());
        }

        class Callbacks
        extends K0.Callbacks {
            Callbacks() {
            }

            protected void indexMerged(int src, int dest) {
                if (dbg) {
                    Debug.println("Merged " + this.indexToString(src) + " into " + this.indexToString(dest));
                }
                Constraint.this.getElement(src).setId(dest);
            }

            protected void indexMoved(int src, int dest) {
                if (dbg) {
                    Debug.println("Changed index of " + this.indexToString(src));
                }
                Element movedElement = Constraint.this.getElement(src);
                movedElement.setId(dest);
                Constraint.this.elements.set(dest, movedElement);
            }

            protected void indexDiscarded(int index) {
                if (dbg) {
                    Debug.println("Discarded " + this.indexToString(index));
                }
                Constraint.this.getElement(index).setId(-2);
                Constraint.this.elements.set(index, null);
            }

            protected String getName() {
                return Constraint.this.name;
            }

            protected String indexToString(int x) {
                if (x == Integer.MIN_VALUE) {
                    return "[NONE]";
                }
                if (x == -1) {
                    return "[BOTTOM]";
                }
                return String.valueOf(Constraint.this.getElement(x)) + "[" + x + "]";
            }

            protected String interfaceToString(int iid) {
                return "" + ((Variance)Constraint.this.associatedKind).getInterface(iid);
            }
        }
    }

    private static class Leq {
        Element e1;
        Element e2;

        Leq(Element e1, Element e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        public String toString() {
            return this.e1 + " <: " + this.e2;
        }
    }
}

