/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.PositionContainer;
import gnu.lists.Sequence;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class SeqPosition
implements ListIterator,
PositionContainer,
Enumeration {
    public AbstractSequence sequence;
    public int ipos;
    public Object xpos;

    public SeqPosition() {
    }

    public SeqPosition(AbstractSequence seq) {
        this.sequence = seq;
    }

    public SeqPosition(AbstractSequence seq, int offset, boolean isAfter) {
        this.sequence = seq;
        seq.makePosition(offset, isAfter, this, 0);
    }

    public SeqPosition(AbstractSequence seq, int ipos, Object xpos) {
        this.sequence = seq;
        this.ipos = ipos;
        this.xpos = xpos;
    }

    public static SeqPosition make(AbstractSequence seq, int ipos, Object xpos) {
        SeqPosition pos = new SeqPosition();
        seq.copyPosition(ipos, xpos, pos, 0);
        return pos;
    }

    public final void gotoStart(AbstractSequence seq) {
        if (this.sequence != null) {
            this.sequence.releasePosition(this.ipos, this.xpos);
        }
        this.sequence = seq;
        seq.makeStartPosition(this, 0);
    }

    public final void gotoEnd(AbstractSequence seq) {
        if (this.sequence != null) {
            this.sequence.releasePosition(this.ipos, this.xpos);
        }
        this.sequence = seq;
        seq.makeEndPosition(this, 0);
    }

    public boolean hasMoreElements() {
        return this.sequence.hasNext(this.ipos, this.xpos);
    }

    public boolean hasNext() {
        return this.sequence.hasNext(this.ipos, this.xpos);
    }

    public int getNextKind() {
        return this.sequence.getNextKind(this.ipos, this.xpos);
    }

    public String getNextTypeName() {
        return this.sequence.getNextTypeName(this.ipos, this.xpos);
    }

    public Object getNextTypeObject() {
        return this.sequence.getNextTypeObject(this.ipos, this.xpos);
    }

    public boolean hasPrevious() {
        return this.sequence.hasPrevious(this.ipos, this.xpos);
    }

    public Object next() {
        Object result = this.sequence.getNext(this.ipos, this.xpos);
        if (result == Sequence.eofValue || !this.sequence.gotoNext(this)) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public final boolean gotoNext() {
        return this.sequence.gotoNext(this);
    }

    public Object previous() {
        Object result = this.sequence.getPrevious(this.ipos, this.xpos);
        if (result == Sequence.eofValue || !this.sequence.gotoPrevious(this, 0)) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public Object nextElement() throws NoSuchElementException {
        Object result = this.sequence.getNext(this.ipos, this.xpos);
        if (result == Sequence.eofValue || !this.sequence.gotoNext(this)) {
            throw new NoSuchElementException();
        }
        return result;
    }

    public Object getNext() {
        return this.sequence.getNext(this.ipos, this.xpos);
    }

    public Object getPrevious() {
        return this.sequence.getPrevious(this.ipos, this.xpos);
    }

    public final int nextIndex() {
        return this.sequence.nextIndex(this.ipos, this.xpos);
    }

    public final int fromEndIndex() {
        return this.sequence.fromEndIndex(this.ipos, this.xpos);
    }

    public int getContainingSequenceSize() {
        return this.sequence.getContainingSequenceSize(this.ipos, this.xpos);
    }

    public final int previousIndex() {
        return this.sequence.nextIndex(this.ipos, this.xpos) - 1;
    }

    public final boolean isAfter() {
        return this.sequence.isAfter(this.ipos, this.xpos);
    }

    public final void set(Object value) {
        if (this.sequence.isAfter(this.ipos, this.xpos)) {
            this.sequence.setPrevious(this.ipos, this.xpos, value);
        } else {
            this.sequence.setNext(this.ipos, this.xpos, value);
        }
    }

    public void remove() {
        this.sequence.remove(this.ipos, this.xpos, this.isAfter() ? -1 : 1);
    }

    public void add(Object o) {
        this.sequence.add(this, 0, o);
    }

    public int getPositionInt(int positionNumber) {
        return this.ipos;
    }

    public Object getPositionPtr(int positionNumber) {
        return this.xpos;
    }

    public void setPosition(int positionNumber, int ipos, Object xpos) {
        this.ipos = ipos;
        this.xpos = xpos;
    }

    public void setSequence(int positionNumber, AbstractSequence seq) {
        this.sequence = seq;
    }

    public int countPositions() {
        return 1;
    }

    public void init(AbstractSequence seq, int index, boolean isAfter) {
        if (this.sequence != null) {
            this.sequence.releasePosition(this.ipos, this.xpos);
        }
        this.sequence = seq;
        seq.makePosition(index, isAfter, this, 0);
    }

    public void init(SeqPosition pos) {
        if (this.sequence != null) {
            this.sequence.releasePosition(this.ipos, this.xpos);
        }
        this.sequence = pos.sequence;
        this.sequence.copyPosition(pos.ipos, pos.xpos, this, 0);
    }

    public void release() {
        if (this.sequence != null) {
            this.sequence.releasePosition(this.ipos, this.xpos);
            this.sequence = null;
        }
    }

    public void finalize() {
        this.release();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(60);
        sbuf.append('{');
        if (this.sequence == null) {
            sbuf.append("null sequence");
        } else {
            sbuf.append(this.sequence.getClass().getName());
            sbuf.append('@');
            sbuf.append(System.identityHashCode(this.sequence));
        }
        sbuf.append(" ipos: ");
        sbuf.append(this.ipos);
        sbuf.append(" xpos: ");
        sbuf.append(this.xpos);
        sbuf.append('}');
        return sbuf.toString();
    }
}

