/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.AbstractMethodFilter;
import gnu.expr.ClassInitializer;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Initializer;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ObjectExp;
import gnu.expr.PairClassType;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;
import gnu.mapping.OutPort;
import java.util.Vector;

public class ClassExp
extends LambdaExp {
    public boolean needsConstructor;
    boolean simple;
    int accessFlags;
    ClassType instanceType;
    boolean makeClassPair;
    public Expression[] supers;
    public LambdaExp initMethod;
    boolean partsDeclared;
    private Field assertionEnabledField;
    static final ClassType javaClass = ClassType.make("java.lang.Class");
    static final ClassType noSuchMethod = ClassType.make("java.lang.NoSuchMethodError");
    static final Method forName = javaClass.getDeclaredMethod("forName", 1);
    static final Method desiredAssertionStatus = javaClass.addMethod("desiredAssertionStatus", 1, new Type[0], Type.boolean_type);
    static final Method getProperty = ClassType.make("java.lang.System").getDeclaredMethod("getProperty", 1);

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple(boolean value) {
        this.simple = value;
    }

    public void setAccessFlags(int value) {
        this.accessFlags = value;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public void setMakingClassPair(boolean val) {
        this.makeClassPair = val;
    }

    public boolean isMakingClassPair() {
        return this.makeClassPair;
    }

    public ClassExp() {
        this.type = null;
        this.setCanRead(true);
    }

    public ClassExp(ClassType type) {
        this();
        this.type = this.instanceType = type;
    }

    public Declaration addField(String name, Type type) {
        Declaration res = this.addDeclaration(name, type);
        res.setSimple(false);
        res.setFlag(4096);
        res.setCanRead(true);
        res.setCanWrite(true);
        res.noteValue(null);
        if (this.instanceType != null) {
            res.field = this.instanceType.getDeclaredField(name);
        }
        return res;
    }

    public ReferenceExp addMethod(LambdaExp method, boolean isPrivate) {
        Method m;
        Declaration decl = new Declaration(method.getName());
        decl.noteValue(method);
        decl.setFlag(18432);
        decl.setProcedureDecl(true);
        if (isPrivate) {
            decl.setSpecifiedPrivate(true);
        }
        method.nameDecl.context = this;
        method.nextSibling = this.firstChild;
        this.firstChild = method;
        if (this.instanceType != null && (m = this.instanceType.getDeclaredMethod(method.getName(), method.getArgTypes())) != null && !m.isConstructor()) {
            m.eraseCode();
            method.declareThis(this.instanceType);
            method.primMethods = new Method[]{m};
        }
        return new ReferenceExp(decl);
    }

    public ReferenceExp addMethod(LambdaExp method) {
        return this.addMethod(method, false);
    }

    public void compile(Compilation comp, Target target) {
        int nargs;
        ClassType typeType;
        if (target instanceof IgnoreTarget) {
            return;
        }
        ClassType new_class = this.compile(comp);
        String className = new_class.getName();
        ClassType typeClass = ClassType.make("java.lang.Class");
        Method forNameClassMethod = typeClass.addMethod("forName", Compilation.string1Arg, typeClass, 9);
        CodeAttr code = comp.getCode();
        code.emitPushString(className);
        code.emitInvokeStatic(forNameClassMethod);
        boolean needsLink = this.getNeedsClosureEnv();
        if (this.isMakingClassPair() || needsLink) {
            code.emitPushString(this.instanceType.getName());
            code.emitInvokeStatic(forNameClassMethod);
            typeType = ClassType.make("gnu.expr.PairClassType");
            nargs = needsLink ? 3 : 2;
        } else {
            typeType = ClassType.make("gnu.bytecode.Type");
            nargs = 1;
        }
        Type[] argsClass = new Type[nargs];
        if (needsLink) {
            comp.curLambda.loadHeapFrame(comp);
            argsClass[--nargs] = Type.pointer_type;
        }
        while (--nargs >= 0) {
            argsClass[nargs] = typeClass;
        }
        Method makeMethod = typeType.addMethod("make", argsClass, typeType, 9);
        code.emitInvokeStatic(makeMethod);
        target.compileFromStack(comp, typeType);
    }

    public String getJavaName() {
        return this.name == null ? "object" : Compilation.mangleNameIfNeeded(this.name);
    }

    public ClassType getCompiledClassType(Compilation comp) {
        if (!this.partsDeclared) {
            this.getType();
            this.declareParts(comp);
        }
        if (this.type.getName() == null) {
            String name = this.getName();
            if (name == null) {
                name = "object";
            } else {
                int nlen = name.length();
                if (nlen > 2 && name.charAt(0) == '<' && name.charAt(nlen - 1) == '>') {
                    name = name.substring(1, nlen - 1);
                }
            }
            if (!this.isSimple() || this instanceof ObjectExp) {
                name = comp.generateClassName(name);
            } else if (name.indexOf(46) == -1) {
                name = Compilation.mangleNameIfNeeded(name);
            }
            this.type.setName(name);
        }
        if (this.filename != null) {
            this.type.setSourceFile(this.filename);
        }
        if (!this.isInterface()) {
            comp.generateConstructor(this.getClassType(), this);
        }
        return this.type;
    }

    public void recomputeInterfaces() {
        this.setTypes();
    }

    private void setTypes() {
        int len = this.supers == null ? 0 : this.supers.length;
        ClassType[] superTypes = new ClassType[len];
        ClassType superType = null;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            Type st = Interpreter.getInterpreter().getTypeFor(this.supers[i]);
            if (st == null || !(st instanceof ClassType)) {
                throw new Error("invalid super type");
            }
            ClassType t = (ClassType)st;
            if ((t.getModifiers() & 0x200) == 0) {
                if (j < i) {
                    throw new Error("duplicate superclass");
                }
                superType = t;
                continue;
            }
            superTypes[j++] = t;
        }
        if (this.type == null) {
            if (superType == null) {
                if (!this.isSimple()) {
                    PairClassType ptype = new PairClassType();
                    this.type = ptype;
                    this.setMakingClassPair(true);
                    this.instanceType = new ClassType();
                    this.type.setInterface(true);
                    ClassType[] interfaces = new ClassType[]{this.type};
                    this.instanceType.setSuper(Type.pointer_type);
                    this.instanceType.setInterfaces(interfaces);
                    ptype.instanceType = this.instanceType;
                } else {
                    this.instanceType = this.type = new ClassType(this.getName());
                }
                this.type.setSuper(Type.pointer_type);
            } else {
                this.instanceType = this.type = new ClassType(this.getName());
                this.type.setSuper(superType);
            }
            this.instanceType.collectable = true;
            if (!this.isInterface()) {
                this.accessFlags |= 0x20;
            }
            this.instanceType.setModifiers(this.accessFlags);
        }
        if (j > 0) {
            ClassType[] interfaces;
            if (j == len) {
                interfaces = superTypes;
            } else {
                interfaces = new ClassType[j];
                System.arraycopy(superTypes, 0, interfaces, 0, j);
            }
            this.type.setInterfaces(interfaces);
        }
    }

    public Type getType() {
        if (this.type == null) {
            this.setTypes();
        }
        return this.type;
    }

    public ClassType getClassType() {
        return (ClassType)this.getType();
    }

    public void declareParts(Compilation comp) {
        if (this.partsDeclared) {
            return;
        }
        this.partsDeclared = true;
        comp.topLambda = this;
        comp.topClass = this.type;
        for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (!decl.getCanRead() || decl.field != null) continue;
            int flags = 0;
            flags = decl.isSpecifiedPrivate() ? (flags |= 2) : (flags |= 1);
            if (decl.getFlag(2048)) {
                flags |= 8;
            }
            if (this.isMakingClassPair()) {
                Type ftype = decl.getType().getImplementationType();
                this.type.addMethod(ClassExp.slotToMethodName("get", decl.getName()), flags |= 0x400, Type.typeArray0, ftype);
                Type[] stypes = new Type[]{ftype};
                this.type.addMethod(ClassExp.slotToMethodName("set", decl.getName()), flags, stypes, Type.void_type);
                continue;
            }
            if (decl.getFlag(524288)) {
                flags |= 0x80;
            }
            if (decl.getFlag(0x100000)) {
                flags |= 0x40;
            }
            if (decl.getFlag(16384)) {
                flags |= 0x10;
            }
            String fname = Compilation.mangleNameIfNeeded(decl.getName());
            decl.field = this.instanceType.addField(fname, decl.getType(), flags);
            decl.setSimple(false);
        }
        LambdaExp child = this.firstChild;
        while (child != null) {
            if (child.primMethods == null) {
                if (child != this.initMethod || !this.isMakingClassPair()) {
                    child.addMethodFor(this.type, null, null);
                }
                if (this.isMakingClassPair()) {
                    child.addMethodFor(this.instanceType, null, this.type);
                }
            }
            child = child.nextSibling;
        }
        this.addAttributes(this.instanceType);
    }

    static void getImplMethods(ClassType interfaceType, String mname, Type[] paramTypes, Vector vec) {
        ClassType implType;
        if (interfaceType instanceof PairClassType) {
            implType = ((PairClassType)interfaceType).instanceType;
        } else {
            if (!interfaceType.isInterface()) {
                return;
            }
            String implTypeName = interfaceType.getName() + "$class";
            implType = ClassType.make(implTypeName);
        }
        Type[] itypes = new Type[paramTypes.length + 1];
        itypes[0] = interfaceType;
        System.arraycopy(paramTypes, 0, itypes, 1, paramTypes.length);
        Method implMethod = implType.getDeclaredMethod(mname, itypes);
        if (implMethod != null) {
            int count = vec.size();
            if (count == 0 || !vec.elementAt(count - 1).equals(implMethod)) {
                vec.addElement(implMethod);
            }
        } else {
            ClassType[] superInterfaces = interfaceType.getInterfaces();
            for (int i = 0; i < superInterfaces.length; ++i) {
                ClassExp.getImplMethods(superInterfaces[i], mname, paramTypes, vec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassType compile(Compilation comp) {
        ClassType saveClass = comp.curClass;
        Method saveMethod = comp.method;
        try {
            ClassType new_class;
            comp.curClass = new_class = this.getCompiledClassType(comp);
            String filename = this.getFile();
            if (filename != null) {
                new_class.setSourceFile(filename);
            }
            LambdaExp saveLambda = comp.curLambda;
            comp.curLambda = this;
            this.allocFrame(comp);
            if (this.getNeedsStaticLink()) {
                Variable parentFrame;
                Variable variable = parentFrame = saveLambda.heapFrame != null ? saveLambda.heapFrame : saveLambda.closureEnv;
                if (parentFrame != null) {
                    this.closureEnvField = this.staticLinkField = this.instanceType.addField("this$0", parentFrame.getType());
                }
            }
            comp.generateConstructor(this.instanceType, this);
            LambdaExp child = this.firstChild;
            while (child != null) {
                Method save_method = comp.method;
                LambdaExp save_lambda = comp.curLambda;
                comp.method = child.getMainMethod();
                child.declareThis(comp.curClass);
                comp.curClass = this.instanceType;
                comp.curLambda = child;
                comp.method.initCode();
                child.allocChildClasses(comp);
                child.allocParameters(comp);
                child.enterFunction(comp);
                child.compileBody(comp);
                child.compileEnd(comp);
                child.compileChildMethods(comp);
                comp.method = save_method;
                comp.curClass = new_class;
                comp.curLambda = save_lambda;
                child = child.nextSibling;
            }
            Method[] methods = this.type.getMethods((Filter)AbstractMethodFilter.instance, 2);
            for (int i = 0; i < methods.length; ++i) {
                CodeAttr code;
                char ch;
                Method meth = methods[i];
                String mname = meth.getName();
                Type[] ptypes = meth.getParameterTypes();
                Type rtype = meth.getReturnType();
                Method mimpl = this.instanceType.getMethod(mname, ptypes);
                if (mimpl != null && !mimpl.isAbstract()) continue;
                if (mname.length() > 3 && mname.charAt(2) == 't' && mname.charAt(1) == 'e' && ((ch = mname.charAt(0)) == 'g' || ch == 's')) {
                    Type ftype;
                    if (ch == 's' && rtype.isVoid() && ptypes.length == 1) {
                        ftype = ptypes[0];
                    } else {
                        if (ch != 'g' || ptypes.length != 0) continue;
                        ftype = rtype;
                    }
                    String fname = Character.toLowerCase(mname.charAt(3)) + mname.substring(4);
                    Field fld = this.instanceType.getField(fname);
                    if (fld == null) {
                        fld = this.instanceType.addField(fname, ftype, 1);
                    }
                    Method impl = this.instanceType.addMethod(mname, 1, ptypes, rtype);
                    impl.init_param_slots();
                    code = impl.getCode();
                    code.emitPushThis();
                    if (ch == 'g') {
                        code.emitGetField(fld);
                    } else {
                        code.emitLoad(code.getArg(1));
                        code.emitPutField(fld);
                    }
                    code.emitReturn();
                    continue;
                }
                Vector vec = new Vector();
                ClassExp.getImplMethods(this.type, mname, ptypes, vec);
                if (vec.size() != 1) {
                    String msg = vec.size() == 0 ? "missing implementation for " : "ambiguous implementation for ";
                    comp.error('e', msg + meth);
                    continue;
                }
                Method impl = this.instanceType.addMethod(mname, 1, ptypes, rtype);
                impl.init_param_slots();
                code = impl.getCode();
                for (Variable var = code.getCurrentScope().firstVar(); var != null; var = var.nextVar()) {
                    code.emitLoad(var);
                }
                Method imethod = (Method)vec.elementAt(0);
                code.emitInvokeStatic(imethod);
                code.emitReturn();
            }
            comp.curLambda = saveLambda;
            ClassType classType = new_class;
            return classType;
        }
        finally {
            comp.curClass = saveClass;
            comp.method = saveMethod;
        }
    }

    public final Expression instantiate() {
        return new QuoteExp(new PrimProcedure(this.getDefaultConstructor()));
    }

    private Method getDefaultConstructor() {
        ClassType clas = this.getClassType();
        return Compilation.getConstructor(clas, this);
    }

    void compileChildMethods(Compilation comp) {
        ClassType save_class = comp.curClass;
        comp.curClass = this.type;
        super.compileChildMethods(comp);
        this.setFieldValues(comp);
        comp.curClass = save_class;
    }

    private void setFieldValues(Compilation comp) {
        for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (decl.field == null) continue;
            decl.setFieldValue(comp);
        }
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkClassExp(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void walkChildren(ExpWalker walker) {
        LambdaExp save = walker.currentLambda;
        walker.currentLambda = this;
        try {
            LambdaExp child = this.firstChild;
            while (child != null && walker.exitValue == null) {
                walker.walkLambdaExp(child);
                child = child.nextSibling;
            }
            for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
                if (!decl.isStatic() || decl.value == null) continue;
                decl.value.walk(walker);
            }
        }
        finally {
            walker.currentLambda = save;
        }
    }

    public void print(OutPort out) {
        out.startLogicalBlock("(" + this.getExpClassName() + "/", ")", 2);
        if (this.name != null) {
            out.print(this.name);
            out.print('/');
        }
        out.print(this.id);
        out.print("/ (");
        Object prevMode = null;
        int i = 0;
        boolean opt_i = false;
        int key_args = this.keywords == null ? 0 : this.keywords.length;
        int opt_args = this.defaultArgs == null ? 0 : this.defaultArgs.length - key_args;
        for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (i > 0) {
                out.print(' ');
            }
            out.print(decl);
            ++i;
        }
        out.print(") ");
        LambdaExp child = this.firstChild;
        while (child != null) {
            out.writeSpaceLinear();
            out.print(" method: ");
            child.print(out);
            child = child.nextSibling;
        }
        out.writeSpaceLinear();
        if (this.body == null) {
            out.print("<null body>");
        } else {
            this.body.print(out);
        }
        out.endLogicalBlock(")");
    }

    public Field compileSetField(Compilation comp) {
        return new ClassInitializer((ClassExp)this, (Compilation)comp).field;
    }

    public static String slotToMethodName(String prefix, String sname) {
        StringBuffer sbuf = new StringBuffer(sname.length() + 3);
        sbuf.append(prefix);
        sbuf.append(Character.toTitleCase(sname.charAt(0)));
        sbuf.append(sname.substring(1));
        return sbuf.toString();
    }

    public Field getAssertionEnabledField() {
        if (this.assertionEnabledField == null) {
            this.assertionEnabledField = ((ClassType)this.getType()).addField("$assertionsEnabled", Type.boolean_type, 24);
            this.addClassInitializer(new Initializer(){
                {
                    this.field = ClassExp.this.assertionEnabledField;
                }

                public void emit(Compilation comp) {
                    CodeAttr code = comp.getCode();
                    code.emitTryStart(false, Type.boolean_type);
                    code.emitPushString(ClassExp.this.getName());
                    code.emitInvokeStatic(forName);
                    code.emitInvokeVirtual(desiredAssertionStatus);
                    code.emitTryEnd();
                    Variable catchVar = new Variable("e", noSuchMethod);
                    catchVar.allocateLocal(code);
                    code.emitCatchStart(catchVar);
                    code.emitPushString("assertions");
                    code.emitInvokeStatic(getProperty);
                    code.emitIfNull();
                    code.emitPushBoolean(false);
                    code.emitElse();
                    code.emitPushBoolean(true);
                    code.emitFi();
                    code.emitCatchEnd();
                    code.emitTryCatchEnd();
                    code.emitPutStatic(this.field);
                }
            });
        }
        return this.assertionEnabledField;
    }
}

