/*
 * Decompiled with CFR 0.152.
 */
package bossa.util;

import bossa.parser.Token;
import bossa.util.Located;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import nice.tools.util.System;

public abstract class Location
implements Located {
    private static java.io.File currentFile = null;
    public static final Location option = new Option();
    public static boolean editorMode = false;

    public static Location make(java.io.File file, int startLine, int startColumn, int endLine, int endColumn) {
        return new Source(file, startLine, startColumn, endLine, endColumn);
    }

    public static Location make(java.io.File file, int startLine, int startColumn) {
        return Location.make(file, startLine, startColumn, -1, -1);
    }

    public static Location make(int startLine, int startColumn, int endLine, int endColumn) {
        return Location.make(currentFile, startLine, startColumn, endLine, endColumn);
    }

    public static Location make(Token t) {
        return Location.make(t.beginLine, t.beginColumn, t.endLine, t.endColumn);
    }

    public static Location make(Token start, Token end) {
        return Location.make(start.beginLine, start.beginColumn, end.endLine, end.endColumn);
    }

    public static void setCurrentFile(java.io.File file) {
        currentFile = file;
    }

    public static Location nowhere() {
        return new File(currentFile);
    }

    public Location location() {
        return this;
    }

    public String uniqueIdentifier(String root) {
        StringBuffer uniq = new StringBuffer(super.toString());
        uniq.setCharAt("bossa.util.Location".length(), '_');
        return root + uniq.toString();
    }

    public void write(Expression exp) {
    }

    public void write(Declaration decl) {
    }

    public static Location make(Expression expr) {
        String file = expr.getFile();
        return new Source(file != null ? new java.io.File(file) : null, expr.getLine(), expr.getColumn(), -1, -1);
    }

    public static class Option
    extends Location {
        public String toString() {
            return "Command line";
        }
    }

    public static class Source
    extends File {
        private int startLine;
        private int startColumn;
        private int endLine;
        private int endColumn;

        private Source(java.io.File file, int startLine, int startColumn, int endLine, int endColumn) {
            super(file);
            this.startLine = startLine;
            this.startColumn = startColumn;
            this.endLine = endLine;
            this.endColumn = endColumn;
        }

        public int getLine() {
            return this.startLine;
        }

        public int getColumn() {
            return this.startColumn;
        }

        public String toString() {
            String res = super.toString();
            if (editorMode) {
                return (res.length() > 0 ? res + ":" : "") + this.startLine + ":" + this.startColumn;
            }
            return (res.length() > 0 ? res + ": " : "") + "line " + this.startLine + ", column " + this.startColumn;
        }

        public String uniqueIdentifier(String root) {
            return root + this.startLine + "_" + this.startColumn;
        }

        public void write(Expression exp) {
            super.write(exp);
            exp.setLine(this.getLine(), this.getColumn());
        }

        public void write(Declaration decl) {
            super.write(decl);
            decl.setLine(this.getLine(), this.getColumn());
        }
    }

    public static class File
    extends Location {
        private java.io.File file;

        private File(java.io.File file) {
            this.file = file;
        }

        public java.io.File getFile() {
            return this.file;
        }

        public String toString() {
            if (this.file == null) {
                return "";
            }
            return System.prettyPrint(this.file);
        }

        public void write(Expression exp) {
            if (this.file == null) {
                return;
            }
            exp.setFile(this.file.getName());
        }

        public void write(Declaration decl) {
            if (this.file == null) {
                return;
            }
            decl.setFile(this.file.getName());
        }
    }
}

