/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.LocatedString;
import bossa.syntax.VarSymbol;
import bossa.util.HashMultiTable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class VarScope {
    private VarScope outer;
    private HashMultiTable defs;

    public VarScope(VarScope outer) {
        this.outer = outer;
        this.defs = new HashMultiTable();
    }

    public VarScope(VarScope outer, Collection defs) {
        this(outer);
        this.addSymbols(defs);
    }

    void addSymbol(VarSymbol s) {
        this.defs.put(s.name, s);
    }

    void addSymbols(Collection c) {
        if (c == null) {
            return;
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            VarSymbol s = (VarSymbol)i.next();
            this.addSymbol(s);
        }
    }

    void addSymbols(VarSymbol[] s) {
        if (s == null) {
            return;
        }
        for (int i = 0; i < s.length; ++i) {
            if (s[i].name == null) continue;
            this.addSymbol(s[i]);
        }
    }

    void removeSymbol(VarSymbol sym) {
        this.defs.remove(sym.name, sym);
    }

    public List lookup(LocatedString i) {
        List res = this.defs.getAll(i);
        if (res != null) {
            return res;
        }
        if (this.outer != null) {
            return this.outer.lookup(i);
        }
        return new LinkedList();
    }

    public String toString() {
        return this.defs.elementCount() + ";;\n" + this.outer;
    }
}

