/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.link.Dispatch;
import bossa.syntax.Constraint;
import bossa.syntax.FormalParameters;
import bossa.syntax.JavaClasses;
import bossa.syntax.JavaMethod;
import bossa.syntax.LocatedString;
import bossa.syntax.Monotype;
import bossa.syntax.TypeConstructors;
import bossa.syntax.TypeScope;
import bossa.syntax.VarScope;
import bossa.util.Located;
import bossa.util.User;
import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.Expression;
import gnu.expr.InitializeProc;
import gnu.expr.QuoteExp;
import java.io.PrintWriter;
import java.util.List;
import mlsub.typing.TypeConstructor;
import nice.tools.code.TypeImport;
import nice.tools.code.Types;

public class RetypedJavaMethod
extends JavaMethod {
    LocatedString className;
    private String methodName;
    private List javaTypes;
    private Type javaRetType;
    private Type[] javaArgType;
    boolean ignoredRetyping;

    public RetypedJavaMethod(LocatedString className, String methodName, List javaTypes, LocatedString name, Constraint constraint, Monotype returnType, FormalParameters parameters) {
        super(name, constraint, returnType, parameters);
        this.className = className;
        this.methodName = methodName;
        this.javaTypes = javaTypes;
    }

    void buildScope(VarScope outer, TypeScope typeOuter) {
        this.findReflectMethod();
        super.buildScope(outer, typeOuter);
    }

    boolean isIgnored() {
        return this.ignoredRetyping;
    }

    private Type type(LocatedString s) {
        Type res = Types.type(s);
        if (res == null && !this.ignoredRetyping) {
            this.setIgnoredRetyping(s, "Ignoring retyping because java class " + s + " is not known");
        }
        return res;
    }

    public Type javaReturnType() {
        return this.javaRetType;
    }

    public Type[] javaArgTypes() {
        return this.javaArgType;
    }

    private void findReflectMethod() {
        if (this.reflectMethod != null) {
            return;
        }
        Type holderType = TypeImport.lookup(this.className);
        if (holderType == null) {
            this.setIgnoredRetyping(this, "Ignoring retyping because class " + this.className + " was not found");
            this.javaArgType = new Type[this.javaTypes.size() - 1];
            return;
        }
        if (!(holderType instanceof ClassType)) {
            User.error((Located)this.className, this.className + " is a primitive type");
        }
        ClassType holder = (ClassType)holderType;
        this.className = new LocatedString(holder.getName(), this.className.location());
        this.javaArgType = new Type[this.javaTypes.size() - 1];
        for (int i = 1; i < this.javaTypes.size(); ++i) {
            LocatedString t = (LocatedString)this.javaTypes.get(i);
            this.javaArgType[i - 1] = this.type(t);
            if (this.javaArgType[i - 1] == null) continue;
            this.javaTypes.set(i, new LocatedString(this.javaArgType[i - 1].getName(), t.location()));
        }
        LocatedString retTypeString = (LocatedString)this.javaTypes.get(0);
        this.javaRetType = this.type(retTypeString);
        if (this.ignoredRetyping) {
            return;
        }
        this.javaTypes.set(0, new LocatedString(this.javaRetType.getName(), retTypeString.location()));
        this.reflectMethod = holder.getDeclaredMethod(this.methodName, this.javaArgType);
        if (this.reflectMethod == null) {
            try {
                this.reflectMethod = holder.getDeclaredMethod(this.methodName, this.javaArgType.length);
            }
            catch (Error e) {
                this.setIgnoredRetyping(this, "Ignored retyping because no declaration exist with " + this.javaArgType.length + " arguments");
            }
            if (this.reflectMethod == null) {
                if (this.methodName.equals("<init>")) {
                    this.setIgnoredRetyping(this.className, "Ignored retyping because class " + holder.getName() + " has no constructor with " + this.javaArgType.length + " arguments");
                } else {
                    this.setIgnoredRetyping(this.className, "Ignored retyping because no method named " + this.methodName + " with " + this.javaArgType.length + " arguments was found in class " + holder.getName());
                }
                return;
            }
            this.setIgnoredRetyping(this.className, "Ignored retyping because the types of the arguments don't match the declaration:\n" + this.reflectMethod);
        }
        if (this.reflectMethod.isConstructor()) {
            try {
                TypeConstructor tc = Types.typeConstructor(holder);
                if (tc != null) {
                    TypeConstructors.addConstructor(tc, this);
                    JavaClasses.registerNativeConstructor(this, this.reflectMethod, tc);
                }
            }
            catch (Types.NotIntroducedClassException ex) {}
        } else {
            JavaClasses.registerNativeMethod(this, this.reflectMethod);
        }
        int javaArity = this.reflectMethod.getStaticFlag() || this.reflectMethod.isConstructor() ? this.javaTypes.size() - 1 : this.javaTypes.size();
        if (this.javaTypes != null && javaArity != this.arity) {
            User.error((Located)this, "Native method " + this.getSymbol().name + " has not the same number of parameters " + "in Java (" + javaArity + ") and in Nice (" + this.arity + ")");
        }
    }

    void typedResolve() {
        if (this.ignoredRetyping) {
            return;
        }
        super.typedResolve();
    }

    void setIgnoredRetyping(Located loc, String message) {
        if (!this.inInterfaceFile()) {
            User.warning(loc, message);
        }
        this.ignoredRetyping = true;
        Dispatch.unregister(this);
    }

    Expression getConstructorInvocation(boolean omitDefaults) {
        return new QuoteExp(new InitializeProc(this.reflectMethod));
    }

    public void printInterface(PrintWriter s) {
        if (this.ignoredRetyping) {
            return;
        }
        s.print(super.toString() + " = native " + (this.methodName.equals("<init>") ? "new " + this.className : this.javaTypes.get(0) + " " + this.className + "." + this.methodName) + this.mapJavaArgTypes() + ";\n");
    }

    private String mapJavaArgTypes() {
        if (this.javaArgType == null) {
            return "((NULL))";
        }
        String res = "(";
        for (int n = 0; n < this.javaArgType.length; ++n) {
            if (n != 0) {
                res = res + ", ";
            }
            res = this.javaArgType[n] == null ? res + this.javaTypes.get(n + 1) : res + this.javaArgType[n].getName();
        }
        return res + ")";
    }
}

