/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Arguments;
import bossa.syntax.CallExp;
import bossa.syntax.Expression;
import bossa.syntax.GlobalVarDeclaration;
import bossa.syntax.JavaMethod;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.Node;
import bossa.syntax.SymbolExp;
import bossa.syntax.VarSymbol;
import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.User;
import bossa.util.UserError;
import bossa.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mlsub.typing.Domain;
import mlsub.typing.FunType;
import mlsub.typing.Monotype;
import mlsub.typing.Polytype;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.typing.Types;

public class OverloadedSymbolExp
extends Expression {
    List symbols;
    LocatedString ident;
    private boolean noImplicitThis;

    OverloadedSymbolExp(List symbols, LocatedString ident) {
        if (symbols == null) {
            Internal.error("No symbols");
        }
        this.symbols = symbols;
        this.ident = ident;
        this.setLocation(ident.location());
    }

    private OverloadedSymbolExp(List symbols, LocatedString ident, boolean noImplicitThis) {
        this(symbols, ident);
        this.noImplicitThis = noImplicitThis;
    }

    OverloadedSymbolExp(VarSymbol symbol, LocatedString ident) {
        this.symbols = new LinkedList();
        this.symbols.add(symbol);
        this.ident = ident;
        this.setLocation(ident.location());
    }

    public boolean isAssignable() {
        Internal.error("Overloading resolution should be done before this.");
        return false;
    }

    private Expression uniqueExpression() {
        return new SymbolExp((VarSymbol)this.symbols.get(0), this.location());
    }

    private Expression uniqueExpression(VarSymbol sym, Polytype t) {
        SymbolExp res = new SymbolExp(sym, this.location());
        res.type = t;
        return res;
    }

    Expression resolveOverloading(CallExp callExp) {
        Located res;
        VarSymbol s;
        Arguments arguments = callExp.arguments;
        arguments.computeTypes();
        if (Debug.overloading) {
            Debug.println("Overloading resolution for " + this + "\nwith parameters " + arguments);
        }
        LinkedList<VarSymbol> removed = new LinkedList<VarSymbol>();
        List fieldAccesses = this.filterFieldAccesses();
        Iterator i = this.symbols.iterator();
        block5: while (i.hasNext()) {
            s = (VarSymbol)i.next();
            if (s.isIgnored()) {
                removed.add(s);
                i.remove();
                continue;
            }
            switch (s.match(arguments)) {
                case 0: {
                    removed.add(s);
                    i.remove();
                    continue block5;
                }
                case 1: {
                    i.remove();
                    continue block5;
                }
                case 2: {
                    continue block5;
                }
            }
            Internal.warning("Unknown O.R. case: " + s.getClass());
            i.remove();
        }
        if (this.symbols.size() == 0) {
            if (!this.noImplicitThis && (res = this.givePriorityToFields(fieldAccesses)) != null) {
                return res;
            }
            User.error((Located)this, this.noMatchError(removed, arguments));
        }
        removed.clear();
        i = this.symbols.iterator();
        while (i.hasNext()) {
            s = (VarSymbol)i.next();
            if (Debug.overloading) {
                Debug.println("Overloading: Trying with " + s);
            }
            s.makeClonedType();
            Polytype[] argsType = this.computeArgsType(arguments.getExpressions(s), s.getClonedType(), arguments.getUsedArguments(s));
            Polytype t = CallExp.wellTyped(s.getClonedType(), argsType);
            if (t == null) {
                removed.add(s);
                i.remove();
                s.releaseClonedType();
                continue;
            }
            arguments.types.put(s, t);
        }
        if (this.symbols.size() == 0) {
            if (!this.noImplicitThis && (res = this.givePriorityToFields(fieldAccesses)) != null) {
                return res;
            }
            if (removed.size() == 1) {
                User.error((Located)this, "Arguments " + arguments.printTypes() + " do not fit: \n" + removed.get(0));
            } else {
                User.error((Located)this, "No possible call for " + this.ident + ".\nArguments: " + arguments.printTypes() + "\nPossibilities:\n" + Util.map("", "\n", "", removed));
            }
        }
        OverloadedSymbolExp.removeNonMinimal(this.symbols, arguments);
        OverloadedSymbolExp.removeOverlappingJavaMethods(this.symbols);
        if (this.symbols.size() == 1) {
            res = (VarSymbol)this.symbols.get(0);
            callExp.setComputedType((Polytype)arguments.types.get(res), Types.parameters(((VarSymbol)res).getClonedType()));
            ((VarSymbol)res).releaseClonedType();
            callExp.arguments.computedExpressions = arguments.getExpressions((VarSymbol)res);
            return this.uniqueExpression();
        }
        this.releaseAllClonedTypes();
        throw new AmbiguityError();
    }

    private Polytype[] computeArgsType(Expression[] args, Polytype functionType, int[] usedArguments) {
        Polytype[] res = new Polytype[args.length];
        Monotype[] domain = null;
        for (int i = 0; i < res.length; ++i) {
            if (usedArguments != null && usedArguments[i] == 0) {
                if (domain == null) {
                    Monotype fun2 = Types.rawType(functionType.getMonotype());
                    domain = ((FunType)fun2).domain();
                }
                res[i] = new Polytype((Monotype)domain[i]);
                continue;
            }
            res[i] = args[i].getType();
        }
        return res;
    }

    Expression resolveOverloading(Polytype expectedType) {
        Object symType;
        if (Debug.overloading) {
            Debug.println("Overloading resolution (expected type " + expectedType + ") for " + this);
        }
        LinkedList<VarSymbol> removed = new LinkedList<VarSymbol>();
        List fieldAccesses = this.filterFieldAccesses();
        Iterator i = this.symbols.iterator();
        while (i.hasNext()) {
            VarSymbol s = (VarSymbol)i.next();
            s.makeClonedType();
            try {
                Typing.leq(s.getClonedType(), expectedType);
                if (!Debug.overloading) continue;
                Debug.println(s + "(" + s.location() + ") of type " + s.getClonedType() + " matches");
            }
            catch (TypingEx e) {
                removed.add(s);
                i.remove();
                s.releaseClonedType();
                if (!Debug.overloading) continue;
                Debug.println("Not " + s + " of type\n" + s.getClonedType() + "\nbecause " + e);
            }
        }
        if (this.symbols.size() == 1) {
            VarSymbol s = (VarSymbol)this.symbols.get(0);
            symType = s.getClonedType();
            s.releaseClonedType();
            return this.uniqueExpression(s, (Polytype)symType);
        }
        try {
            Expression res = this.givePriorityToFields(fieldAccesses);
            if (res != null) {
                symType = res;
                return symType;
            }
            if (Types.parameters(expectedType) != null) {
                List nonMin = OverloadedSymbolExp.removeNonMinimal(this.symbols);
                if (this.symbols.size() == 1) {
                    VarSymbol s = (VarSymbol)this.symbols.get(0);
                    Polytype symType2 = s.getClonedType();
                    s.releaseClonedType();
                    this.symbols = nonMin;
                    Expression expression = this.uniqueExpression(s, symType2);
                    return expression;
                }
                this.symbols.addAll(nonMin);
            }
            if (this.symbols.size() != 0) {
                throw new AmbiguityError();
            }
            throw User.error((Located)this, this.noMatchError(removed, expectedType));
        }
        finally {
            this.releaseAllClonedTypes();
        }
    }

    private void releaseAllClonedTypes() {
        Iterator i = this.symbols.iterator();
        while (i.hasNext()) {
            VarSymbol s = (VarSymbol)i.next();
            s.releaseClonedType();
        }
    }

    Expression noOverloading() {
        if (Debug.overloading) {
            Debug.println("(no)Overloading resolution for " + this);
        }
        if (this.symbols.size() == 1) {
            return this.uniqueExpression();
        }
        Expression res = this.givePriorityToFields(this.filterFieldAccesses());
        if (res != null) {
            return res;
        }
        LinkedList<VarSymbol> globalvars = new LinkedList<VarSymbol>();
        Iterator i = this.symbols.iterator();
        while (i.hasNext()) {
            VarSymbol sym = (VarSymbol)i.next();
            if (!(sym instanceof GlobalVarDeclaration.GlobalVarSymbol)) continue;
            globalvars.add(sym);
        }
        if (globalvars.size() > 0 && globalvars.size() < this.symbols.size()) {
            return new OverloadedSymbolExp(globalvars, this.ident).noOverloading();
        }
        if (this.symbols.size() != 0) {
            throw new AmbiguityError();
        }
        throw User.error((Located)this, "No variable or field in this class has name " + this.ident);
    }

    private Expression givePriorityToFields(List fieldAccesses) {
        if (fieldAccesses.size() != 0) {
            if (Node.thisExp != null) {
                try {
                    CallExp res = new CallExp(new OverloadedSymbolExp(fieldAccesses, this.ident, true), new Arguments(new Arguments.Argument[]{new Arguments.Argument(Node.thisExp)}));
                    res.resolveOverloading();
                    return res;
                }
                catch (UserError userError) {
                    // empty catch block
                }
            }
            this.symbols.removeAll(this.filterFieldAccesses());
            if (this.symbols.size() == 1) {
                return this.uniqueExpression();
            }
        }
        return null;
    }

    private List filterFieldAccesses() {
        LinkedList<VarSymbol> res = new LinkedList<VarSymbol>();
        Iterator i = this.symbols.iterator();
        while (i.hasNext()) {
            VarSymbol sym = (VarSymbol)i.next();
            if (!sym.isFieldAccess()) continue;
            res.add(sym);
        }
        return res;
    }

    static List removeNonMinimal(List symbols) {
        ArrayList<VarSymbol> removed = new ArrayList<VarSymbol>();
        if (symbols.size() < 2) {
            return removed;
        }
        int len = symbols.size();
        VarSymbol[] syms = symbols.toArray(new VarSymbol[len]);
        boolean[] remove = new boolean[len];
        block4: for (int s1 = 0; s1 < len; ++s1) {
            Domain d1 = Types.domain(syms[s1].getType());
            for (int s2 = 0; s2 < len; ++s2) {
                if (s1 == s2 || remove[s2]) continue;
                Domain d2 = Types.domain(syms[s2].getType());
                try {
                    Typing.leq(d2, d1);
                    try {
                        Typing.leq(d1, d2);
                        continue;
                    }
                    catch (TypingEx e) {
                        remove[s1] = true;
                        continue block4;
                    }
                }
                catch (TypingEx e) {
                    // empty catch block
                }
            }
        }
        for (int i = 0; i < len; ++i) {
            if (!remove[i]) continue;
            if (Debug.overloading) {
                Debug.println("Removing " + syms[i] + " since it is not minimal");
            }
            removed.add(syms[i]);
            symbols.remove(syms[i]);
        }
        return removed;
    }

    private static void removeNonMinimal(List symbols, Arguments arguments) {
        if (symbols.size() < 2) {
            return;
        }
        int len = symbols.size();
        VarSymbol[] syms = symbols.toArray(new VarSymbol[len]);
        boolean[] remove = new boolean[len];
        block4: for (int s1 = 0; s1 < len; ++s1) {
            Domain d1 = OverloadedSymbolExp.domain(syms[s1].getClonedType(), arguments.getUsedArguments(syms[s1]));
            for (int s2 = 0; s2 < len; ++s2) {
                if (s1 == s2 || remove[s2]) continue;
                Domain d2 = OverloadedSymbolExp.domain(syms[s2].getClonedType(), arguments.getUsedArguments(syms[s2]));
                try {
                    Typing.leq(d2, d1);
                    try {
                        Typing.leq(d1, d2);
                        continue;
                    }
                    catch (TypingEx e) {
                        remove[s1] = true;
                        continue block4;
                    }
                }
                catch (TypingEx e) {
                    // empty catch block
                }
            }
        }
        for (int i = 0; i < len; ++i) {
            if (!remove[i]) continue;
            if (Debug.overloading) {
                Debug.println("Removing " + syms[i] + " since it is not minimal");
            }
            syms[i].releaseClonedType();
            symbols.remove(syms[i]);
        }
    }

    private static Domain domain(Polytype t, int[] usedArguments) {
        Monotype[] dom;
        Monotype[] m = Types.parameters(t.getMonotype());
        if (usedArguments == null) {
            dom = m;
        } else {
            int i;
            int n = 0;
            for (i = 0; i < usedArguments.length; ++i) {
                if (usedArguments[i] == 0) continue;
                ++n;
            }
            dom = new Monotype[n];
            for (i = 0; i < usedArguments.length; ++i) {
                if (usedArguments[i] == 0) continue;
                dom[usedArguments[i] - 1] = m[i];
            }
        }
        return new Domain(t.getConstraint(), dom);
    }

    private static void removeOverlappingJavaMethods(List symbols) {
        if (symbols.size() < 2) {
            return;
        }
        int len = symbols.size();
        VarSymbol[] syms = symbols.toArray(new VarSymbol[len]);
        block0: for (int i = 0; i < syms.length; ++i) {
            for (int j = i + 1; j < syms.length; ++j) {
                if (!OverloadedSymbolExp.overlappingJavaMethods(syms[i].getMethodDeclaration(), syms[j].getMethodDeclaration())) continue;
                symbols.remove(syms[i]);
                continue block0;
            }
        }
    }

    private static boolean overlappingJavaMethods(MethodDeclaration m1, MethodDeclaration m2) {
        if (!(m1 instanceof JavaMethod) || !(m2 instanceof JavaMethod)) {
            return false;
        }
        return Arrays.equals(m1.javaArgTypes(), m2.javaArgTypes());
    }

    void computeType() {
        Internal.error(this, this.ident + " has not been resolved yet.\n" + "Possibilities are :" + this);
    }

    public gnu.expr.Expression compile() {
        Internal.error("compile in " + this.getClass() + " " + this);
        return null;
    }

    public String toString() {
        if (this.symbols.size() <= 1) {
            return "[" + Util.map("", "\n|", "", this.symbols) + "]";
        }
        return "\n[" + Util.map("", "\n|", "", this.symbols) + "]";
    }

    private String noMatchError(List removed, Arguments arguments) {
        switch (removed.size()) {
            case 0: {
                return "No method has name " + this.ident;
            }
            case 1: {
                VarSymbol sym = (VarSymbol)removed.get(0);
                if (sym.isIgnored()) {
                    return sym.getName() + " cannot be used because it has been ignored.\n" + "See above for the reason why it has been ignored";
                }
                return sym.explainWhyMatchFails(arguments);
            }
        }
        return "No method with name " + this.ident + arguments.explainNoMatch(removed);
    }

    private String noMatchError(List removed, Polytype expectedType) {
        switch (removed.size()) {
            case 0: {
                return "No symbol has name " + this.ident;
            }
            case 1: {
                VarSymbol sym = (VarSymbol)removed.get(0);
                return this.ident + " has type " + sym.getType();
            }
        }
        return "No symbol with name " + this.ident + " has type " + expectedType + ":\n" + Util.map("", "\n", "", removed);
    }

    class AmbiguityError
    extends UserError {
        AmbiguityError() {
            super(OverloadedSymbolExp.this, "Ambiguity for symbol " + OverloadedSymbolExp.this.ident + ". Possibilities are :\n" + Util.map("", "\n", "", OverloadedSymbolExp.this.symbols));
        }
    }
}

