/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Expression;
import bossa.syntax.Monotype;
import bossa.syntax.PrimitiveType;
import bossa.syntax.TypeIdent;
import bossa.syntax.TypeMap;
import bossa.util.Located;
import bossa.util.User;
import bossa.util.Util;
import gnu.bytecode.ArrayType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import java.util.List;
import mlsub.typing.Constraint;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeVar;
import mlsub.typing.NullnessKind;
import mlsub.typing.Polytype;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;
import nice.tools.code.MultiArrayNewProc;
import nice.tools.code.Types;

public class NewArrayExp
extends Expression {
    private TypeSymbol resolvedType;
    final TypeIdent ident;
    Expression[] knownDimensions;
    private int unknownDimensions;

    public NewArrayExp(TypeIdent type, List knownDimensions, int unknownDimensions) {
        this.ident = type;
        this.knownDimensions = NewArrayExp.toArray(knownDimensions);
        this.unknownDimensions = unknownDimensions;
    }

    void resolveTC(TypeMap typeScope) {
        this.resolvedType = this.ident.resolveToTypeSymbol(typeScope);
    }

    void computeType() {
        int i;
        mlsub.typing.Monotype monotype;
        TypeSymbol[] nullVars;
        Constraint cst = Constraint.True;
        boolean zero = NewArrayExp.findZero(this.knownDimensions);
        if (zero) {
            nullVars = new TypeConstructor[this.unknownDimensions + 1];
            for (int i2 = 0; i2 < nullVars.length; ++i2) {
                nullVars[i2] = new TypeConstructor("n" + i2, PrimitiveType.maybeTC.variance, false, false);
            }
        } else {
            nullVars = null;
        }
        boolean sure = false;
        if (this.resolvedType instanceof MonotypeVar) {
            MonotypeVar res = (MonotypeVar)this.resolvedType;
            monotype = res.getKind() == NullnessKind.instance ? nice.tools.typing.Types.rawType(res.equivalent()) : res;
        } else if (this.resolvedType == TopMonotype.instance) {
            monotype = TopMonotype.instance;
        } else {
            if (!(this.resolvedType instanceof TypeConstructor)) {
                User.error((Located)this.ident, this.ident + " should be a class");
            }
            TypeConstructor tc = (TypeConstructor)this.resolvedType;
            monotype = new MonotypeConstructor(tc, MonotypeVar.news(tc.arity()));
            if (nice.tools.typing.Types.isPrimitive(tc)) {
                sure = true;
            }
        }
        if (sure) {
            monotype = Monotype.sure(monotype);
        } else if (nullVars == null) {
            monotype = Monotype.maybe(monotype);
        } else {
            monotype = MonotypeConstructor.apply(nullVars[nullVars.length - 1], monotype);
            cst = new Constraint(nullVars, null);
        }
        for (i = 0; i < this.unknownDimensions; ++i) {
            monotype = new MonotypeConstructor(PrimitiveType.arrayTC, new mlsub.typing.Monotype[]{monotype});
            monotype = nullVars != null ? MonotypeConstructor.apply((TypeConstructor)nullVars[i], monotype) : Monotype.maybe(monotype);
        }
        for (i = 0; i < this.knownDimensions.length; ++i) {
            monotype = Monotype.sure(MonotypeConstructor.apply(PrimitiveType.arrayTC, monotype));
        }
        this.type = new Polytype(cst, monotype);
    }

    private static boolean findZero(Expression[] exps) {
        for (int i = 0; i < exps.length; ++i) {
            if (!exps[i].isZero()) continue;
            return true;
        }
        return false;
    }

    public gnu.expr.Expression compile() {
        Type t = Types.javaType(this.type);
        return new ApplyExp(new MultiArrayNewProc((ArrayType)t, this.knownDimensions.length), Expression.compile(this.knownDimensions));
    }

    public String toString() {
        StringBuffer res = new StringBuffer("new " + this.ident + Util.map("[", "][", "]", this.knownDimensions));
        for (int i = 0; i < this.unknownDimensions; ++i) {
            res.append("[]");
        }
        return res.toString();
    }
}

