/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Arguments;
import bossa.syntax.Constraint;
import bossa.syntax.FormalParameters;
import bossa.syntax.FunType;
import bossa.syntax.LocatedString;
import bossa.syntax.Monotype;
import bossa.syntax.PolySymbol;
import bossa.syntax.Polytype;
import bossa.util.Internal;
import bossa.util.Util;
import nice.tools.typing.Types;

class FunSymbol
extends PolySymbol {
    FormalParameters parameters;
    int arity;

    FunSymbol(LocatedString name, Constraint constraint, FormalParameters parameters, Monotype returnType) {
        super(name, new Polytype(constraint, new FunType(parameters.types(), returnType)));
        this.parameters = parameters;
        this.arity = parameters.size;
    }

    FunSymbol(LocatedString name, mlsub.typing.Polytype type, FormalParameters parameters, int arity) {
        super(name, null);
        this.parameters = parameters;
        this.arity = arity;
        this.type = type;
    }

    String describeParameters() {
        if (this.parameters != null) {
            return this.parameters.toString();
        }
        mlsub.typing.Monotype m = Types.rawType(this.getType().getMonotype());
        if (m instanceof mlsub.typing.FunType) {
            return Util.map("", ", ", "", ((mlsub.typing.FunType)m).domain());
        }
        Internal.warning(this, "Non functional type in a functional symbol");
        return "";
    }

    int match(Arguments arguments) {
        if (this.parameters == null ? !arguments.plainApplication(this.arity, this) : !this.parameters.match(arguments, this)) {
            return 0;
        }
        return 2;
    }

    String explainWhyMatchFails(Arguments arguments) {
        if (this.isFieldAccess()) {
            if (arguments.size() == 0) {
                return this.name + " is not defined";
            }
            return this.name + " is a field of class " + this.describeParameters();
        }
        return "Method " + this.name + " expects parameters (" + this.describeParameters() + ")";
    }
}

